
double dtincomplete_california(double mag){
  double dum, dt, dtmin;

  dtmin=1e-4;   // if less than dtmin =~ 8 sec then incompleteness is ignored

  // California: dum = (mag-Mcut-4.5)/0.75; 
  dum = (mag-Mcut-4.5)/0.75; 
  dt=pow(10.0,dum);

  if(dt<=dtmin) dt=0.0;

  return dt;
}


void completeness(int printfile)
{
  FILE     *fout;
  double   dum, dt, time, t0, t1, eps;
  int      i, k, count1, count2;

  eps=1e-10;   // make sure that the events are really included

  // Adapting the observed incompleteness of catalogs after larger earthquakes, we adopt the function for California (Helmstetter et al., BSSA 2006) 
  // M_cut(M,\Delta{t})=M-4.5-0.75 \log_{10}(\Delta{t})  for M>=2 in California
       
  k=0;

  t0=T1;  // start time of completeness
  for(i=1;i<=Zall;i++){
    time = tall[i];
    
    if(setdt==1) dt = dtincomplete_california(mall[i]);
    else         dt = 0.0;

    if(dt>0){
      // case-1: if time>t1: completeness ends
      if(time>t0){
	k++;
	tc[1][k]=t0; tc[2][k]=time+eps;
	t0=time+dt;
      }
      else if(time+dt>t0) t0=time+dt;
    }
  }

  if(T2>t0){
    k++;
    tc[1][k]=t0; tc[2][k]=T2;
  }
  NK=k;

  if(printfile==1){
    fout=fopen("output/testcompleteness.out","w");
    for(k=1;k<=NK;k++) fprintf(fout,"%d\t%lf\t%lf\n",k,tc[1][k],tc[2][k]);
    fclose(fout);
  }
}
  
void determinespaceweights(long ZZ, double *ti, double *lati, double *loni, double *mi, double *wD, double *wDL, int *ingrid)
{
  FILE     *fout;
  double   *maxfr, lat0, lon0, sum1, sum2, maxfr1, maxfr2, fr, d, d0, q, pi, rr, latmean, lonmean, dumlat, dumlon, L, dL, mag, minmag, maxmag;
  int      i, k, n, n1, n2, igrid, imin, imax, idum, sett, N;
 
  d  = Dvalue; 
  d0 = D0value;
  q  = Qvalue;
  pi = 3.14159265358979;


  // total sum of fr-contributions on gridpoints of an infinite grid with dlat and dlon spacing for an event occurring on a grid-point:
  latmean=0.0; for(n=1;n<=Ngrid;n++) latmean+=gridlat[n]/(1.0*Ngrid);
  lonmean=0.0; for(n=1;n<=Ngrid;n++) lonmean+=gridlon[n]/(1.0*Ngrid);

  N=1000;

  maxfr1=0.0;
  for(n1=-N;n1<=N;n1++) for(n2=-N;n2<=N;n2++){
    rr = distance(latmean+n1*dlat,lonmean+n2*dlon,latmean,lonmean);
    fr = (q/pi)*pow(d,2.0*q)/pow(sq(rr)+sq(d),1+q);
    maxfr1 += fr;
  }
 
  maxmag=-10.0;  
  minmag= 10.0; 
  for(i=1;i<=ZZ;i++){ 
    mag=mi[i]; 
    if(mag<minmag) minmag=mag; 
    if(mag>maxmag) maxmag=mag; 
  }
  imin = (int) (10.0*minmag+0.5);
  imax = (int) (10.0*maxmag+0.5);

  i=imin;
  dL = d0 * pow(10.0,-2.44+0.59*minmag);
  while(dL<locerror){
    i++;
    mag = 0.1*i;
    dL = d0 * pow(10.0,-2.44+0.59*mag);
    if(dL<=locerror) imin=i;
  }

  maxfr=dvector(imin,imax);

  for(i=imin;i<=imax;i++){
    mag = 0.1*i;
    L   = pow(10.0,-2.44+0.59*mag);  // subsurface rupture length all mechanisms: Wells & Coppersmith, BSSA 1994, Tab.2a:
    dL  = d0*L;
    if(dL<locerror) dL=locerror;

    maxfr[i]=0.0;
    for(n1=-N;n1<=N;n1++) for(n2=-N;n2<=N;n2++){
      rr = distance(latmean+n1*dlat,lonmean+n2*dlon,latmean,lonmean);
      fr = (q/pi)*pow(dL,2.0*q)/pow(sq(rr)+sq(dL),1+q);
      maxfr[i] += fr;
    }
    //printf("\t i=%d  mag=%.2lf  maxfr=%lf\n",i,mag,maxfr[i]);
  }
   

  // now calculate sum for each earthquake:
  for(i=1;i<=ZZ;i++){
    mag = mi[i];

    idum = (int) (10.0*mag+0.5);
    if(idum<imin) idum=imin;
    maxfr2=maxfr[idum];
    
    mag=0.1*idum;
    dL  = d0*pow(10.0,-2.44+0.59*mag);  
    if(dL<locerror) dL=locerror;
  
    sett=0; 
    for(n=1;n<=Ngrid;n++) if(lati[i]>=gridlat[n]-0.5*dlat && lati[i]<=gridlat[n]+0.5*dlat) if(loni[i]>=gridlon[n]-0.5*dlon && loni[i]<=gridlon[n]+0.5*dlon){ sett=1; igrid=n; }
    if(sett==1){ ingrid[i]=1; lat0=gridlat[igrid]; lon0=gridlon[igrid]; }
    else       { ingrid[i]=0; lat0=lati[i];        lon0=loni[i];        }

    //if(sett==0) if(lati[i]>=-44.0 && lati[i]<=-43.0) if(loni[i]>=171.5 && loni[i]<=173.5) printf("i=%d lati=%lf  loni=%lf \n",i,lati[i],loni[i]);

    sum1=0.0; sum2=0.0; 
    for(n=1;n<=Ngrid;n++){
      rr = distance(gridlat[n],gridlon[n],lat0,lon0);
      fr = (q/pi)*pow(d ,2.0*q)/pow(sq(rr)+sq(d ),1+q);  sum1 += fr;
      fr = (q/pi)*pow(dL,2.0*q)/pow(sq(rr)+sq(dL),1+q);  sum2 += fr;
    }
    wD[i]  = sum1/maxfr1;
    wDL[i] = sum2/maxfr2;

    //if(wDL[i]<0.9) if(lati[i]>=-44.0 && lati[i]<=-43.0) if(loni[i]>=171.5 && loni[i]<=173.5) printf("i=%d lati=%lf  loni=%lf  mag=%lf  wDL=%lf\n",i,lati[i],loni[i],mag,wDL[i]);

  }
  free_dvector(maxfr,imin,imax);

  
  fout=fopen("output/testweights1.out","w");
  for(k=1;k<=ZZ;k++) fprintf(fout,"%d\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\n",k,ti[k],lati[k],loni[k],mi[k],wD[k],wDL[k]);
  fclose(fout);
}


void selectLLevents(double *locerr, int printfile)
{
  double   time, xlat, xlon, mag, min, rr, dumerr;
  int      i, k, n,  ndropped, setLL;

  // location error is minimum value for d= d0*L(M): 
  locerror=0.0;

  n=0; ndropped=0; 
  for(i=1;i<=Zall;i++){
    time = tall[i];
    xlat = latall[i];
    xlon = lonall[i];
    mag  = mall[i];

    dumerr = locerr[i];

    if(insidegrid[i]==1){
      setLL=0;
      for(k=1;k<=NK;k++) if(time>=tc[1][k] && time<=tc[2][k]) setLL=1;
      if(setLL==0) ndropped++;
      else{
	n++;
	t[n]   = time;
	lat[n] = xlat;
	lon[n] = xlon;
	m[n]   = mag;
	
	locerror += dumerr;

	// calculate the corresponding grid-point:
	for(k=1;k<=Ngrid;k++) if(lat[n]>=gridlat[k]-0.5*dlat && lat[n]<=gridlat[k]+0.5*dlat) if(lon[n]>=gridlon[k]-0.5*dlon && lon[n]<=gridlon[k]+0.5*dlon) indgrid[n]=k;
      }
    }
    else ndropped++;
  }
  Z=n;
  if(printfile==1) printf("--> events with M>=%.1lf inside likelihood space-time volume:  Z=%d (%d events dropped)\n\n",Mcut,Z,ndropped);

  locerror /= 1.0*Z;
  if(locerror<0.5) locerror=0.5;  // [km]
}

int testmagcompleteness(int i0)
{
  double  *mm, dmag, dmag1;
  int     i, k, n, i1, i2, N, Nbin, NM, setcomplete;

  // test whether the magnitude-range increases for subsequent Nbin events (expected for complete part of the frequency-magnitude distribution)

  // test whether m[i] for i=i0,...Z are complete
  N=Z+1-i0;
  mm=dvector(1,N);
  for(i=1;i<=N;i++) mm[i]=m[i0-1+i];
  sortd(N,mm);

  Nbin=100;   // number for the subsequent magnitude bins are calculated 
  NM=(int) ((1.0*N)/(1.0*Nbin));

  setcomplete=1;

  for(n=1;n<=NM;n++){
    i1= 1+(n-1)*Nbin;
    i2= n*Nbin;
    dmag = mm[i2]-mm[i1];

    if(n==1) dmag1=dmag;
    else if(dmag<dmag1){ setcomplete=0; printf("Mcut=%.2lf: mm[%d]-mm[%d]=%lf (while mm[%d]-mm[%d]=%lf) --> setcomplete=0\n",Mcut,i2,i1,dmag,Nbin,1,dmag1); }
  }

  free_dvector(mm,1,N);

  return setcomplete;
}

void readcatalog()
{
  double  **datas, *wD, *wDL, *ti, *lati, *loni, *mi, *locerri, *locerr;
  double  mag, time, c, p, eps, magweight, timeweight, timeweight0, dum, dum1, dum2, tt1, tt2;
  double  latmin, latmax, lonmin, lonmax, degbuffer, sec;
  int     *ingrid, i, k, n, i0, kall, nyy, nmm, ndd, nhh, nmin, nsec, nlon, nlat, nm, nz, nerr, ni, S, Ntitle, setcomplete;
  int     yy, mm, dd, hh, min;
  long    Z0, Z1, Zmax;
 
  eps=1e-3;

  Zmax=1000000;    
  tall       = dvector(1,Zmax);
  latall     = dvector(1,Zmax);
  lonall     = dvector(1,Zmax);
  mall       = dvector(1,Zmax);
  indgridall = ivector(1,Zmax);       // index of corresponding grid-point
 
  // selected events in LL-space:
  t          = dvector(1,Zmax);
  lat        = dvector(1,Zmax);
  lon        = dvector(1,Zmax);
  m          = dvector(1,Zmax);
  indgrid    = ivector(1,Zmax);       // index of corresponding grid-point
 
 
  Ntitle = 0;     // number of title lines
  S      = 15;     // number of colums

  nlon   = 1;     // column of longitude
  nlat   = 2;     // column of latitude
  nyy    = 3;     // column of years
  nmm    = 4;     // column of months
  ndd    = 5;     // column of days
  nm     = 6;     // column of magnitude
  nz     = 7;     // column of depth
  nhh    = 8;     // column of hours
  nmin   = 9;     // column of minutes
  nsec   = 10;    // column of seconds
  nerr   = 11;    // column of horizontal error

  datas=dmatrix(1,S,1,Zmax); 
  einlese(catalogfile,S,Ntitle,datas,&Z0);
  printf("\t ... catalog with %d events read\n",Z0);

  // **********************************************
  tc         = dmatrix(1,2,1,Z0);
  xweightD   = dvector(1,Z0);
  xweightDL  = dvector(1,Z0);
  insidegrid = ivector(1,Z0);       // if=1 then corresponding event is inside grid


  // help-vectors:
  ti      = dvector(1,Z0);
  lati    = dvector(1,Z0);
  loni    = dvector(1,Z0);
  mi      = dvector(1,Z0);
  locerri = dvector(1,Z0);
  locerr  = dvector(1,Z0);
  wDL     = dvector(1,Z0);
  wD      = dvector(1,Z0);
  ingrid  = ivector(1,Z0);

  Mcut = Mcutpredict-1.0;


  latmin= 1e6; 
  latmax=-1e6;
  lonmin= 1e6; 
  lonmax=-1e6;
  for(n=1;n<=Ngrid;n++){
    if(gridlat[n]<latmin) latmin=gridlat[n]-0.5*dlat;
    if(gridlat[n]>latmax) latmax=gridlat[n]+0.5*dlat;
    if(gridlon[n]<lonmin) lonmin=gridlon[n]-0.5*dlat;
    if(gridlon[n]>lonmax) lonmax=gridlon[n]+0.5*dlat;
  }

  degbuffer = 2.0;

  k=0;
  for(i=1;i<=Z0;i++) 
    if(datas[nz][i]<=maxdepth) 
      if(datas[nlat][i]>latmin-degbuffer && datas[nlat][i]<latmax+degbuffer) 
	if(datas[nlon][i]>lonmin-degbuffer && datas[nlon][i]<lonmax+degbuffer)  
	  if(datas[nm][i]>=Mcut){

	    yy  = (int) datas[nyy][i];
	    mm  = (int) datas[nmm][i];
	    dd  = (int) datas[ndd][i];
	    hh  = (int) datas[nhh][i];
	    min = (int) datas[nmin][i];
	    sec = datas[nsec][i];
	    calculatejulday(yy,mm,dd,hh,min,sec,&time);
	  
	    //if(datas[nm][i]>7.0) printf("time=%lf  T2=%lf  mag=%lf \n",time,T2,datas[nm][i]);

	    if(time<=T2){
	      k++;

	      ti[k]      = time;
	      lati[k]    = datas[nlat][i];
	      loni[k]    = datas[nlon][i];
	      mi[k]      = datas[nm][i];
	      locerri[i] = datas[nerr][i];
	    }
	  }
  Z1=k;

  free_dmatrix(datas,1,S,1,Zmax);
 
  // determines wD[i], wDL[i] and ingrid[i]
  determinespaceweights(Z1,ti,lati,loni,mi,wD,wDL,ingrid);
  printf("\t ... xweights for %d events calculated\n",Z1);


  setcomplete=0;

  while(Mcut<=Mcutpredict && setcomplete==0){
    
    T1 = ti[1];

    // determine all contributing events:
    k=0;
    for(i=1;i<=Z1;i++){
      mag = mi[i]-Mcut;
      magweight = pow(10.0,mag);
      
      if(ingrid[i]==0) dum=wDL[i]*magweight;
      else             dum=magweight;

      if(dum>=1.0-eps){
	k++;
	tall[k]       = ti[i];
	latall[k]     = lati[i];
	lonall[k]     = loni[i];
	mall[k]       = mi[i];
	locerr[i]     = locerri[i];
	xweightD[k]   = wD[i];
	xweightDL[k]  = wDL[i];
	insidegrid[k] = ingrid[i];
      }
    }
    Zall=k;
    
    completeness(0);   // determine completeness time intervals: nk=1,...NK: [ tc[1][nk] : tc[2][nk] ]
    selectLLevents(locerr,0); // select the events in the LL-space
    
    if(Z>Nmax) i0=1+Z-Nmax;
    else       i0=1;
    
    // if=1 then complete
    setcomplete=testmagcompleteness(i0);
  
    //printf("... Mcut=%lf  T1=%lf",Mcut,T1);

    if(i0>=2)  T1 = 0.5*(t[i0-1]+t[i0]);
    else       T1 = t[1];

    if(T2-T1<dTmin && T1>ti[1]){ Mcut+=0.1; setcomplete=0; }
    else if(setcomplete==0)      Mcut+=0.1;
    //printf("    setcomplete=%d\n",setcomplete);
  }

  printf("\n\t --> Mcut=%.1lf (>= Mcutpredict-1=%.1lf)  &  starting of optimization time period: T1=%.2lf [days]\n\n",Mcut,Mcutpredict-1,T1);
  
  // for determined completeness intervalls for final T1:
  completeness(1);
           
  // timeweight for an event occurring at the beginning of the time period [T1, T2] assuming:
  c   = 0.01;  // [days]
  p   = 1.1;
  tt2 = 1.0+(T2-T1)/c;
  if(T2-T1>Tafter) tt2 = 1.0+Tafter/c; 

  timeweight0 = (1.0-pow(tt2,1.0-p));

  // selection of events contributing to the calculated ETAS-rates:
  k=0;
  for(i=1;i<=Z1;i++){
    time      = T1-ti[i];  if(time<0.0) time=0.0;
    mag       = mi[i]-Mcut;
    magweight = pow(10.0,mag);
 
    // fraction of Na in [time,time+T2-T1]:
    if(time>0.0){
      if(time<Tafter){
	tt1  = 1.0+time/c;
	tt2  = 1.0+(time+T2-T1)/c;
	if(time+T2-T1>Tafter) tt2 = 1.0+Tafter/c; 
	dum1 = pow(tt1,1.0-p);
	dum2 = pow(tt2,1.0-p);
	timeweight = (dum1-dum2)/timeweight0;  // relative weight of events occurring before T1 relative to events occurring inside [T1,T2]
      }
      else timeweight=0.0;
    }
    else timeweight=1.0;

    if(ingrid[i]==0) dum=wDL[i]*magweight*timeweight;
    else             dum=magweight*timeweight;
   
    if(dum>=1.0-eps){
      k++;
      tall[k]       = ti[i];
      latall[k]     = lati[i];
      lonall[k]     = loni[i];
      mall[k]       = mi[i];
      locerr[k]     = locerri[i];
      xweightD[k]   = wD[i];
      xweightDL[k]  = wDL[i];
      insidegrid[k] = ingrid[i];  
      if(insidegrid[k]==1) for(n=1;n<=Ngrid;n++) if(latall[k]>=gridlat[n]-0.5*dlat && latall[k]<=gridlat[n]+0.5*dlat) if(lonall[k]>=gridlon[n]-0.5*dlon && lonall[k]<=gridlon[n]+0.5*dlon) indgridall[k]=n;
      //if(k==1) printf("k=1 tall=%lf timeweight=%.2lf  (T1=%.2lf  T1-tall=%.2lf !<! Tafter=%.2lf) magweight=%lf  (dum=%lf)  xweightD[k]=%lf   xweightDL[k]=%lf\n",tall[k],timeweight,T1,T1-tall[k],Tafter,magweight,dum,xweightD[k],xweightDL[k]);
    }
  }
  Zall=k;

  printf("\n--> events contributing to the ETAS-rate calculation:  Zall=%d\n",Zall);
  printf("\n--> (mean horizontal) locerror=%lf [km]\n\n",locerror);

  selectLLevents(locerr,1); // select the events in the LL-space

  // predefine and preset distribution of direct aftershocks (including the event itself):
  Nepi     = ivector(1,Zall);
  Indexepi = imatrix(1,Zall,1,Zall);
  for(i=1;i<=Zall;i++){ Nepi[i]=1; Indexepi[i][1]=i; }

  // definitions:
  spaceweightall = dmatrix(1,Zall,1,Z);
  setmain        = ivector(1,Zall);            // index of the probability-map which corresponds to earthquake-index (=0 if no slip-map exists)
  for(i=1;i<=Zall;i++){
    setmain[i]=0;
    for(k=1;k<=Z;k++) spaceweightall[i][k]=0.0; 
  }

  free_dvector(ti,1,Z0);
  free_dvector(lati,1,Z0);
  free_dvector(loni,1,Z0);
  free_dvector(mi,1,Z0);
  free_dvector(locerri,1,Z0);
  free_dvector(locerr,1,Z0);
  free_dvector(wD,1,Z0);
  free_dvector(wDL,1,Z0);
  free_ivector(ingrid,1,Z0);

  
}

