#include "write_testoutput.c"

void probr(double lat0, double lon0, double q, double d, double *lata, double *lona, long *idum){
  double  rr, dum, pi, km2lat, km2lon;
  long    seed;

  seed=*idum;
  
  pi=3.14159265358979;

  km2lat=1.0/distance(lat0-0.5,lon0,lat0+0.5,lon0);  
  km2lon=1.0/distance(lat0,lon0-0.5,lat0,lon0+0.5);  

  dum=ran1(&seed);
  rr = d*sqrt( pow(1.0-dum, -1.0/q) - 1.0 );
 
  dum=ran1(&seed);
  *lata    = lat0 + rr*km2lat*cos(2.*pi*dum);
  *lona    = lon0 + rr*km2lon*sin(2.*pi*dum);

  *idum=seed;
}

void probrdL(double lat0, double lon0, double mag, double q, double *lata, double *lona, long *idum){
  double  rr, dum, pi, L, dL, km2lat, km2lon;
  long    seed;

  seed=*idum;
  
  pi=3.14159265358979;

  km2lat=1.0/distance(lat0-0.5,lon0,lat0+0.5,lon0);  
  km2lon=1.0/distance(lat0,lon0-0.5,lat0,lon0+0.5);  

 // subsurface rupture length all mechanisms: Wells & Coppersmith, BSSA 1994, Tab.2a:
  L  = pow(10.0,-2.44+0.59*mag); 
  dL = D0value*L;
  if(dL<locerror) dL=locerror;

  dum=ran1(&seed);
  rr = dL*sqrt( pow(1.0-dum, -1.0/q) - 1.0 );
 
  dum=ran1(&seed);
  *lata    = lat0 + rr*km2lat*cos(2.*pi*dum);
  *lona    = lon0 + rr*km2lon*sin(2.*pi*dum);

  *idum=seed;
}


void simulation(double tstart, double tend, double b, double Mmax, int *ZZ, double *tt, double *llat, double *llon, double *mm, long *seed0){
  double  mu, c, p, M0, N0, q, d, alpha,  norm, Na, sum;
  double  dum, timeaft, timerem, rho, mag, TT, n1, n2, n3, tbg, M, xa, ya;
  int     i, k, ii, jj, k0, lcat, lcat0, NE, idum;
  long    seed;

  seed=*seed0;
 
  mu    = MUvalue;
  c     = Cvalue;
  p     = Pvalue;
  M0    = M0value;          
  N0    = N0value;           
  alpha = ALPHAvalue;     
  q     = Qvalue; 
  d     = Dvalue;

  // normalization factor due to Tafter:
  norm = 1.0/(1.0-pow(1.0+Tafter/c,1.0-p));


  for(k=1;k<=Zall;k++) if(tall[k]<=tstart){
    mm[k]   = mall[k];
    tt[k]   = tall[k];
    llat[k] = latall[k];
    llon[k] = lonall[k];

    k0=k;
  }
  lcat=k0;
  lcat0=k0;

/* ---------tectonic loading */
  if (mu>0){
    tbg=tstart;
    while(tbg<tend){
      dum=ran1(&seed);
      tbg+= -log(dum)/mu;

      if(tbg<=tend){
        M=Mmax+1.;
        while(M>Mmax) M= Mcut-log10(ran1(&seed))/b;

        lcat++;
        tt[lcat] = tbg;
        mm[lcat] = M;

	// spatial distribution:
	if(spacebackground==1){
	  dum=ran1(&seed);
	  jj=0; sum=0.0;
	  while(sum<dum && jj<Ngrid){
	    jj++;
	    sum+=probback[jj];
	  }
	  llat[lcat] = gridlat[jj] + (ran1(&seed)-0.5)*dlat;
	  llon[lcat] = gridlon[jj] + (ran1(&seed)-0.5)*dlon;
	}
	else{
	  idum=(int) (1+Ngrid*ran1(&seed));
	  llat[lcat] = gridlat[idum] + (ran1(&seed)-0.5)*dlat;
	  llon[lcat] = gridlon[idum] + (ran1(&seed)-0.5)*dlon;
	}
	//printf("background: lcat=%d  lat=%lf  lon=%lf\n",lcat,llat[lcat],llon[lcat]);
      }
    }
  }

  /* aftershocks in [tstart, tend] */
  k=1;
  while(k<=lcat){
    mag=mm[k];

    if(setRETAS==1){
      if(mag<=Mstar) Na = C*pow(10.0,1.5*mag)/M0;
      else           Na = C*Cstar*pow(10.0,alpha0*mag)/M0;
    }
    else Na = N0*pow(10.0,alpha*(mag-Mcut));

    // to be equivalent to K*exp(alpha*(mag-Mcut))*(c+t)^-p and
    // rho = K*exp(alpha*mag):
    rho = Na * (p-1.0) * pow(c,p-1.0) * norm; 

    if(tt[k]>=tstart) timeaft = 0.0;
    else              timeaft = tstart-tt[k];
    timerem = tend-tt[k];
    if(timerem>Tafter) timerem=Tafter;

    while(timeaft<timerem){
      dum=ran1(&seed);
      if(p==1.0){
        TT = exp(log(c+timeaft) - (1/rho)*log(dum)) - c - timeaft;
        timeaft = timeaft + TT;
      }
      else{
        n3 = exp((rho/(1.0-p))*pow(timeaft+c,1.0-p));
        if(p>1.0 && dum<n3) timeaft = timerem + 1.0;
        else{
          n1 = pow(timeaft+c,1.0-p);
          n2 = (1.0 - p)*log(dum)/rho;
          TT = pow(n1-n2,1.0/(1.0-p)) - c - timeaft;
          timeaft = timeaft + TT;
        }
      }
      if(timeaft<timerem){
        M=Mmax+1.;
        while(M>Mmax) M = Mcut-log10(ran1(&seed))/b;

        lcat++;
        tt[lcat] = tt[k] + timeaft;
        mm[lcat] = M;

	// spatial distribution:
	if(k<=Zall){
	  if(useMainshockprobmaps==0 || setmain[k]==0){
	    NE = Nepi[k];      
	    idum = (int) (1+NE*ran1(&seed));
	    jj = Indexepi[k][idum];
	    if(tall[jj]>tstart){ printf("\n\t SOMETHING WRONG HERE: jj=%d  tall[jj]=%lf > tstart=%lf  ... exit!\n\n",jj,tall[jj],tstart); exit(1); }
	    if(jj<1 || jj>Zall) printf("k=%d  Zall=%d  NE=%d  idum=%d  jj=%d\n",k,Zall,NE,idum,jj); 
	    probr(latall[jj],lonall[jj],q,d,&xa,&ya,&seed);
	  }
	  else if(setmain[k]>=1){
	    ii=setmain[k];
	    dum=ran1(&seed);
	    jj=0; sum=0.0;
	    while(sum<dum && jj<Ngrid){
	      jj++;
	      if(useMainshockprobmaps==1)      sum+=probmain[ii][jj];
	      else if(useMainshockprobmaps==2) sum+=probmaindist[ii][jj];
	    }
	    xa = gridlat[jj] + (ran1(&seed)-0.5)*dlat;
	    ya = gridlon[jj] + (ran1(&seed)-0.5)*dlon;
	  }

	}
	else probrdL(llat[k],llon[k],mag,q,&xa,&ya,&seed);
	//else probr(llat[k],llon[k],q,d,&xa,&ya,&seed);

	llat[lcat] = xa;
	llon[lcat] = ya;
	//if(k<=Zall) printf("aftershocks: lcat=%d  lat=%lf  lon=%lf  (k=%d  Zall=%d  lat0=%lf  lon0=%lf  NE=%d  jj=%d)\n",lcat,llat[lcat],llon[lcat],k,Zall,latall[jj],lonall[jj],NE,jj);
	//else  printf("aftershocks: lcat=%d  lat=%lf  lon=%lf  (k=%d  Zall=%d  lat0=%lf  lon0=%lf  ya=%lf  ya=%lf)\n",lcat,llat[lcat],llon[lcat],k,Zall,llat[k],llon[k],xa,ya);
      }
    }
    k++;
  }
  *ZZ = lcat;

  /* printf("lcat=%d  lcat0=%d  nres=%d\n",lcat,lcat0,nres); */

  *seed0=seed;
}

void write_template(double *meancell, char *templatefile, char *resfile)
{
  FILE    *fin, *fout; 
  double  lon1, lon2, lat1, lat2, mag1, mag2, dep1, dep2, dum, resall, resmagbin;
  int     n, idum, ans;
  
  fout = fopen(resfile,"w");
  fin  = fopen(templatefile,"r");

  ans=fscanf(fin,"%lf",&lon1);
  while(ans!=EOF){
    fprintf(fout,"%.2lf ",lon1);
    ans=fscanf(fin,"%lf",&lon2);  fprintf(fout,"%.2lf ",lon2);
    ans=fscanf(fin,"%lf",&lat1);  fprintf(fout,"%.2lf ",lat1);
    ans=fscanf(fin,"%lf",&lat2);  fprintf(fout,"%.2lf ",lat2);
    ans=fscanf(fin,"%lf",&dep1);  fprintf(fout,"%.2lf ",dep1); 
    ans=fscanf(fin,"%lf",&dep2);  fprintf(fout,"%.2lf ",dep2);
    ans=fscanf(fin,"%lf",&mag1);  fprintf(fout,"%.2lf ",mag1);  
    ans=fscanf(fin,"%lf",&mag2);  fprintf(fout,"%.2lf ",mag2); 
    ans=fscanf(fin,"%lf",&dum);   
    ans=fscanf(fin,"%d",&idum); 
 
    resall=0.0;
    for(n=1;n<=Ngrid;n++) if(gridlon[n]>=lon1 && gridlon[n]<=lon2 && gridlat[n]>=lat1 && gridlat[n]<=lat2) resall+=meancell[n];

    resmagbin = resall * ( pow(10.0,-bvalue*(mag1-Mcutpredict)) -  pow(10.0,-bvalue*(mag2-Mcutpredict)) );
    fprintf(fout,"%e ",resmagbin); 
    fprintf(fout,"1\n"); 
    ans=fscanf(fin,"%lf",&lon1);
  }
  fclose(fin);
  fclose(fout);
}

void  simulationforecast(char *suffx, int Nsur, double Mcutpredict, double T, char *templatefile, char *resfile){
  //FILE   *fout1, *fout2;
  char   outname[160];
  double *meancell, *mm, *tt, *llat, *llon;
  double tstart, tend, Mmax, dum, sum, mean, min, fac;
  int    i, j, k, n, idum, count, sett, ZZ, NT;
  long   seed, Zmax;

  if(setRETAS==1) printf("forecast: mu=%lf  c=%lf  p=%lf  M0=%lf\n",MUvalue,Cvalue,Pvalue,M0value);
  else            printf("forecast: mu=%lf  c=%lf  p=%lf  N0=%lf alpha=%lf\n",MUvalue,Cvalue,Pvalue,N0value,ALPHAvalue);

  seed=3192836912;

  tstart=T2;
  tend  =T2+T;

  Mmax=Mcut+3.0; 

  Zmax=Zall+10000000;
  mm   = dvector(1,Zmax);
  tt   = dvector(1,Zmax);
  llat = dvector(1,Zmax);
  llon = dvector(1,Zmax);

  meancell = dvector(1,Ngrid);
  for(n=1;n<=Ngrid;n++) meancell[n]=0.0;

  //NT = (int) (1+T);
  //forecast = dvector(1,NT);
  //for(i=1;i<=NT;i++) forecast[i]=0.0;
  //fout1=fopen("output/testforecastcatalog-inside.out","w");
  //fout2=fopen("output/testforecastcatalog-outside.out","w");

  mean=0.0;
  for(i=1;i<=Nsur;i++){
    
    simulation(tstart,tend,bvalue,Mmax,&ZZ,tt,llat,llon,mm,&seed);
 
    for(k=1;k<=ZZ;k++) if(tt[k]>tstart) if(mm[k]>=Mcutpredict){
      sett=0;
      for(n=1;n<=Ngrid;n++) if(llat[k]>=gridlat[n]-0.5*dlat && llat[k]<gridlat[n]+0.5*dlat) if(llon[k]>=gridlon[n]-0.5*dlon && llon[k]<gridlon[n]+0.5*dlon){
	meancell[n] += 1.0/(1.0*Nsur);   
	mean += 1.0/(1.0*Nsur);
	sett=1;
      }
      //if(sett==1){
      // idum = (int) (1+tt[k]-tstart);
      // forecast[idum] += 1.0/(1.0*Nsur);
      // if(i<=100) fprintf(fout1,"%lf\t%lf\t%lf\t%lf\n",tt[k],llon[k],llat[k],mm[k]);
      //}
      //else  if(sett==0 && i<=100) fprintf(fout2,"%lf\t%lf\t%lf\t%lf\n",tt[k],llon[k],llat[k],mm[k]);
    }
  }

  if(Mcut>Mcutpredict){
    fac   = pow(10.0,bvalue*(Mcut-Mcutpredict)); 
    mean *= fac;
    for(n=1;n<=Ngrid;n++) meancell[n] *= fac;
  }  

  printf("\n\t forecasted total number in [%.1lf  %.1lf]: %lf\n\n",tstart,tend,mean);
  //fclose(fout1);
  //fclose(fout2);


  // make sure that local rate is >= background number:
  for(n=1;n<=Ngrid;n++){ min=probback[n]*MUvalue*T; if(meancell[n]<min) meancell[n]=min; }


  // **********************************************************
  // ********* WRITE OUTPUT-TEMPLATE **************************

  write_template(meancell,templatefile,resfile);

  // **********************************************************

  // write some output-files for plotting and testing:
  write_testoutput(suffx,mean,meancell);

  free_dvector(mm,1,Zmax);
  free_dvector(tt,1,Zmax);  
  free_dvector(llat,1,Zmax);
  free_dvector(llon,1,Zmax);
}
