package scratch.martinez.LossCurveSandbox.ui;

import scratch.martinez.LossCurveSandbox.beans.VulnerabilityBean;

/**
 * A <code>VulnerabilityBeanEditor</code> is a specialization of a generic
 * <code>BeanEditorAPI</code>. It is used as a bridge to interact between the
 * user and the <code>VulnerabilityBean</code>.
 * 
 * @author   
 * <a href="mailto:emartinez@usgs.gov?subject=NSHMP%20Application%20Question">
 * Eric Martinez
 * </a>
 */
public interface VulnerabilityBeanEditor extends BeanEditorAPI {

	/**
	 * Retrieves the underlying bean manipulated by this editor.
	 * 
	 * @return The underlying bean that is manipulated by this editor.
	 */
	public VulnerabilityBean getBean();
	
	/**
	 * Loads a new vulnerability model based on data provided by the user.
	 * Implementation depends on deployment and the &ldquo;user&rdquo; may
	 * simply be standard input. This is left very flexible however the initial
	 * intention was for the user to specify a file in a deployment-appropriate
	 * manner and that file would be read and loaded.
	 */
	public void loadVulnerability();
}
