package scratch.martinez.LossCurveSandbox.vulnerability;

/**
 * This is the base abstract class from which all vulnerability models should
 * descend. It implements the <code>java.lang.Comparable</code> interface
 * allowing discrete and/or continuous models to be cross-compared. As is
 * suggested, this implementation <em>is consistent with equals</em>.
 * 
 * @see java.lang.Comparable
 * @author   
 * <a href="mailto:emartinez@usgs.gov?subject=NSHMP%20Application%20Question">
 * Eric Martinez
 * </a>
 */
public abstract class AbstractVulnerability implements VulnerabilityModel {

	/**
	 * Checks if two discrete vulnerabilities are equal. Note that discrete
	 * and continuous vulnerabilities can be equal so long as their names match.
	 * Therefore we do not check instance types before comparing names.
	 * 
	 * @param other The model to compare against this model.
	 * @return <code>true</code> if both models are discrete and have the same
	 * name, <code>false</code> otherwise.
	 */
	public boolean equals(VulnerabilityModel other) {
		if(other == null) {
			return false;
		} else {
			// We purposefully do NOT check instance type because we want to
			// consider a continuous and/or discrete vulnerability equals so long
			// as their names are equal.
			return this.getName().equals(other.getName());
		}
	}
	
	/**
	 * Implements the <code>java.lang.Comparable</code> interface allowing
	 * vulnerabilities to be compared and sorted, even between discrete and/or
	 * continuous models.
	 * 
	 * @param other The model to compare to this model.
	 * @return A negative integer, zero, or a positive integer as this model's
	 * name is less than-, equal to-, or greater than- the <code>other</code>
	 * model's name.
	 * @throws NullPointerException If <code>other</code> is <code>null</code>.
	 */
	public final int compareTo(VulnerabilityModel other) {
		if(other == null) {
			NullPointerException npx = new NullPointerException("Cannot compare " +
					"to a null value.");
			npx.fillInStackTrace();
			throw npx;
		} else {
			return  this.getName().compareTo(other.getName());
		}
	}
}
