package scratch.martinez.LossCurveSandbox.vulnerability;

/**
 * An exception wrapper class indicating that a
 * <code>VulnerabilityFactory</code> was requested to create a new 
 * <code>VulnerabilityModel</code> from an input source, however that input
 * source did not follow proper syntax specifications.
 * 
 * @author   
 * <a href="mailto:emartinez@usgs.gov?subject=NSHMP%20Application%20Question">
 * Eric Martinez
 * </a>
 */
public class IllegalVulnerabilityFormatException extends Exception {
	// Required variable for serialization.
	private static final long	serialVersionUID	= 0xEAE0850C;

	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public IllegalVulnerabilityFormatException() {
		super();
		fillInStackTrace();
	}
	
	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public IllegalVulnerabilityFormatException(String message) {
		super(message);
		fillInStackTrace();
	}
	
	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public IllegalVulnerabilityFormatException(String message, Throwable cause) {
		super(message, cause);
		fillInStackTrace();
	}
	
	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public IllegalVulnerabilityFormatException(Throwable cause) {
		super(cause);
		fillInStackTrace();
	}
}
