package scratch.martinez.LossCurveSandbox.vulnerability;

/**
 * An exception wrapper class indicating that a
 * <code>VulnerabilityFactory</code> was requested to create a new 
 * <code>VulnerabilityModel</code> from a probability distribution that is
 * not supported.
 * 
 * @author   
 * <a href="mailto:emartinez@usgs.gov?subject=NSHMP%20Application%20Question">
 * Eric Martinez
 * </a>
 */
public class UnsupportedDistributionException extends Exception {

	// Required variable for serialization.
	private static final long	serialVersionUID	= 0xDEE21FD;

	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public UnsupportedDistributionException() {
		super();
		fillInStackTrace();
	}
	
	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public UnsupportedDistributionException(String message) {
		super(message);
		fillInStackTrace();
	}
	
	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public UnsupportedDistributionException(String message, Throwable cause) {
		super(message, cause);
		fillInStackTrace();
	}
	
	/**
	 * See the general contract in <code>Exception</code>.
	 * @see java.lang.Exception
	 */
	public UnsupportedDistributionException(Throwable cause) {
		super(cause);
		fillInStackTrace();
	}
}
