package scratch.martinez.VulnerabilityModels.CureeCaltech;

/**
 * <strong>Title:</strong> CCLargeHouseImmediateOccupancy<br />
 * <strong>Description</strong> A digital representation of the CUREE-Caltech Woodframe
 * Project large house immediate occupancy Sagm(0.2s,5%) vulnerability function. (CWF-205-0205)
 * 
 * @see CureeCaltechWoodFrame
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @author Keith Porter
 *
 */
public class CCLargeHouseImmediateOccupancy extends CureeCaltechWoodFrame {
	
	private static double [] DF = {
		0.000, 0.000, 0.000, 0.000, 0.000, 0.001, 0.002, 0.008, 0.013, 0.017,
		0.021, 0.025, 0.028, 0.032, 0.035, 0.037, 0.040, 0.042, 0.045, 0.047
	};
	
	private static double[] COVDF = {
		2.50, 2.50, 2.50, 2.50, 2.50, 2.14, 1.47, 1.04, 0.91, 0.84,
		0.79, 0.76, 0.73, 0.71, 0.69, 0.68, 0.67, 0.66, 0.65, 0.64
	};
	
	private static double[][] DEM = {
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.92E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.88E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.83E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.76E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.67E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.55E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.40E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.21E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.99E-001, 9.93E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.72E-001, 9.89E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.41E-001, 9.83E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.05E-001, 9.75E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.64E-001, 9.63E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.19E-001, 9.47E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.70E-001, 9.27E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.19E-001, 9.00E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.65E-001, 8.67E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.10E-001, 8.27E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.54E-001, 7.79E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.00E-001, 7.26E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.47E-001, 6.67E-001, 9.92E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.97E-001, 6.03E-001, 9.86E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.51E-001, 5.36E-001, 9.76E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.09E-001, 4.68E-001, 9.61E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.71E-001, 4.02E-001, 9.40E-001, 9.92E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.38E-001, 3.38E-001, 9.10E-001, 9.86E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.10E-001, 2.78E-001, 8.70E-001, 9.74E-001, 9.94E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.59E-002, 2.24E-001, 8.19E-001, 9.57E-001, 9.87E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.61E-002, 1.76E-001, 7.58E-001, 9.30E-001, 9.77E-001, 9.92E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.00E-002, 1.36E-001, 6.87E-001, 8.93E-001, 9.59E-001, 9.85E-001, 9.94E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.72E-002, 1.02E-001, 6.08E-001, 8.44E-001, 9.32E-001, 9.71E-001, 9.87E-001, 9.94E-001, 9.97E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.73E-002, 7.51E-002, 5.24E-001, 7.81E-001, 8.92E-001, 9.49E-001, 9.76E-001, 9.87E-001, 9.94E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.96E-002, 5.38E-002, 4.39E-001, 7.05E-001, 8.39E-001, 9.16E-001, 9.55E-001, 9.74E-001, 9.87E-001, 9.92E-001, 9.95E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.39E-002, 3.76E-002, 3.57E-001, 6.20E-001, 7.70E-001, 8.67E-001, 9.24E-001, 9.53E-001, 9.73E-001, 9.84E-001, 9.88E-001, 9.92E-001, 9.95E-001, 9.97E-001, 9.98E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.65E-003, 2.57E-002, 2.81E-001, 5.28E-001, 6.88E-001, 8.03E-001, 8.77E-001, 9.18E-001, 9.50E-001, 9.68E-001, 9.75E-001, 9.83E-001, 9.88E-001, 9.92E-001, 9.94E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.59E-003, 1.71E-002, 2.14E-001, 4.35E-001, 5.95E-001, 7.23E-001, 8.13E-001, 8.67E-001, 9.14E-001, 9.40E-001, 9.53E-001, 9.66E-001, 9.74E-001, 9.82E-001, 9.86E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.42E-003, 1.10E-002, 1.58E-001, 3.45E-001, 4.96E-001, 6.29E-001, 7.32E-001, 7.98E-001, 8.59E-001, 8.97E-001, 9.15E-001, 9.37E-001, 9.49E-001, 9.63E-001, 9.70E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.92E-003, 6.97E-003, 1.12E-001, 2.63E-001, 3.98E-001, 5.27E-001, 6.36E-001, 7.11E-001, 7.86E-001, 8.34E-001, 8.60E-001, 8.90E-001, 9.09E-001, 9.30E-001, 9.42E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.89E-003, 4.29E-003, 7.63E-002, 1.93E-001, 3.06E-001, 4.23E-001, 5.31E-001, 6.09E-001, 6.94E-001, 7.51E-001, 7.83E-001, 8.24E-001, 8.48E-001, 8.78E-001, 8.97E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.20E-003, 2.57E-003, 5.02E-002, 1.35E-001, 2.24E-001, 3.24E-001, 4.24E-001, 4.99E-001, 5.88E-001, 6.50E-001, 6.87E-001, 7.36E-001, 7.66E-001, 8.05E-001, 8.30E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.51E-004, 1.50E-003, 3.17E-002, 9.05E-002, 1.57E-001, 2.36E-001, 3.22E-001, 3.89E-001, 4.75E-001, 5.37E-001, 5.76E-001, 6.29E-001, 6.64E-001, 7.10E-001, 7.40E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.61E-004, 8.49E-004, 1.93E-002, 5.79E-002, 1.04E-001, 1.64E-001, 2.32E-001, 2.88E-001, 3.64E-001, 4.21E-001, 4.59E-001, 5.12E-001, 5.48E-001, 5.97E-001, 6.30E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.78E-004, 4.69E-004, 1.12E-002, 3.54E-002, 6.60E-002, 1.07E-001, 1.58E-001, 2.01E-001, 2.63E-001, 3.12E-001, 3.45E-001, 3.94E-001, 4.27E-001, 4.76E-001, 5.08E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.65E-004, 2.52E-004, 6.30E-003, 2.06E-002, 3.96E-002, 6.63E-002, 1.02E-001, 1.32E-001, 1.79E-001, 2.17E-001, 2.44E-001, 2.85E-001, 3.13E-001, 3.56E-001, 3.85E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.56E-005, 1.32E-004, 3.38E-003, 1.14E-002, 2.25E-002, 3.87E-002, 6.16E-002, 8.12E-002, 1.14E-001, 1.41E-001, 1.61E-001, 1.93E-001, 2.15E-001, 2.50E-001, 2.73E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.45E-005, 6.72E-005, 1.75E-003, 6.01E-003, 1.21E-002, 2.13E-002, 3.51E-002, 4.69E-002, 6.81E-002, 8.58E-002, 9.92E-002, 1.22E-001, 1.37E-001, 1.63E-001, 1.80E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.06E-005, 3.33E-005, 8.63E-004, 3.02E-003, 6.13E-003, 1.10E-002, 1.87E-002, 2.53E-002, 3.79E-002, 4.85E-002, 5.68E-002, 7.13E-002, 8.14E-002, 9.85E-002, 1.10E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.68E-005, 1.60E-005, 4.09E-004, 1.44E-003, 2.94E-003, 5.37E-003, 9.36E-003, 1.28E-002, 1.96E-002, 2.55E-002, 3.02E-002, 3.87E-002, 4.47E-002, 5.51E-002, 6.23E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.07E-006, 7.52E-006, 1.86E-004, 6.51E-004, 1.33E-003, 2.46E-003, 4.38E-003, 5.99E-003, 9.48E-003, 1.24E-002, 1.49E-002, 1.95E-002, 2.26E-002, 2.84E-002, 3.24E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.81E-006, 3.43E-006, 8.08E-005, 2.80E-004, 5.71E-004, 1.05E-003, 1.92E-003, 2.62E-003, 4.25E-003, 5.61E-003, 6.77E-003, 9.03E-003, 1.06E-002, 1.35E-002, 1.54E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.50E-006, 1.52E-006, 3.37E-005, 1.14E-004, 2.31E-004, 4.24E-004, 7.85E-004, 1.07E-003, 1.77E-003, 2.34E-003, 2.85E-003, 3.87E-003, 4.55E-003, 5.90E-003, 6.76E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.28E-006, 6.56E-007, 1.34E-005, 4.43E-005, 8.77E-005, 1.60E-004, 3.00E-004, 4.05E-004, 6.81E-004, 9.03E-004, 1.10E-003, 1.52E-003, 1.80E-003, 2.36E-003, 2.71E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.40E-007, 2.75E-007, 5.13E-006, 1.63E-005, 3.15E-005, 5.67E-005, 1.07E-004, 1.43E-004, 2.43E-004, 3.22E-004, 3.95E-004, 5.52E-004, 6.52E-004, 8.66E-004, 9.94E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.15E-007, 1.12E-007, 1.88E-006, 5.69E-006, 1.06E-005, 1.88E-005, 3.57E-005, 4.66E-005, 8.05E-005, 1.06E-004, 1.30E-004, 1.84E-004, 2.17E-004, 2.91E-004, 3.33E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.52E-007, 4.45E-008, 6.58E-007, 1.88E-006, 3.39E-006, 5.84E-006, 1.11E-005, 1.42E-005, 2.47E-005, 3.21E-005, 3.94E-005, 5.64E-005, 6.63E-005, 8.95E-005, 1.02E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.20E-008, 1.72E-008, 2.21E-007, 5.91E-007, 1.02E-006, 1.70E-006, 3.22E-006, 4.00E-006, 6.99E-006, 8.97E-006, 1.10E-005, 1.59E-005, 1.86E-005, 2.52E-005, 2.84E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.35E-008, 6.44E-009, 7.08E-008, 1.76E-007, 2.87E-007, 4.62E-007, 8.70E-007, 1.05E-006, 1.83E-006, 2.31E-006, 2.82E-006, 4.10E-006, 4.76E-006, 6.47E-006, 7.24E-006},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.53E-008, 2.35E-009, 2.17E-008, 4.96E-008, 7.64E-008, 1.18E-007, 2.19E-007, 2.54E-007, 4.44E-007, 5.49E-007, 6.66E-007, 9.70E-007, 1.12E-006, 1.52E-006, 1.68E-006},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.85E-009, 8.32E-010, 6.39E-009, 1.33E-008, 1.91E-008, 2.80E-008, 5.15E-008, 5.72E-008, 9.95E-008, 1.20E-007, 1.44E-007, 2.11E-007, 2.40E-007, 3.26E-007, 3.54E-007},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.01E-009, 2.87E-010, 1.80E-009, 3.36E-009, 4.51E-009, 6.25E-009, 1.13E-008, 1.19E-008, 2.06E-008, 2.41E-008, 2.87E-008, 4.20E-008, 4.71E-008, 6.37E-008, 6.82E-008}
};

	public CCLargeHouseImmediateOccupancy() {
		displayName = "CUREE-Caltech: Large House Immediate Occupancy";
		setInitVars();
		ADF = 0.003;
		BDF = 0.218;
		NIML = IML.length;
		register(supportedTypes);
	}

	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame
	 */
	protected double[] getDFArray() {
		return DF;
	}
	@Override
	/**
	 * See the general contract in CurreeCaltechWoodFrame
	 */
	protected double[] getCOVDFArray() {
		return COVDF;
	}
	public double[][] getDEMMatrix() {
		return DEM;
	}
}
