package scratch.martinez.VulnerabilityModels.CureeCaltech;

/**
 * <strong>Title:</strong> CCLargeHouseRigidDiaphram<br />
 * <strong>Description</strong> A digital representation of the CUREE-Caltech Woodframe
 * Project large house rigid diaphram Sagm(0.2s,5%) vulnerability function. (CWF-206-0205)
 * 
 * @see CureeCaltechWoodFrame
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @author Keith Porter
 *
 */
public class CCLargeHouseRigidDiaphram extends CureeCaltechWoodFrame {
	
	private static double [] DF = {
		0.000, 0.000, 0.000, 0.001, 0.003, 0.011, 0.021, 0.029, 0.037, 0.044,
		0.050, 0.055, 0.060, 0.065, 0.069, 0.073, 0.077, 0.081, 0.084, 0.087
	};
	
	private static double[] COVDF = {
		2.50, 2.50, 2.50, 1.99, 1.37, 0.94, 0.79, 0.72, 0.68, 0.65,
		0.63, 0.61, 0.60, 0.59, 0.58, 0.57, 0.56, 0.55, 0.55, 0.54
	};
	
	private static double[][] DEM = {
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.91E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.87E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.82E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.74E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.64E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.51E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.35E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.14E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.90E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.60E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.25E-001, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 7.86E-001, 9.90E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 7.41E-001, 9.83E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.93E-001, 9.75E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.40E-001, 9.62E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 5.85E-001, 9.45E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 5.28E-001, 9.22E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.71E-001, 8.93E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.14E-001, 8.57E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.59E-001, 8.13E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.07E-001, 7.62E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.58E-001, 7.04E-001, 9.95E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.14E-001, 6.40E-001, 9.91E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.74E-001, 5.71E-001, 9.83E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.40E-001, 5.01E-001, 9.71E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.10E-001, 4.31E-001, 9.53E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.55E-002, 3.62E-001, 9.26E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.51E-002, 2.98E-001, 8.88E-001, 9.92E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.87E-002, 2.40E-001, 8.38E-001, 9.85E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.58E-002, 1.88E-001, 7.75E-001, 9.71E-001, 9.95E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.59E-002, 1.44E-001, 7.01E-001, 9.49E-001, 9.90E-001, 9.98E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.83E-002, 1.08E-001, 6.17E-001, 9.16E-001, 9.79E-001, 9.95E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.28E-002, 7.84E-002, 5.28E-001, 8.67E-001, 9.60E-001, 9.88E-001, 9.96E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.71E-003, 5.55E-002, 4.37E-001, 8.03E-001, 9.29E-001, 9.75E-001, 9.91E-001, 9.96E-001, 9.98E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 5.84E-003, 3.83E-002, 3.49E-001, 7.23E-001, 8.83E-001, 9.53E-001, 9.80E-001, 9.90E-001, 9.95E-001, 9.97E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.84E-003, 2.57E-002, 2.68E-001, 6.29E-001, 8.18E-001, 9.15E-001, 9.59E-001, 9.79E-001, 9.88E-001, 9.93E-001, 9.96E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.48E-003, 1.68E-002, 1.99E-001, 5.27E-001, 7.34E-001, 8.60E-001, 9.25E-001, 9.57E-001, 9.74E-001, 9.84E-001, 9.90E-001, 9.93E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.57E-003, 1.06E-002, 1.41E-001, 4.23E-001, 6.34E-001, 7.83E-001, 8.71E-001, 9.19E-001, 9.47E-001, 9.65E-001, 9.77E-001, 9.84E-001, 9.89E-001, 9.92E-001, 9.95E-001, 9.96E-001, 9.97E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.74E-004, 6.56E-003, 9.59E-002, 3.24E-001, 5.24E-001, 6.87E-001, 7.95E-001, 8.60E-001, 9.03E-001, 9.31E-001, 9.51E-001, 9.64E-001, 9.74E-001, 9.81E-001, 9.87E-001, 9.89E-001, 9.92E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 5.93E-004, 3.93E-003, 6.25E-002, 2.36E-001, 4.12E-001, 5.76E-001, 6.97E-001, 7.78E-001, 8.35E-001, 8.75E-001, 9.07E-001, 9.28E-001, 9.45E-001, 9.58E-001, 9.69E-001, 9.74E-001, 9.80E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.54E-004, 2.29E-003, 3.89E-002, 1.64E-001, 3.07E-001, 4.59E-001, 5.82E-001, 6.74E-001, 7.42E-001, 7.95E-001, 8.39E-001, 8.69E-001, 8.95E-001, 9.17E-001, 9.35E-001, 9.43E-001, 9.54E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.07E-004, 1.30E-003, 2.32E-002, 1.07E-001, 2.16E-001, 3.45E-001, 4.60E-001, 5.54E-001, 6.27E-001, 6.89E-001, 7.44E-001, 7.84E-001, 8.19E-001, 8.50E-001, 8.77E-001, 8.90E-001, 9.08E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.19E-004, 7.12E-004, 1.32E-002, 6.63E-002, 1.43E-001, 2.44E-001, 3.42E-001, 4.28E-001, 5.00E-001, 5.65E-001, 6.26E-001, 6.72E-001, 7.15E-001, 7.54E-001, 7.89E-001, 8.09E-001, 8.33E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.71E-005, 3.80E-004, 7.13E-003, 3.87E-002, 8.84E-002, 1.61E-001, 2.38E-001, 3.10E-001, 3.73E-001, 4.35E-001, 4.95E-001, 5.43E-001, 5.88E-001, 6.32E-001, 6.73E-001, 6.98E-001, 7.28E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.71E-005, 1.97E-004, 3.68E-003, 2.13E-002, 5.12E-002, 9.92E-002, 1.54E-001, 2.09E-001, 2.58E-001, 3.11E-001, 3.65E-001, 4.08E-001, 4.52E-001, 4.95E-001, 5.38E-001, 5.66E-001, 5.97E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.01E-005, 9.89E-005, 1.81E-003, 1.10E-002, 2.77E-002, 5.68E-002, 9.21E-002, 1.30E-001, 1.65E-001, 2.06E-001, 2.49E-001, 2.84E-001, 3.21E-001, 3.59E-001, 3.97E-001, 4.25E-001, 4.54E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.07E-005, 4.83E-005, 8.50E-004, 5.37E-003, 1.40E-002, 3.02E-002, 5.10E-002, 7.47E-002, 9.74E-002, 1.25E-001, 1.56E-001, 1.82E-001, 2.09E-001, 2.39E-001, 2.69E-001, 2.93E-001, 3.17E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 5.54E-006, 2.29E-005, 3.79E-004, 2.46E-003, 6.58E-003, 1.49E-002, 2.61E-002, 3.94E-002, 5.25E-002, 6.95E-002, 8.91E-002, 1.06E-001, 1.25E-001, 1.45E-001, 1.66E-001, 1.84E-001, 2.02E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.83E-006, 1.05E-005, 1.61E-004, 1.05E-003, 2.88E-003, 6.77E-003, 1.23E-002, 1.91E-002, 2.59E-002, 3.53E-002, 4.65E-002, 5.64E-002, 6.74E-002, 7.95E-002, 9.27E-002, 1.05E-001, 1.16E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.41E-006, 4.68E-006, 6.52E-005, 4.24E-004, 1.17E-003, 2.85E-003, 5.29E-003, 8.47E-003, 1.16E-002, 1.63E-002, 2.20E-002, 2.71E-002, 3.29E-002, 3.94E-002, 4.66E-002, 5.39E-002, 5.98E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.93E-007, 2.03E-006, 2.51E-005, 1.60E-004, 4.41E-004, 1.10E-003, 2.10E-003, 3.43E-003, 4.75E-003, 6.84E-003, 9.46E-003, 1.18E-002, 1.45E-002, 1.76E-002, 2.10E-002, 2.48E-002, 2.76E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.33E-007, 8.51E-007, 9.18E-006, 5.67E-005, 1.54E-004, 3.95E-004, 7.61E-004, 1.27E-003, 1.76E-003, 2.60E-003, 3.67E-003, 4.64E-003, 5.75E-003, 7.03E-003, 8.46E-003, 1.02E-002, 1.14E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.57E-007, 3.46E-007, 3.20E-006, 1.88E-005, 5.01E-005, 1.30E-004, 2.53E-004, 4.28E-004, 5.94E-004, 8.95E-004, 1.29E-003, 1.64E-003, 2.05E-003, 2.52E-003, 3.04E-003, 3.77E-003, 4.17E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 7.23E-008, 1.37E-007, 1.06E-006, 5.84E-006, 1.51E-005, 3.94E-005, 7.69E-005, 1.31E-004, 1.81E-004, 2.78E-004, 4.07E-004, 5.21E-004, 6.54E-004, 8.05E-004, 9.75E-004, 1.24E-003, 1.36E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.27E-008, 5.24E-008, 3.33E-007, 1.70E-006, 4.21E-006, 1.10E-005, 2.14E-005, 3.67E-005, 5.01E-005, 7.82E-005, 1.16E-004, 1.49E-004, 1.87E-004, 2.30E-004, 2.78E-004, 3.60E-004, 3.91E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.45E-008, 1.95E-008, 9.94E-008, 4.62E-007, 1.09E-006, 2.82E-006, 5.44E-006, 9.34E-006, 1.25E-005, 1.98E-005, 2.97E-005, 3.81E-005, 4.77E-005, 5.85E-005, 7.04E-005, 9.34E-005, 9.99E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.30E-009, 7.02E-009, 2.83E-008, 1.18E-007, 2.60E-007, 6.66E-007, 1.26E-006, 2.16E-006, 2.84E-006, 4.53E-006, 6.85E-006, 8.75E-006, 1.09E-005, 1.33E-005, 1.58E-005, 2.15E-005, 2.25E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.68E-009, 2.46E-009, 7.63E-009, 2.80E-008, 5.77E-008, 1.44E-007, 2.68E-007, 4.54E-007, 5.80E-007, 9.34E-007, 1.42E-006, 1.80E-006, 2.22E-006, 2.68E-006, 3.15E-006, 4.38E-006, 4.49E-006},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.12E-009, 8.32E-010, 1.96E-009, 6.25E-009, 1.18E-008, 2.87E-008, 5.18E-008, 8.66E-008, 1.07E-007, 1.74E-007, 2.64E-007, 3.32E-007, 4.05E-007, 4.80E-007, 5.56E-007, 7.93E-007, 7.91E-007}
};
	
	public CCLargeHouseRigidDiaphram() {
		displayName = "CUREE-Caltech: Large House Rigid Diaphram";
		setInitVars();
		ADF = 0.003;
		BDF = 0.218;
		NIML = IML.length;
		register(supportedTypes);
	}

	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame
	 */
	protected double[] getDFArray() {
		return DF;
	}
	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame
	 */
	protected double[] getCOVDFArray() {
		return COVDF;
	}
	public double[][] getDEMMatrix() {
		return DEM;
	}
}
