package scratch.martinez.VulnerabilityModels.CureeCaltech;

/**
 * <strong>Title:</strong> CCSmallHouseTypical<br />
 * <strong>Description</strong> A digital representation of the CUREE-Caltech Woodframe
 * Project small house typical Sagm(0.2s,5%) vulnerability function. (CWF-102-0205)
 * 
 * @see CureeCaltechWoodFrame
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @author Keith Porter
 *
 */
public class CCSmallHouseTypical extends CureeCaltechWoodFrame {
	
	private static double [] DF = {
			0.003, 0.011, 0.043, 0.070, 0.090,
			0.107, 0.121, 0.133, 0.144, 0.154,
			0.163, 0.171, 0.178, 0.185, 0.191,
			0.197, 0.203, 0.208, 0.213, 0.218
	};
	
	private static double[] COVDF = {
		2.50, 2.50, 2.24, 1.60, 1.33, 1.18, 1.08, 1.01, 0.95, 0.91,
		0.88, 0.85, 0.82, 0.80, 0.78, 0.76, 0.75, 0.74, 0.72, 0.71
	};
	
	private static double[][] DEM = {
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.92E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.88E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.84E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.78E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.70E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.60E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.47E-001, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.32E-001, 9.92E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{9.13E-001, 9.89E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{8.90E-001, 9.84E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{8.64E-001, 9.78E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{8.34E-001, 9.71E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{7.99E-001, 9.61E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{7.61E-001, 9.49E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{7.19E-001, 9.34E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{6.74E-001, 9.15E-001, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{6.26E-001, 8.93E-001, 9.92E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{5.76E-001, 8.68E-001, 9.88E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{5.25E-001, 8.38E-001, 9.83E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{4.73E-001, 8.04E-001, 9.77E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{4.22E-001, 7.66E-001, 9.68E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{3.72E-001, 7.25E-001, 9.57E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{3.24E-001, 6.80E-001, 9.43E-001, 9.94E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{2.79E-001, 6.32E-001, 9.25E-001, 9.91E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{2.37E-001, 5.82E-001, 9.04E-001, 9.87E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.99E-001, 5.31E-001, 8.79E-001, 9.80E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.65E-001, 4.80E-001, 8.49E-001, 9.71E-001, 9.94E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.35E-001, 4.28E-001, 8.15E-001, 9.58E-001, 9.90E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.09E-001, 3.78E-001, 7.77E-001, 9.42E-001, 9.83E-001, 9.95E-001, 9.98E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{8.65E-002, 3.30E-001, 7.34E-001, 9.21E-001, 9.74E-001, 9.91E-001, 9.97E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{6.78E-002, 2.85E-001, 6.88E-001, 8.94E-001, 9.61E-001, 9.85E-001, 9.94E-001, 9.97E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{5.24E-002, 2.42E-001, 6.38E-001, 8.61E-001, 9.44E-001, 9.76E-001, 9.89E-001, 9.95E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{4.00E-002, 2.04E-001, 5.86E-001, 8.22E-001, 9.20E-001, 9.63E-001, 9.82E-001, 9.90E-001, 9.95E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{3.00E-002, 1.69E-001, 5.32E-001, 7.77E-001, 8.90E-001, 9.44E-001, 9.70E-001, 9.83E-001, 9.91E-001, 9.95E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{2.22E-002, 1.38E-001, 4.78E-001, 7.26E-001, 8.52E-001, 9.18E-001, 9.53E-001, 9.72E-001, 9.84E-001, 9.90E-001, 9.93E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000},
		{1.62E-002, 1.12E-001, 4.24E-001, 6.69E-001, 8.06E-001, 8.84E-001, 9.29E-001, 9.55E-001, 9.72E-001, 9.81E-001, 9.87E-001, 9.91E-001, 9.94E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001},
		{1.16E-002, 8.91E-002, 3.72E-001, 6.09E-001, 7.52E-001, 8.41E-001, 8.96E-001, 9.30E-001, 9.53E-001, 9.67E-001, 9.77E-001, 9.83E-001, 9.88E-001, 9.91E-001, 9.94E-001, 9.95E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.98E-001},
		{8.22E-003, 7.00E-002, 3.22E-001, 5.46E-001, 6.92E-001, 7.90E-001, 8.54E-001, 8.96E-001, 9.27E-001, 9.46E-001, 9.60E-001, 9.70E-001, 9.78E-001, 9.83E-001, 9.87E-001, 9.90E-001, 9.92E-001, 9.93E-001, 9.95E-001, 9.96E-001},
		{5.73E-003, 5.42E-002, 2.74E-001, 4.81E-001, 6.26E-001, 7.29E-001, 8.01E-001, 8.51E-001, 8.89E-001, 9.16E-001, 9.34E-001, 9.49E-001, 9.60E-001, 9.68E-001, 9.75E-001, 9.80E-001, 9.83E-001, 9.86E-001, 9.89E-001, 9.91E-001},
		{3.93E-003, 4.14E-002, 2.31E-001, 4.17E-001, 5.56E-001, 6.61E-001, 7.38E-001, 7.95E-001, 8.40E-001, 8.73E-001, 8.97E-001, 9.17E-001, 9.33E-001, 9.45E-001, 9.55E-001, 9.63E-001, 9.68E-001, 9.73E-001, 9.78E-001, 9.81E-001},
		{2.66E-003, 3.11E-002, 1.92E-001, 3.55E-001, 4.84E-001, 5.87E-001, 6.66E-001, 7.27E-001, 7.79E-001, 8.18E-001, 8.47E-001, 8.72E-001, 8.94E-001, 9.10E-001, 9.23E-001, 9.35E-001, 9.43E-001, 9.50E-001, 9.59E-001, 9.64E-001},
		{1.77E-003, 2.31E-002, 1.57E-001, 2.97E-001, 4.12E-001, 5.10E-001, 5.88E-001, 6.51E-001, 7.06E-001, 7.49E-001, 7.83E-001, 8.13E-001, 8.39E-001, 8.60E-001, 8.77E-001, 8.94E-001, 9.05E-001, 9.15E-001, 9.27E-001, 9.35E-001},
		{1.16E-003, 1.69E-002, 1.26E-001, 2.44E-001, 3.44E-001, 4.32E-001, 5.06E-001, 5.68E-001, 6.23E-001, 6.69E-001, 7.06E-001, 7.40E-001, 7.69E-001, 7.94E-001, 8.15E-001, 8.35E-001, 8.51E-001, 8.63E-001, 8.79E-001, 8.90E-001},
		{7.46E-004, 1.21E-002, 1.00E-001, 1.96E-001, 2.80E-001, 3.57E-001, 4.24E-001, 4.81E-001, 5.35E-001, 5.80E-001, 6.19E-001, 6.54E-001, 6.85E-001, 7.13E-001, 7.37E-001, 7.60E-001, 7.78E-001, 7.93E-001, 8.13E-001, 8.27E-001},
		{4.74E-004, 8.60E-003, 7.84E-002, 1.54E-001, 2.23E-001, 2.87E-001, 3.45E-001, 3.96E-001, 4.44E-001, 4.87E-001, 5.24E-001, 5.59E-001, 5.90E-001, 6.19E-001, 6.44E-001, 6.69E-001, 6.89E-001, 7.06E-001, 7.28E-001, 7.44E-001},
		{2.96E-004, 6.00E-003, 6.03E-002, 1.19E-001, 1.73E-001, 2.25E-001, 2.72E-001, 3.15E-001, 3.57E-001, 3.95E-001, 4.29E-001, 4.60E-001, 4.90E-001, 5.17E-001, 5.41E-001, 5.66E-001, 5.87E-001, 6.05E-001, 6.27E-001, 6.45E-001},
		{1.82E-004, 4.13E-003, 4.57E-002, 8.99E-002, 1.30E-001, 1.71E-001, 2.08E-001, 2.42E-001, 2.76E-001, 3.08E-001, 3.37E-001, 3.64E-001, 3.90E-001, 4.14E-001, 4.36E-001, 4.59E-001, 4.79E-001, 4.96E-001, 5.17E-001, 5.34E-001},
		{1.10E-004, 2.79E-003, 3.41E-002, 6.64E-002, 9.59E-002, 1.26E-001, 1.53E-001, 1.80E-001, 2.05E-001, 2.31E-001, 2.54E-001, 2.76E-001, 2.97E-001, 3.17E-001, 3.35E-001, 3.54E-001, 3.72E-001, 3.88E-001, 4.05E-001, 4.21E-001},
		{6.57E-005, 1.86E-003, 2.50E-002, 4.79E-002, 6.87E-002, 8.98E-002, 1.09E-001, 1.28E-001, 1.47E-001, 1.66E-001, 1.84E-001, 2.00E-001, 2.15E-001, 2.31E-001, 2.45E-001, 2.60E-001, 2.75E-001, 2.87E-001, 3.01E-001, 3.14E-001},
		{3.85E-005, 1.22E-003, 1.80E-002, 3.38E-002, 4.78E-002, 6.21E-002, 7.54E-002, 8.82E-002, 1.01E-001, 1.14E-001, 1.27E-001, 1.38E-001, 1.49E-001, 1.60E-001, 1.70E-001, 1.80E-001, 1.92E-001, 2.01E-001, 2.11E-001, 2.21E-001},
		{2.22E-005, 7.89E-004, 1.28E-002, 2.34E-002, 3.24E-002, 4.16E-002, 5.01E-002, 5.83E-002, 6.62E-002, 7.48E-002, 8.32E-002, 9.08E-002, 9.73E-002, 1.05E-001, 1.11E-001, 1.18E-001, 1.26E-001, 1.33E-001, 1.39E-001, 1.46E-001},
		{1.26E-005, 5.02E-004, 8.93E-003, 1.58E-002, 2.13E-002, 2.69E-002, 3.21E-002, 3.70E-002, 4.17E-002, 4.69E-002, 5.22E-002, 5.67E-002, 6.04E-002, 6.52E-002, 6.90E-002, 7.30E-002, 7.82E-002, 8.24E-002, 8.55E-002, 9.00E-002},
		{7.06E-006, 3.14E-004, 6.13E-003, 1.04E-002, 1.36E-002, 1.69E-002, 1.98E-002, 2.25E-002, 2.51E-002, 2.80E-002, 3.11E-002, 3.36E-002, 3.55E-002, 3.82E-002, 4.03E-002, 4.23E-002, 4.55E-002, 4.80E-002, 4.94E-002, 5.20E-002},
		{3.88E-006, 1.94E-004, 4.13E-003, 6.68E-003, 8.44E-003, 1.02E-002, 1.17E-002, 1.32E-002, 1.44E-002, 1.60E-002, 1.76E-002, 1.89E-002, 1.97E-002, 2.11E-002, 2.21E-002, 2.31E-002, 2.48E-002, 2.61E-002, 2.66E-002, 2.80E-002},
		{2.10E-006, 1.18E-004, 2.74E-003, 4.19E-003, 5.09E-003, 5.98E-003, 6.69E-003, 7.36E-003, 7.89E-003, 8.65E-003, 9.47E-003, 1.00E-002, 1.03E-002, 1.10E-002, 1.14E-002, 1.18E-002, 1.27E-002, 1.33E-002, 1.34E-002, 1.40E-002},
		{1.12E-006, 7.02E-005, 1.79E-003, 2.57E-003, 2.98E-003, 3.38E-003, 3.67E-003, 3.95E-003, 4.13E-003, 4.46E-003, 4.84E-003, 5.06E-003, 5.11E-003, 5.39E-003, 5.53E-003, 5.64E-003, 6.05E-003, 6.34E-003, 6.26E-003, 6.53E-003}
};
	
	public CCSmallHouseTypical() {
		displayName = "CUREE-Caltech: Small House Typical";
		setInitVars();
		ADF = 0.003;
		BDF = 0.218;
		NIML = IML.length;
		register(supportedTypes);
	}

	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getDFArray() {
		return DF;
	}
	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getCOVDFArray() {
		return COVDF;
	}
	
	public double[][] getDEMMatrix() {
		return DEM;
	}
	
}
