package scratch.martinez.VulnerabilityModels.CureeCaltech;

/**
 * <strong>Title:</strong> CCTownhouseTypical<br />
 * <strong>Description</strong> A digital representation of the CUREE-Caltech Woodframe
 * Project townhouse typical quality Sagm(0.2s,5%) vulnerability function. (CWF-302-0205)
 * 
 * @see CureeCaltechWoodFrame
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @author Keith Porter
 *
 */
public class CCTownhouseTypical extends CureeCaltechWoodFrame {
	
	private static double [] DF = {
		0.000, 0.000, 0.000, 0.001, 0.004, 0.010, 0.018, 0.026, 0.034, 0.043,
		0.050, 0.056, 0.061, 0.064, 0.067, 0.069, 0.071, 0.073, 0.076, 0.078
	};
	
	private static double[] COVDF = {
		2.50, 2.50, 2.50, 2.05, 1.21, 0.91, 0.76, 0.67, 0.61, 0.57,
		0.54, 0.52, 0.50, 0.49, 0.49, 0.48, 0.48, 0.47, 0.47, 0.46
	};
	
	private static double[][] DEM = {
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.95E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.93E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.90E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.85E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.79E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.71E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.60E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.47E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.29E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.08E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.83E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.52E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.17E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 7.77E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 7.32E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.84E-001, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.31E-001, 9.89E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 5.77E-001, 9.83E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 5.21E-001, 9.73E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.64E-001, 9.58E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.08E-001, 9.38E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.54E-001, 9.11E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.03E-001, 8.76E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.55E-001, 8.32E-001, 9.95E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.12E-001, 7.80E-001, 9.90E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.73E-001, 7.19E-001, 9.81E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.39E-001, 6.51E-001, 9.68E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.10E-001, 5.77E-001, 9.46E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.57E-002, 5.01E-001, 9.16E-001, 9.95E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.55E-002, 4.25E-001, 8.73E-001, 9.89E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.93E-002, 3.52E-001, 8.18E-001, 9.78E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.64E-002, 2.84E-001, 7.49E-001, 9.60E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.64E-002, 2.22E-001, 6.69E-001, 9.31E-001, 9.90E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.89E-002, 1.69E-001, 5.80E-001, 8.87E-001, 9.78E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.32E-002, 1.25E-001, 4.87E-001, 8.27E-001, 9.57E-001, 9.91E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.10E-003, 9.01E-002, 3.95E-001, 7.49E-001, 9.22E-001, 9.80E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.15E-003, 6.27E-002, 3.08E-001, 6.56E-001, 8.69E-001, 9.59E-001, 9.90E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.08E-003, 4.23E-002, 2.31E-001, 5.53E-001, 7.94E-001, 9.21E-001, 9.76E-001, 9.92E-001, 9.97E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.65E-003, 2.77E-002, 1.66E-001, 4.45E-001, 6.99E-001, 8.62E-001, 9.49E-001, 9.79E-001, 9.91E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.70E-003, 1.75E-002, 1.14E-001, 3.42E-001, 5.88E-001, 7.78E-001, 9.01E-001, 9.53E-001, 9.76E-001, 9.88E-001, 9.92E-001, 9.94E-001, 9.96E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.99E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.06E-003, 1.07E-002, 7.48E-002, 2.49E-001, 4.69E-001, 6.71E-001, 8.27E-001, 9.05E-001, 9.46E-001, 9.69E-001, 9.78E-001, 9.82E-001, 9.87E-001, 9.89E-001, 9.92E-001, 9.94E-001, 9.95E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.55E-004, 6.34E-003, 4.69E-002, 1.72E-001, 3.53E-001, 5.47E-001, 7.26E-001, 8.30E-001, 8.91E-001, 9.30E-001, 9.47E-001, 9.57E-001, 9.66E-001, 9.70E-001, 9.77E-001, 9.81E-001, 9.86E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.96E-004, 3.63E-003, 2.81E-002, 1.12E-001, 2.49E-001, 4.18E-001, 6.01E-001, 7.23E-001, 8.05E-001, 8.62E-001, 8.89E-001, 9.07E-001, 9.22E-001, 9.31E-001, 9.43E-001, 9.53E-001, 9.62E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.35E-004, 2.01E-003, 1.60E-002, 6.84E-002, 1.65E-001, 2.98E-001, 4.65E-001, 5.92E-001, 6.87E-001, 7.59E-001, 7.96E-001, 8.23E-001, 8.46E-001, 8.60E-001, 8.79E-001, 8.97E-001, 9.12E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.37E-004, 1.08E-003, 8.67E-003, 3.94E-002, 1.01E-001, 1.96E-001, 3.33E-001, 4.49E-001, 5.46E-001, 6.25E-001, 6.68E-001, 7.03E-001, 7.32E-001, 7.52E-001, 7.78E-001, 8.04E-001, 8.26E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 7.80E-005, 5.56E-004, 4.47E-003, 2.13E-002, 5.77E-002, 1.19E-001, 2.19E-001, 3.12E-001, 3.98E-001, 4.73E-001, 5.17E-001, 5.56E-001, 5.86E-001, 6.10E-001, 6.39E-001, 6.72E-001, 7.00E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.36E-005, 2.78E-004, 2.19E-003, 1.08E-002, 3.05E-002, 6.63E-002, 1.32E-001, 1.98E-001, 2.64E-001, 3.25E-001, 3.63E-001, 4.01E-001, 4.27E-001, 4.52E-001, 4.79E-001, 5.15E-001, 5.43E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.40E-005, 1.34E-004, 1.02E-003, 5.12E-003, 1.49E-002, 3.38E-002, 7.18E-002, 1.13E-001, 1.58E-001, 2.00E-001, 2.29E-001, 2.60E-001, 2.80E-001, 3.01E-001, 3.23E-001, 3.56E-001, 3.79E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.29E-005, 6.25E-005, 4.52E-004, 2.27E-003, 6.70E-003, 1.57E-002, 3.55E-002, 5.82E-002, 8.45E-002, 1.10E-001, 1.28E-001, 1.50E-001, 1.63E-001, 1.78E-001, 1.93E-001, 2.18E-001, 2.34E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 6.83E-006, 2.81E-005, 1.90E-004, 9.42E-004, 2.78E-003, 6.64E-003, 1.58E-002, 2.67E-002, 4.02E-002, 5.35E-002, 6.31E-002, 7.62E-002, 8.31E-002, 9.31E-002, 1.01E-001, 1.18E-001, 1.27E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.54E-006, 1.22E-005, 7.59E-005, 3.65E-004, 1.06E-003, 2.55E-003, 6.32E-003, 1.10E-002, 1.70E-002, 2.29E-002, 2.73E-002, 3.41E-002, 3.71E-002, 4.25E-002, 4.61E-002, 5.54E-002, 5.97E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.80E-006, 5.11E-006, 2.88E-005, 1.32E-004, 3.74E-004, 8.91E-004, 2.27E-003, 4.00E-003, 6.33E-003, 8.56E-003, 1.03E-002, 1.33E-002, 1.44E-002, 1.69E-002, 1.82E-002, 2.26E-002, 2.42E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 8.97E-007, 2.07E-006, 1.03E-005, 4.47E-005, 1.21E-004, 2.82E-004, 7.34E-004, 1.30E-003, 2.08E-003, 2.80E-003, 3.38E-003, 4.53E-003, 4.86E-003, 5.82E-003, 6.20E-003, 7.97E-003, 8.43E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.39E-007, 8.08E-007, 3.52E-006, 1.41E-005, 3.60E-005, 8.08E-005, 2.12E-004, 3.72E-004, 6.00E-004, 8.00E-004, 9.62E-004, 1.34E-003, 1.41E-003, 1.73E-003, 1.82E-003, 2.41E-003, 2.51E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.10E-007, 3.05E-007, 1.14E-006, 4.14E-006, 9.80E-006, 2.09E-005, 5.48E-005, 9.46E-005, 1.52E-004, 1.99E-004, 2.37E-004, 3.42E-004, 3.54E-004, 4.44E-004, 4.55E-004, 6.26E-004, 6.36E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.90E-008, 1.11E-007, 3.49E-007, 1.13E-006, 2.45E-006, 4.91E-006, 1.26E-005, 2.12E-005, 3.39E-005, 4.29E-005, 5.06E-005, 7.56E-005, 7.63E-005, 9.80E-005, 9.77E-005, 1.39E-004, 1.37E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 4.57E-008, 3.89E-008, 1.02E-007, 2.90E-007, 5.63E-007, 1.04E-006, 2.61E-006, 4.22E-006, 6.60E-006, 8.02E-006, 9.31E-006, 1.44E-005, 1.41E-005, 1.86E-005, 1.79E-005, 2.64E-005, 2.51E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 2.07E-008, 1.32E-008, 2.80E-008, 6.90E-008, 1.19E-007, 2.00E-007, 4.80E-007, 7.38E-007, 1.13E-006, 1.30E-006, 1.48E-006, 2.38E-006, 2.24E-006, 3.02E-006, 2.80E-006, 4.28E-006, 3.90E-006},
		{0.00E+000, 0.00E+000, 0.00E+000, 9.16E-009, 4.30E-009, 7.31E-009, 1.53E-008, 2.29E-008, 3.46E-008, 7.88E-008, 1.14E-007, 1.68E-007, 1.83E-007, 2.02E-007, 3.38E-007, 3.05E-007, 4.21E-007, 3.73E-007, 5.90E-007, 5.12E-007},
		{0.00E+000, 0.00E+000, 0.00E+000, 3.98E-009, 1.36E-009, 1.81E-009, 3.16E-009, 4.05E-009, 5.40E-009, 1.15E-008, 1.55E-008, 2.19E-008, 2.23E-008, 2.38E-008, 4.14E-008, 3.55E-008, 5.03E-008, 4.22E-008, 6.93E-008, 5.70E-008},
		{0.00E+000, 0.00E+000, 0.00E+000, 1.70E-009, 4.12E-010, 4.25E-010, 6.08E-010, 6.57E-010, 7.62E-010, 1.51E-009, 1.87E-009, 2.50E-009, 2.35E-009, 2.42E-009, 4.35E-009, 3.54E-009, 5.14E-009, 4.07E-009, 6.93E-009, 5.35E-009}
};
	
	public CCTownhouseTypical() {
		displayName = "CUREE-Caltech: Townhouse Typical";
		setInitVars();
		ADF = 0.003;
		BDF = 0.218;
		NIML = IML.length;
		register(supportedTypes);
	}

	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getDFArray() {
		return DF;
	}
	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getCOVDFArray() {
		return COVDF;
	}
	public double[][] getDEMMatrix() {
		return DEM;
	}
}
