package scratch.martinez.VulnerabilityModels.DemModels;

import java.util.ArrayList;

import scratch.martinez.VulnerabilityModels.VulnerabilityModel;

public abstract class DEMatrixModelAPI extends VulnerabilityModel {
	protected String displayName = "";
	protected String imt;
	
	/**
	 * See the general contract in VulnerabilityModel.
	 */
	public double getDF(double IML) {
		ArrayList<Double> imls = getIMLVals();
		ArrayList<Double> dfs = getDFVals();
		int idx = imls.indexOf(IML);
		// The unlikely case that a user asks for a pre-computed DF
		if(idx != -1)
			return dfs.get(idx);
		idx = getUpperIdx(imls, IML);
		double x1 = imls.get(idx-1);
		double x2 = imls.get(idx);
		double y1 = dfs.get(idx-1);
		double y2 = dfs.get(idx);
		return linearInterpolate(x1, y1, x2, y2);
	}

	/** See the general contract in VulnerabilityModel */
	public ArrayList<double[]> getDFTable() {
		double[] DF = getDFArray();
		double[] IML = getIMLArray();
		double[] COVDF = getCOVDFArray();
		
		ArrayList<double[]> rtn = new ArrayList<double[]>();
		for(int i = 0; i < NIML; ++i) {
			double[] tmp = {IML[i], DF[i], COVDF[i]}; // Change the 0.0 to COVDF[i] when availble
			rtn.add(tmp);
		}
		return rtn;
	}

	/** See the general contract in VulnerabilityModel */
	public String getDisplayName() { return displayName; }

	/** See the general contract in VulnerabilityModel */
	public String getIMT() { return imt; }

	public abstract double[] getDFArray();
	public abstract double[] getIMLArray();
	public abstract double[] getCOVDFArray();
	
	private static double linearInterpolate(double x1, double y1, double x2, double y2) {
		return 0.0;
	}
	
	private static int getUpperIdx(ArrayList<Double> search, double val) {
		int i = 0;
		while(search.get(i) <= val)
			++i;
		return i;
	}
}
