;
;	Procedure FIND_SEGMENT.PRO
;
;	This procedure plots a map of the faults for the model 
;	seismicity generated by EQSYN.F
;
;	****************************************************************
;
	pro find_segment, nfault, vplatx, vplaty, xfe, xfw, yfe, yfw
;
;	****************************************************************
;
	NF = long(nfault)
;
	XL	=	fltarr(NF,/no)
	XR	=	fltarr(NF,/no)
	YL	=	fltarr(NF,/no)
	YR	=	fltarr(NF,/no)
	XINT	=	fltarr(NF,/no)
	YINT	=	fltarr(NF,/no)

;
;	Locate east, west, north, south limits on faults
;
	xmin1 = min(xfe, nminx1)
	xmin2 = min(xfw, nminx2)
	xmin = xmin1
	nminx = nminx1
	if (xmin2 lt xmin1) then begin
	xmin = xmin2
	nminx = nminx2
	endif

;
	xmax1 = max(xfe, nmaxx1)
	xmax2 = max(xfw, nmaxx2)
	xmax = xmax1
	nmaxx = nmaxx1
	if (xmax2 gt xmax1) then begin
	xmax = xmax2
	nmaxx = nmaxx2
	endif 

;
	ymin1 = min(yfe, nminy1)
	ymin2 = min(yfw, nminy2)
	ymin = ymin1
	nminy = nminy1

	if (ymin2 lt ymin1) then begin
	ymin = ymin2
	nminy = nminy2

	endif

;
	ymax1 = max(yfe, nmaxy1)
	ymax2 = max(yfw, nmaxy2)
	ymax = ymax1
	nmaxy = nmaxy1

	if (ymax2 gt ymax1) then begin
	ymax = ymax2
	nmaxy = nmaxy2

	endif

	print, ' '
	print, 'What segment do you want to find (0 --> nfault-1)?'
	read, segment_to_find
	segment_to_find = long(segment_to_find)

	resp2 = 'y'
;      	print,' '
;      	print,' Omit numbers on the faults? (y/n)'
;      	read, format='(a1)', resp2

;
;	Find Center of Picture
;
	xcenter = (xmin + xmax)/2.
	ycenter = (ymin + ymax)/2.
;
	xlong = 1.25*(xcenter - xmin)
	ylong = 1.25*(ycenter - ymin)


     	axlen = max(xlong,ylong)
	xleft  = -axlen
	xright =  axlen
	
	yup   =  axlen
	ydown = -axlen

;

      	 	XL = xfw - xcenter
    		XR = xfe - xcenter
       		YL = yfw - ycenter
       		YR = yfe - ycenter
      		XINT = .5*(XL + XR)
      		YINT = .5*(YL + YR)

;
 
	loadct, 13	; rainbow

	!P.POSITION =  [0., 0., 1., 1.]


   plot,[0],[0], $                          ; dummies
        xstyle=18,ystyle=18, $              ; extend axes
        xrange=[xleft,xright], $           
        yrange=[ydown,yup], $
        title='Model Faults:  Map View'

;
;	Loop over faults
;
;      !P.charsize = 1.5



	x1	=	fltarr(2,/no)
	y1	=	fltarr(2,/no)

	for i=0L,NF-1 do begin
	x1(0) = XL(i)
	y1(0) = YL(i)
	x1(1) = XR(i)
	y1(1) = YR(i)

;	oplot, x1, y1, linestyle = 0, thick = 8.0, color = 100
	oplot, x1, y1, linestyle = 0, thick = 4.0, color = 100


	if (i eq segment_to_find) then begin
;	oplot, x1, y1, linestyle = 0, thick = 16.0, color = 250
	oplot, x1, y1, linestyle = 0, thick = 12.0, color = 250
	endif

	endfor
;
;
       end
