package org.opensha.sra.vulnerability.models;

import java.util.ArrayList;

import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sra.vulnerability.AbstractVulnerability;

/**
 * This is a simple, perhaps temporary class for instantiating AbstractVulerability objects
 * from files.
 * 
 * @author kevin
 *
 */
public class SimpleVulnerability extends AbstractVulnerability {
	
	private ArrayList<Double> mdfVals;
	private ArrayList<Double> covVals;
	private ArrayList<Double> im_levels;
	
	private DiscretizedFunc vulnFunc;
	
	private static double[] toPrimDoubleArray(ArrayList<Double> vals) {
		double dvals[] = new double[vals.size()];
		
		for (int i=0; i<vals.size(); i++) {
			dvals[i] = vals.get(i);
		}
		return dvals;
	}
	
	public SimpleVulnerability(String name, String shortName, String im_type, ArrayList<Double> im_levels,
			ArrayList<Double> mdfVals, ArrayList<Double> covVals) {
		super(name, shortName, im_type, toPrimDoubleArray(im_levels));
		
		if (im_levels.size() != mdfVals.size())
			throw new IllegalArgumentException("im_levels must be the same size as mdfVals");
		
		if (im_levels.size() != covVals.size())
			throw new IllegalArgumentException("im_levels must be the same size as covVals");
		
		this.im_levels = im_levels;
		this.mdfVals = mdfVals;
		this.covVals = covVals;
		vulnFunc = new ArbitrarilyDiscretizedFunc();
		for (int i=0; i<im_levels.size(); i++) {
			vulnFunc.set(im_levels.get(i), mdfVals.get(i));
		}
	}

	@Override
	public double[] getDEMDFVals() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double[][] getDEMMatrix() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double getDF(double IML) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public ArrayList<double[]> getDFTable() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public DiscretizedFunc getVulnerabilityFunc() {
		return vulnFunc;
	}
	
	@Override
	public String toString() {
		String str = "Vulnurabilyt Function: " + this.getName() + "\n";
		str += "IM Type: " + this.getIMT() + "\n";
		str += "IML\tMDF\tCOV\n";
		for (int i=0; i<im_levels.size(); i++) {
			str += im_levels.get(i) + "\t" + mdfVals.get(i) + "\t" + covVals.get(i) + "\n";
		}
		str += "total vals: " + im_levels.size();
		
		return str;
	}

}
