package org.opensha.sra.vulnerability.models.curee.caltech;

/**
 * <strong>Title:</strong> CCLargeHouseTypical<br />
 * <strong>Description</strong> A digital representation of the CUREE-Caltech Woodframe
 * Project large house typical Sagm(0.2s,5%) vulnerability function. (CWF-202-0205)
 * 
 * @see CureeCaltechWoodFrame
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @author Keith Porter
 *
 */
public class CCLargeHouseTypical extends CureeCaltechWoodFrame {
	
	private static double [] DF = {
		0.000, 0.000, 0.000, 0.000, 0.002, 0.009, 0.019, 0.027, 0.034, 0.041,
		0.047, 0.052, 0.057, 0.062, 0.066, 0.070, 0.074, 0.077, 0.081, 0.084
	};
	
	private static double[] COVDF = {
		2.50, 2.50, 2.50, 2.50, 1.45, 1.00, 0.82, 0.74, 0.70, 0.66,
		0.64, 0.62, 0.61, 0.59, 0.58, 0.57, 0.57, 0.56, 0.55, 0.55
	};
	
	private static double[][] DEM = {
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.90E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.84E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.76E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.65E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.50E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.29E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.03E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.70E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.31E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.84E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.30E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.71E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.07E-001, 9.92E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.40E-001, 9.86E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.72E-001, 9.76E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.04E-001, 9.61E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.39E-001, 9.38E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.79E-001, 9.07E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.25E-001, 8.65E-001, 9.93E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.77E-001, 8.12E-001, 9.86E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.36E-001, 7.47E-001, 9.74E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.02E-001, 6.72E-001, 9.54E-001, 9.92E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 7.47E-002, 5.90E-001, 9.24E-001, 9.84E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.33E-002, 5.03E-001, 8.80E-001, 9.69E-001, 9.91E-001, 9.98E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.72E-002, 4.17E-001, 8.22E-001, 9.44E-001, 9.80E-001, 9.94E-001, 9.98E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.52E-002, 3.34E-001, 7.48E-001, 9.06E-001, 9.62E-001, 9.86E-001, 9.94E-001, 9.97E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.67E-002, 2.58E-001, 6.60E-001, 8.51E-001, 9.31E-001, 9.71E-001, 9.86E-001, 9.93E-001, 9.96E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.08E-002, 1.93E-001, 5.63E-001, 7.77E-001, 8.84E-001, 9.45E-001, 9.70E-001, 9.83E-001, 9.90E-001, 9.95E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.76E-003, 1.39E-001, 4.62E-001, 6.87E-001, 8.17E-001, 9.02E-001, 9.42E-001, 9.65E-001, 9.78E-001, 9.87E-001, 9.92E-001, 9.95E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.99E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.13E-003, 9.59E-002, 3.64E-001, 5.84E-001, 7.31E-001, 8.39E-001, 8.97E-001, 9.32E-001, 9.54E-001, 9.72E-001, 9.80E-001, 9.86E-001, 9.90E-001, 9.92E-001, 9.95E-001, 9.96E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.46E-003, 6.37E-002, 2.73E-001, 4.74E-001, 6.28E-001, 7.54E-001, 8.30E-001, 8.79E-001, 9.13E-001, 9.42E-001, 9.57E-001, 9.69E-001, 9.75E-001, 9.81E-001, 9.87E-001, 9.89E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.42E-003, 4.06E-002, 1.96E-001, 3.67E-001, 5.16E-001, 6.49E-001, 7.40E-001, 8.03E-001, 8.50E-001, 8.92E-001, 9.16E-001, 9.36E-001, 9.48E-001, 9.58E-001, 9.69E-001, 9.74E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 8.01E-004, 2.49E-002, 1.33E-001, 2.69E-001, 4.01E-001, 5.32E-001, 6.30E-001, 7.03E-001, 7.62E-001, 8.17E-001, 8.51E-001, 8.80E-001, 9.00E-001, 9.17E-001, 9.35E-001, 9.43E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 4.39E-004, 1.46E-002, 8.60E-002, 1.86E-001, 2.95E-001, 4.12E-001, 5.08E-001, 5.85E-001, 6.51E-001, 7.15E-001, 7.59E-001, 7.97E-001, 8.25E-001, 8.50E-001, 8.77E-001, 8.90E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.34E-004, 8.19E-003, 5.26E-002, 1.21E-001, 2.04E-001, 2.99E-001, 3.85E-001, 4.58E-001, 5.25E-001, 5.93E-001, 6.42E-001, 6.87E-001, 7.23E-001, 7.54E-001, 7.89E-001, 8.09E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.22E-004, 4.40E-003, 3.04E-002, 7.44E-002, 1.32E-001, 2.03E-001, 2.73E-001, 3.35E-001, 3.97E-001, 4.61E-001, 5.10E-001, 5.57E-001, 5.98E-001, 6.32E-001, 6.73E-001, 6.98E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.13E-005, 2.27E-003, 1.66E-002, 4.28E-002, 8.01E-002, 1.29E-001, 1.80E-001, 2.28E-001, 2.79E-001, 3.33E-001, 3.77E-001, 4.21E-001, 4.62E-001, 4.95E-001, 5.38E-001, 5.66E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.01E-005, 1.12E-003, 8.59E-003, 2.30E-002, 4.52E-002, 7.55E-002, 1.10E-001, 1.43E-001, 1.82E-001, 2.22E-001, 2.57E-001, 2.93E-001, 3.30E-001, 3.59E-001, 3.97E-001, 4.25E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.44E-005, 5.26E-004, 4.18E-003, 1.16E-002, 2.37E-002, 4.10E-002, 6.23E-002, 8.30E-002, 1.09E-001, 1.36E-001, 1.61E-001, 1.87E-001, 2.17E-001, 2.39E-001, 2.69E-001, 2.93E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.66E-006, 2.37E-004, 1.92E-003, 5.43E-003, 1.16E-002, 2.06E-002, 3.24E-002, 4.41E-002, 5.97E-002, 7.60E-002, 9.18E-002, 1.09E-001, 1.30E-001, 1.45E-001, 1.66E-001, 1.84E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.00E-006, 1.02E-004, 8.28E-004, 2.38E-003, 5.24E-003, 9.50E-003, 1.54E-002, 2.15E-002, 2.99E-002, 3.87E-002, 4.76E-002, 5.76E-002, 7.08E-002, 7.95E-002, 9.27E-002, 1.05E-001},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.32E-006, 4.19E-005, 3.37E-004, 9.71E-004, 2.20E-003, 4.04E-003, 6.76E-003, 9.54E-003, 1.37E-002, 1.79E-002, 2.24E-002, 2.75E-002, 3.49E-002, 3.94E-002, 4.66E-002, 5.39E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.61E-007, 1.64E-005, 1.29E-004, 3.69E-004, 8.54E-004, 1.58E-003, 2.71E-003, 3.86E-003, 5.71E-003, 7.48E-003, 9.50E-003, 1.18E-002, 1.55E-002, 1.76E-002, 2.10E-002, 2.48E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.32E-007, 6.17E-006, 4.65E-005, 1.31E-004, 3.07E-004, 5.67E-004, 9.94E-004, 1.43E-003, 2.16E-003, 2.83E-003, 3.64E-003, 4.58E-003, 6.19E-003, 7.03E-003, 8.46E-003, 1.02E-002},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 9.36E-008, 2.21E-006, 1.57E-005, 4.30E-005, 1.02E-004, 1.87E-004, 3.33E-004, 4.78E-004, 7.41E-004, 9.65E-004, 1.25E-003, 1.59E-003, 2.22E-003, 2.52E-003, 3.04E-003, 3.77E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 3.66E-008, 7.57E-007, 5.01E-006, 1.32E-005, 3.13E-005, 5.64E-005, 1.02E-004, 1.46E-004, 2.31E-004, 2.97E-004, 3.88E-004, 4.95E-004, 7.14E-004, 8.05E-004, 9.75E-004, 1.24E-003},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.39E-008, 2.47E-007, 1.50E-006, 3.76E-006, 8.87E-006, 1.56E-005, 2.84E-005, 4.03E-005, 6.50E-005, 8.23E-005, 1.08E-004, 1.38E-004, 2.06E-004, 2.30E-004, 2.78E-004, 3.60E-004},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 5.15E-009, 7.71E-008, 4.21E-007, 9.95E-007, 2.32E-006, 3.95E-006, 7.24E-006, 1.01E-005, 1.66E-005, 2.05E-005, 2.69E-005, 3.43E-005, 5.30E-005, 5.85E-005, 7.04E-005, 9.34E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 1.85E-009, 2.30E-008, 1.11E-007, 2.45E-007, 5.61E-007, 9.16E-007, 1.68E-006, 2.30E-006, 3.82E-006, 4.60E-006, 6.01E-006, 7.64E-006, 1.22E-005, 1.33E-005, 1.58E-005, 2.15E-005},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 6.46E-010, 6.53E-009, 2.76E-008, 5.60E-008, 1.25E-007, 1.94E-007, 3.54E-007, 4.76E-007, 7.97E-007, 9.27E-007, 1.20E-006, 1.52E-006, 2.51E-006, 2.68E-006, 3.15E-006, 4.38E-006},
		{0.00E+000, 0.00E+000, 0.00E+000, 0.00E+000, 2.19E-010, 1.77E-009, 6.42E-009, 1.19E-008, 2.57E-008, 3.78E-008, 6.82E-008, 8.89E-008, 1.50E-007, 1.68E-007, 2.16E-007, 2.69E-007, 4.61E-007, 4.80E-007, 5.56E-007, 7.93E-007}
};

	public CCLargeHouseTypical() {
		super("CUREE-Caltech: Large House Typical", "CCLargeHouseTypical");
		setInitVars();
		ADF = 0.003;
		BDF = 0.218;
		//NIML = IML.length;
		//register(supportedTypes);
	}

	@Override
	protected double[] getDFArray() {
		return DF;
	}
	@Override
	protected double[] getCOVDFArray() {
		return COVDF;
	}

	public double[][] getDEMMatrix() {
		return DEM;
	}
}
