package org.opensha.sra.vulnerability.models.servlet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.opensha.commons.util.ServletPrefs;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.SimpleVulnerability;
import org.opensha.sra.vulnerability.models.VulnFileReader;

public class VulnerabilityServlet extends HttpServlet {
	
	public static final String SERVLET_URL = ServletPrefs.OPENSHA_SERVLET_URL + "VulnServlet";
	
	private static String debugName = "VulnServlet";
	
	private static final String vulnFileName = "";
	
	private HashMap<String, Vulnerability> vulnMap = new HashMap<String, Vulnerability>();
	
	public VulnerabilityServlet() throws IOException {
		ArrayList<SimpleVulnerability> vulns = VulnFileReader.readVUL06File(new FileInputStream(vulnFileName));
		for (SimpleVulnerability vuln : vulns) {
			vulnMap.put(vuln.getName(), vuln);
		}
	}
	
	//Process the HTTP Post request
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// call the doGet method
		doGet(request,response);
	}
	
	// Process the HTTP Get request
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// get an input stream from the applet
		ObjectInputStream in = new ObjectInputStream(request.getInputStream());
		ObjectOutputStream out = new ObjectOutputStream(response.getOutputStream());
		
		try {
			// this is the name. if null, all will be retrieved
			String name = (String)in.readObject();
			
			if (name == null) {
				out.writeObject(vulnMap);
			} else {
				Vulnerability vuln = vulnMap.get(name);
				out.writeObject(vuln);
			}
			
			out.flush();
			out.close();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fail(out, "Servlet Exception: " + e.getMessage());
		}
	}
	
	protected void debug(String message) {
		ServletPrefs.debug(debugName, message);
	}
	
	protected void fail(ObjectOutputStream out, String message) throws IOException {
		ServletPrefs.fail(out, debugName, message);
	}

}
