package org.opensha.step;

import java.util.Calendar;

import junit.framework.TestCase;
import org.junit.Test;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.step.calc.QuakeMLClient;
import org.opensha.step.calc.STEP_main;


public class QuakeMLClientTest extends TestCase {	
	
	@Test
	public void testRetrieveEvents(){
		QuakeMLClient quakemlClient = new QuakeMLClient();		
		Calendar start = STEP_main.getCurrentGregorianTime();
		start.setTimeInMillis(start.getTimeInMillis() - 3*24*60*60*1000l);//back 3 days
		Calendar end = STEP_main.getCurrentGregorianTime();
		ObsEqkRupList quakes = quakemlClient.retrieveEvents(start, end);		
		assertTrue("number of quakes > 0",quakes.size() > 0 );		
	}

}
