subroutine escribe_slip(eventID,ma,st,dip,rake,lat,lon,depth,filen,npunti,SlipModelsFile,m5yn,pathToPrograms)
use strings
parameter (pi=3.141592653589793238)
character*10000 h1
character*1500 h2,camino(npunti),args(10)
character*600 nada
character*1000 SlipModelsFile,pathToPrograms
integer npunti,J,nfallas,nf,nfaults,K,sw,nargs
character*60 eventID(npunti),slipID(npunti),kk
real st(npunti),dip(npunti),rake(npunti),lat(npunti),lon(npunti),depth(npunti),ma(npunti)
real mL,bL,mW,bW,mD,bD,L,W,D,M,parw
character*60 filen
character m5yn


!Leemos los slip model que ya sabemos
open(unit=16,file=SlipModelsFile)
read(16,fmt='(A)',IOSTAT=IOstatus) h1
read(16,fmt='(A)',IOSTAT=IOstatus) h1
read(16,*,IOSTAT=IOstatus) nfaults
write(*,*)nfaults
do J=1,nfaults
    read(16,fmt='(A)',IOSTAT=IOstatus)h2
    !camino(J)=trim(camino(J))
    !slipID(J)=trim(slipID(J))
    !write(*,*)camino(J)
    !write(*,*)h2
    call parse(h2,' ',args,nargs)
    camino(J)=trim(args(4))
    slipID(J)=trim(args(3))
    !write(*,*)camino(J),slipID(J)
enddo
close(16)



open(unit=3,file=filen)
write(3,*)'Number of faults and/or fault segments'
nf=0
do J=1,npunti
    sw=0
    do K=1,nfaults
        if (trim(eventID(J))==slipID(K)) then
            !write(*,*)trim(camino(K))
            sw=1
            open(unit=8,file=trim(camino(K)))
            read(8,fmt='(A)',IOSTAT=IOstatus) h1
            read(8,*,IOSTAT=IOstatus) nfallas
            nf=nf+nfallas
            close(8)
            
        endif
        
    enddo
    
    if (sw==0) then
        if (m5yn =='y') then
            nf=nf+1
        endif
        
    endif
    
enddo
write(3,'(i4)')nf



do J=1,npunti
    sw=0
    do K=1,nfaults
        if (trim(eventID(J))==slipID(K)) then
            sw=1
            open(unit=8,file=trim(camino(K)))
            read(8,fmt='(A)',IOSTAT=IOstatus) h1
            read(8,fmt='(A)',IOSTAT=IOstatus) h1
            read(8,fmt='(A)',IOSTAT=IOstatus) h1
            do while (IOstatus .EQ. 0) 
                write(3,fmt='(A)')trim(h1)
                read(8,fmt='(A)',IOSTAT=IOstatus) h1
            
            enddo
            close(8)
        endif
        
    enddo
    
    if (sw==0) then
    
    
	if (m5yn =='y') then
	!    !Wells & Coppersmith
!    !	mL = 0.59;	bL = -2.44; 	varL = 0.16;
!    !  	mW = 0.32; 	bW = -1.01;	    varW = 0.15;
!    ! 	mA = 0.91; 	bA = -3.49; 	varA = 0.24;
!    !  	mD = 0.69;  bD = -4.80; 	varD = 0.36;
!    !M=ma(J)
!    !write(*,*)ma(J)
!    !pause
!    mL=0.59
!    bL=-2.44
!    mW=0.32
!	bW=-1.01
!	mD=0.69
!	bD=-4.80
!	
!	
!	
	    !Dowrick and Rhoades (2004)
	    if (ma(J) .LE. 6) then
            bL=-2.19;
            mL=0.5;
            bW=-2.19;
            mW=0.5;    
        else
            bL=-2.89;
            mL=0.63;
            bW=-1.02;
            mW=0.31;    

        endif
        bD=-3.04;
        mD=0.5;  
        
        L = 10**(mL*ma(J) + bL);
	    W = 10**(mW*ma(J) + bW);
	    D = 10**(mD*ma(J) + bD);
        
	    parw=W/2;
        if (depth(J) .LT. (parw*sin(dip(J)*pi/180))) then
            parw=depth(J)/sin(dip(J)*pi/180)
        endif
    	
	    write(3,*)'Lat, lon and depth of the hypocenter'
	    write(3,'(3(F8.3,1x))')lat(J),lon(J),depth(J)
	    write(3,*)'Strike and dip of the fault (degrees)'
	    write(3,'(2(F8.3,1x))')st(J),dip(J)
        write(3,*)'Fault length and partial length (km)'
        write(3,'(2(F8.3,1x))')L,L/2
        write(3,*)'Fault width and partial width (km)'
        write(3,'(2(F8.3,1x))')W,parw
        write(3,*)'Number of sub-faults along-strike and -dip'
        write(3,'(2(i3,1x))')1,1
        write(3,*)'Slip along the fault (m)'
        write(3,'(F8.3)')D
        write(3,*)'Slip normal to the fault (m)'
        write(3,'(F8.3)')0
        write(3,*)'Rake of the displacement along the fault (degrees)'
        write(3,'(F8.3)')rake(J)
        endif
    endif
    
enddo
close(3)

return
end