      subroutine coulomb(iformula,perp,stress,stressp,fric,pore,Skc, &
      cohes,strike,dip,rake,cff,strr,strnorm)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!   Calculates the strike, dip and rake for one of the optimal planes 
!   given its normal vector 'perp'.
!   Calculates the coulomb stress function 
!   for one of the optimal planes given
!   - normal and shear stress components 
!     of the perturbed stress field for that plane
!   - pore= pore pressure
!   - cohes= cohesion
!   - fric= friction coefficient
!   - Skc= Skempton coefficient
!   Attention! In this subroutine friction coefficient 'fric' 
!   affects only the cff computation because the optimal plane 
!   orientation is calculated given its normal vector 'perp' 
!   (computed in the subroutine optimal). 
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!   INPUT:
!    - perp= normal to the optimal plane.
!    - stress(6)= total stress field components
!    - stressp(6)= perturbed stress field components
!    - fric= friction
!    - pore= pore pressure
!    - Skc= Skempton coefficient
!    - cohes= cohesion
!   OUTPUT:
!    - strike,dip, rake= strike, dip and rake of the optimal plane 
!    - cff= coulomb stress function for the optimal plane.
!    - strr,strnorm= shear and normal components of the perturbed 
!                    stress field for the optimal plane.

!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - norm2sd
!     - locstrcmpnt
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc 

      real perp(3)
      real stress(6), stressp(6)
      real strvecloc(3)
      parameter (tol = 0.00001)
      parameter (pi=3.1415927, deg2rad=0.17453293e-1, rad2deg=57.295779)


!      Calculate strike and dip of a plane given its normal vector.
	call norm2sd(perp,strike,dip,csdip,xn1,xn2)
!	print *, 'csdip,xn1,xn2',csdip,xn1,xn2


!      Calculate rake on this plane in total stress field
	call locstrcmpnt (stress,strike,dip,strvecloc)
!	print *, 'strvecloc',strvecloc
	rake = -atan2(-strvecloc(2),-strvecloc(1))
	cosr = cos(rake)
	sinr = sin(rake)
 
!      ...and then use the perturbed stress field to calculate the components
 
	call locstrcmpnt (stressp,strike,dip,strvecloc)
 
!      Calculate normal and shear stress components of the perturbed 
!      stress field for the optimal plane orientation 
 
	strr = cosr*(-strvecloc(1)) + sinr*strvecloc(2)
	strnorm = strvecloc(3)

!
!      Calculate the coulomb stress function for one of the optimal planes.
!
     	if (iformula.eq.1) then
	cff = strr + fric*(1.0-Skc)*strnorm 
	else
	cff = strr + fric*(strnorm + Skc*pore)-cohes
        endif
	rake = rake*rad2deg
	if (dip .gt. 90) then
 		strike = 180+strike
 		if (strike .gt.360) strike = strike-360
 		dip =180 -dip
 		rake =-rake
 	endif	
 	if (rake .lt. 0) rake = 360. + rake
	return
	end
