!*********from Bob Simpsons' DCL PROGRAM**********

      subroutine eigenj (a,b,n,n1)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!      From J.C.Davis - Statistics and Data Analysis in Geology
!     (Wiley, pp.166-167).
!
!     Subroutine to calculate the eigenvalues and eigenvectors
!     of an nxn symmetric matrix, by the Jacobi method.
!
!     Upon completion the eigenvalues are stored in the diagonal
!     elements of matrix a (in descending order). The eigenvectors
!     are stored by columns in matrix b.
!
!     Eigenvalue a(i,i) corresponds to eigenvector (b(j,i),j=1,n).
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      dimension a(n1,n1), b(n1,n1)

!     Calculate initial and final norms.

!     Set b to identity matrix
      anorm=0.0
      do 100 i=1,n
      do 101 j=1,n
      if(i-j) 2,1,2
  1   b(i,j)=1.0
      go to 101
  2   b(i,j)=0.0
      anorm=anorm+a(i,j)*a(i,j)
 101  continue
 100  continue
      anorm=sqrt(anorm)
      fnorm=anorm*1.0E-09/float(n)

!     Initialize indicators and compute threshhold.

      thr=anorm
 23   thr=thr/float(n)
  3   ind=0

!     Scan down columns for off-diagonal elements
!     greater than or equal to threshhold

      do 102 i=2,n
      i1=i-1
      do 103 j=1,i1
      if(abs(a(j,i))-thr) 103,4,4

!     Compute sin and cos.

  4   ind=1
      al=-a(j,i)
      am=(a(j,j)-a(i,i))/2.0
      ao=al/sqrt(al**2 + am**2)
      if(am.lt.0.0) ao=-ao
      sinx=ao/sqrt(2.0*(1.0+sqrt(1.0-ao**2)))
      sinx2=sinx**2
      cosx=sqrt(1.0-sinx2)
      cosx2=cosx**2

!     Rotate columns i and j.

      do 104 k=1,n
      if(k-j) 7,10,7
  7   if(k-i) 8,10,8
  8   at=a(k,j)
      a(k,j)=at*cosx-a(k,i)*sinx
      a(k,i)=at*sinx+a(k,i)*cosx
 10   bt=b(k,j)
      b(k,j)=bt*cosx-b(k,i)*sinx
      b(k,i)=bt*sinx+b(k,i)*cosx
 104  continue
      xt=2.0*a(j,i)*sinx*cosx
      at=a(j,j)
      bt=a(i,i)
      a(j,j)=at*cosx2+bt*sinx2-xt
      a(i,i)=at*sinx2+bt*cosx2+xt
      a(j,i)=(at-bt)*sinx*cosx+a(j,i)*(cosx2-sinx2)
      a(i,j)=a(j,i)
      do 105 k=1,n
      a(j,k)=a(k,j)
      a(i,k)=a(k,i)
 105  continue
 103  continue
 102  continue
      if(ind) 20,20,3
 20   if(thr-fnorm) 25,25,23

!     Sort eigenvalues and eigenvectors.

 25   do 110 i=2,n
      j=i
 29   if(a(j-1,j-1)-a(j,j)) 30,110,110
 30   at=a(j-1,j-1)
      a(j-1,j-1)=a(j,j)
      a(j,j)=at
      do 111 k=1,n
      at=b(k,j-1)
      b(k,j-1)=b(k,j)
      b(k,j)=at
 111  continue
      j=j-1
      if(j-1) 110,110,29
 110  continue

      return
      end


