!*********from Bob Simpsons' DCL PROGRAM**********

      subroutine norm2sd (xnorm,strike,dip,csdip,xn1,xn2)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!    Calculates the strike and dip of a plane given 
!    its normal vector 'xnorm'.
!    Normal vector is given in the 1,2,3 (N,E,D) 
!    global coordinate system.
!
!    Convention assumed (even for dip=0):
!  If one stands and extends one's left hand sideways in the direction 
!  of strike, one is looking in the down-dip direction.
!  Normal vector is cross-product of strike direction with dip 
!  direction, so it points downward for dips .ge.0 and .lt.90
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - dot
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      real x1axis(3), x2axis(3), x3axis(3), xnorm(3)
      parameter (pi=3.1415927, deg2rad=0.17453293e-1, rad2deg=57.295779)


      do 10 i=1,3
      x1axis(i) = 0.0
      x2axis(i) = 0.0
      x3axis(i) = 0.0
 10   continue

      x1axis(1) = 1.0
      x2axis(2) = 1.0
      x3axis(3) = 1.0

      call dot (xnorm,x3axis, csdip)
      if (csdip .gt. 1.e10 .or. csdip.lt. -1e10) csdip=0
      dip = acos(csdip) * rad2deg

      if (dip.eq.0.0) then
        strike = 0.0
      else
        call dot (xnorm,x1axis, xn1)
        call dot (xnorm,x2axis, xn2)
        strike = 90.0 + atan2(xn2,xn1)*rad2deg
        strike = mod (strike+360.0, 360.0)
      endif

      return
      end


