         subroutine  optimal(iformula,stressp,stress,fric,Skc, &
      rake1,strike1,dip1,strr1,strnorm1,cff1, &
      rake2,strike2,dip2,strr2,strnorm2,cff2)

!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!   subroutine optimal calculates the coulomb criterion 
!   for optimally oriented faults (fault with orientations
!   to the stress field such that 
!   the Mohr circle is tangent to the fracture criterion)
!   This program is a compilation of subroutines adapted 
!   from Simpson's DLC program. 
!   In the process of checking I realised that the subroutine 
!   norm2sd.f had a bug, which is now fixed for this program 
!   but need to be checked for DLC.
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!   INPUT:
!    - stressp(6)= perturbed stress field components
!    - stress(6)= total stress field components
!    - fric= friction
!    - Skc= Skempton coefficient
!   OUTPUT:
!    - rake1,strike1,dip1= rake, strike and dip of the first optimal plane 
!    - strr1,strnorm1= shear and normal components of the perturbed 
!                      stress field for the first optimal plane.
!    - cff1= coulomb stress function for the first optimal plane.
!    - rake2,strike2,dip2= rake, strike and dip of the second optimal plane 
!    - strr2,strnorm2= shear and normal components of the perturbed 
!                      stress field for the second optimal plane.
!    - cff2= coulomb stress function for the second optimal plane.
!   OTHER DATA:
!    - paxis1,2,3= principal axes of beach ball in global coordinates.
!       p1= axis of max compression => smallest stress eigenvalue in 
!           DIS3D convention.
!       p3= direction of least compression = max extension => largest
!           stress eigenvalue in DIS3D convention.
!    - sig1,2,3= stress eigenvalues from smallest to largest.
!    - psi= angle from axis of max compression to draw fault plane circles.
!    - perp1= normal to the first optimal plane.
!    - perp2= normal to the second optimal plane.
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - vecequal
!     - coulomb
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      real*4 stress(6), stressp(6)
      real*4 paxis1(3), paxis2(3), paxis3(3)
      real*4 paxismax(3), paxismin(3)
      real*4 perp1(3), perp2(3)
      real*4 pore,cohes
      parameter (tol = 0.00001)
      parameter (pi=3.1415927, deg2rad=0.17453293e-1, rad2deg=57.295779)

!      friction and cohesion
	cohes = 0
     	if (iformula.eq.1) then
        fric_eff = fric*(1-SKc)	
	else
	fric_eff = fric
        endif
	psi = 0.25 * pi - 0.5 * atan (fric_eff)
!	print '(a,f8.0,f4.2)',
!     & ' ** Angle of fracture relative to compression axis =',
!     & psi* rad2deg,fric_eff

!      Pore effects
	strave = stressp(1)+stressp(2)+stressp(3)
	pore = - strave / 3.0

!      Find principal axes of stress tensor for total field.
       call princip (stress, sig3, sig2, sig1,paxis3, paxis2, paxis1)
!	print *, 'For total field: '
!	print *, 'sigmin,int,max (tension)',sig1, sig2, sig3
!	print *, 'paxis1:', paxis1
!	print *, 'paxis2:', paxis2
!	print *, 'paxis3:', paxis3

!      Check order of stress eigenvalues.
      if (sig1 .gt. sig3) then
        print *, &
        ' ** Stress eigenvalues out of order in sub WRITEBALL.'
        stop
      endif

!      If smallest principal stress equals largest, quit.
      if (abs(sig1-sig3).lt.tol) then
	print *, 'smallest principal stress equals largest'
	stop
       endif

!      Find normals to the two optimal plane 
      call vecequal (paxis1, paxismax)
      call vecequal (paxis3, paxismin)
!	print *,'paxismax',paxismax
!	print *,'paxismin',paxismin

!      Calculate the normal to the first optimal plane.
 10   do 20 i=1,3
        perp1(i) =   paxismax(i) * sin (psi) &
                  + paxismin(i) * cos (psi)
 20   continue

!      If 2 eigenvalues are equal, switch their axes and do again.
	if (abs(sig3-sig2) .lt. tol) then
	  call vecequal (paxis2, paxismin)
	  	print *, 'sig3-sig2 less than tol'
 	  goto 10
	else if (abs(sig1-sig2) .lt. tol) then
	  call vecequal (paxis2, paxismax)
	  	print *, 'sig1-sig2 less than tol'
 	  goto 10
	endif

!      Calculate the coulomb stress function for the first optimal plane.
      call coulomb(iformula,perp1,stress,stressp,fric,pore,Skc,cohes, &
           strike1,dip1,rake1,cff1,strr1,strnorm1)
!       print *, 'strike1=',strike1
!	print *, 'dip1=',dip1
!	print *, 'rake1=',rake1
! 	print *, 'strnorm1=',strnorm1
!	print *, 'strr1=',strr1
! 	print *, 'cff1=',cff1
!	print *, 'pore=',pore
!	print *, 'cohes=',cohes


!      Calculate the normal to the second optimal plane.
 11   do 21 i=1,3
        perp2(i) = - paxismax(i) * sin (psi)  &
                 + paxismin(i) * cos (psi)
 21   continue

!      If 2 eigenvalues are equal, switch their axes and do again.
	if (abs(sig3-sig2) .lt. tol) then
	  call vecequal (paxis2, paxismin)
	  	print *, 'sig3-sig2 less than tol'
 	  goto 11
	else if (abs(sig1-sig2) .lt. tol) then
	  call vecequal (paxis2, paxismax)
	  	print *, 'sig1-sig2 less than tol'
 	  goto 11
	endif

!     Calculate the coulomb stress function for the second optimal plane.
      call coulomb(iformula,perp2,stress,stressp,fric,pore,Skc,cohes,  &
          strike2,dip2,rake2,cff2,strr2,strnorm2)
!       print *, 'strike2=',strike2
!	print *, 'dip2=',dip2
!	print *, 'rake2=',rake2
! 	print *, 'strnorm2=',strnorm2
!	print *, 'strr2=',strr2
! 	print *, 'cff2=',cff2
!	print *, 'pore=',pore
!	print *, 'cohes=',cohes
	return 
	end
	
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!      end of subroutine optimal
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
