!*********from Bob Simpsons' DCL PROGRAM**********
!
      subroutine princip  &
       (stensor, smax, sint, smin, pamax, paint, pamin) 
         
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Resolves a symmetric 3x3 tensor into principle components 
!     and returns the three principal axis vectors.
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - shsort
!     - cross
!     - eigenj
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      real stensor(6)
      real a(3,3), b(3,3)
      real pamax(3), paint(3), pamin(3)

      real s(3)
      integer neword(3)


!.....Handle degenerate case where tensor is already diagonal, and return.
      if (stensor(4).eq.0.0 .and. stensor(5).eq.0.0 &
           .and. stensor(6).eq.0.0) then
        s(1) = stensor(1)
        s(2) = stensor(2)
        s(3) = stensor(3)
        num = 3
        call shsort (s,neword,num)
!        List "s" is returned sorted.
          imin = neword(1)
          iint = neword(2)
          imax = neword(3)
        smin = s(1)
        sint = s(2)
        smax = s(3)
        do 10 i=1,3
          pamin(i) =  0.0
          paint(i) =  0.0
          pamax(i) =  0.0
 10     continue
          pamin(imin) = 1.0
          paint(iint) = 1.0
          pamax(imax) = 1.0
!       Force a right-handed pamin direction...
        call cross (pamax, paint, pamin)
        return
      endif

!.....Handle non-degenerate case.
      a(1,1) = stensor(1)
      a(2,1) = stensor(4)
      a(3,1) = stensor(5)
      a(1,2) = stensor(4)
      a(2,2) = stensor(2)
      a(3,2) = stensor(6)
      a(1,3) = stensor(5)
      a(2,3) = stensor(6)
      a(3,3) = stensor(3)

      call eigenj (a,b,3,3)

      smax = a(1,1)
      sint = a(2,2)
      smin = a(3,3)

      do 20 i=1,3
        pamax(i) =  b(i,1)
        paint(i) =  b(i,2)
        pamin(i) =  b(i,3)
 20   continue

!     Force a right-handed pamin direction...
      call cross (pamax, paint, pamin)

      return
      end


