!FILE NAME: utm2gp.bas       VERSION : 9102.07      DESIGN DATE:  7/06/88 
!STRUCTURE: Subroutine       AUTHOR  : B. W. Drew                        
!PURPOSE  : Convert UTM to GP                                           
!1419 Wolftrap Run Road   Vienna, VA 22182     (703) 356-9454  
!                           DOCUMENTATION                     
!FUNCTIONAL DESCRIPTION: CONVERTS GRID COORDINATES (ZONE, NORTHING, EASTING ) ***
!TO GEOGRAPHIC COORDINATES (LATITUDE, LONGITUDE) ON THE UNIVERSAL TRANSVERSE
!MERCATOR (UTM) GRID.

!INPUT ARGUMENTS:
!Variable Name      Type  Description
!a#                 dbl   Ellipsoid semi-major axis, meters
!f#                 dbl   Ellipsoid flattening
!izone              int   UTM zone
!y#                 dbl   UTM northing, meters
!x#                 dbl   UTM easting, meters

!OUTPUT ARGUEMENTS:
!Variable Name      Type  Description
!sphi#              dbl   Latitude, radians
!slam#              dbl   Longitude, radians

!REVISION    : yymm.dd           AUTHOR: R. E. Ziegler
!ORGANIZATION: x
!DESCRIPTION : x

	subroutine UTM2GP(latr,lonr,iutm,x,y)

	implicit none

        integer iutm,i

	real*4 latr,lonr,x,y

        real*8 a_axis,b_axis,flattening
        real*8 FE,OK,RECF,ES,EBS
        real*8 TN,AP,BP,CP,DP,EP,DLAM,OLAM
        real*8 T10,T11,T12,T13,T14,T15,T16,T17
        real*8 S,C,T,ETA,SN,TMD,NFN,SR,FTPHI,DE
	real*8 DegToRad,RadToDeg

        parameter (a_axis=6378137.)
        parameter (flattening=1./298.2572236)
        parameter (FE = 500000.,OK = .9996)
        DegToRad=datan(1.D+00)/45.D+00
	RadToDeg=45.D+00/datan(1.D+00)

!************************************************
!****   DERIVE OTHER ELLIPSOID PARAMTERS    *****
!****         FROM INPUT VARIABLES          *****
!****    A = SEMI-MAJOR AXIS OF ELLIPSOID   *****
!**** RECF = RECIPROCAL OF FLATTENING (1/F) *****
!************************************************

!* SEMI MAJOR AXIS - b_axis **
        RECF = 1. / flattening
        b_axis = a_axis*( RECF -1. )/RECF

!* ECCENTRICITY SQUARED **
        ES = ( a_axis**2 -b_axis**2 )/a_axis**2

!* SECOND ECCENTRICITY SQUARED **
        EBS = ( a_axis**2 -b_axis**2 )/b_axis**2

!* TRUE MERIDIONAL DISTANCE CONSTANTS **
	TN = ( a_axis -b_axis )/( a_axis + b_axis )
        AP = a_axis*( 1. -TN +5.*( TN**2 -TN**3)/4. &
     		+81.*( TN**4 -TN**5 )/64.)
        BP = 3.*a_axis*( TN -TN**2  +7.*( TN**3 -TN**4)/8. &
     		+55.*TN**5/64.)/2.
        CP = 15.*a_axis*( TN**2 -TN**3 +3.*( TN**4 -TN**5)/4.)/16.
        DP = 35.*a_axis*( TN**3 -TN**4 +11.*TN**5/16.)/48.
        EP = 315.*a_axis*( TN**4 -TN**5 )/512.

!** HEMISPHERE ADJUSTMENT TO FALSE NORTHING & POINT NORTHING ***
!   NORTHERN HEMISPHERE
	nfn = 0.
!if (y.lt.0) then
!   nfn = 10000000.
!   y = abs(y)
!endif

!* TRUE MERIDIONAL DISTANCE FOR FOOTPOINT LATITUDE **
	TMD = (y-nfn)/OK

!**** FOOTPOINT LATITUDE *****

!* 1ST ESTIMATE **
	SR = a_axis*(1.-ES)/(sqrt(1.-ES*sin(0.)**2))**3
	FTPHI = TMD/SR

!*****************************************
!* ITERATE TO OBTAIN FOOTPOINT LATITUDE **

	do i=1,5

! COMPUTED TRUE MERIDIONAL *
	   T10 = AP*FTPHI-BP*sin(2.*FTPHI)+CP*sin(4.*FTPHI)- & 
              DP*sin(6.*FTPHI)+EP*sin(8.*FTPHI)

! COMPUTED RADIUS OF CURVATURE IN THE MERIDIAN *
	   SR = a_axis*(1.-ES)/(sqrt(1.-ES*sin(FTPHI)**2))**3

! CORRECTED FOOTPOINT LATITUDE *
! NEW FTPOINT = LAST FTPOINT +(TMDACTUAL -TMDCOMP)/RADIUS
	   FTPHI = FTPHI+(TMD-T10)/SR
	enddo

!*****************************************

!* RADIUS OF CURVATURE IN THE MERIDIAN **
	SR= a_axis*(1.-ES)/(sqrt(1.-ES*sin(FTPHI)**2))**3 

!* RADIUS OF CURVATURE IN PRIME VERTICAL **
	SN = a_axis/sqrt(1.-ES*sin(FTPHI)**2)

!* OTHER COMMON TERMS **
        S = sin( FTPHI )
        C = cos( FTPHI )
        T = S/C
        ETA = EBS*C**2

!* DELTA EASTING - DIFFERENCE IN EASTING **
	DE = X -FE

!******************************
!**** LATITUDE *****

	T10 = T/(2.*SR*SN*OK**2)
	T11 = T*(5.+3.*T**2+ETA-4.*ETA**2-9.*T**2*ETA)/ &
     	(24.*SR*SN**3*OK**4)
	T12 = T*(61.+90.*T**2+46.*ETA+45.*T**4-252.*T**2*ETA-3.*ETA**2 &
     	 	+100.*ETA**3-66.*T**2*ETA**2 -90.*T**4*ETA+88.*ETA**4+ &
     		225.*T**4*ETA**2 +84.*T**2*ETA**3-192.*T**2*ETA**4)/ &
     		(720.*SR*SN**5*OK**6)
	T13 = T*(1385.+3633.*T**2 +4095.*T**4+1575.*T**6)/ &	
    	(40320.*SR*SN**7*OK**8)

!* LATITUDE **
	latr = sngl(FTPHI-DE**2*T10+DE**4*T11 -DE**6*T12 +DE**8*T13)

!**** LONGITUDE *****

	T14 = 1./(SN*C*OK)
	T15 = (1.+2.*T**2+ETA)/(6.*SN**3*C*OK**3)
	T16 = (5.+6.*ETA+28.*T**2-3.*ETA**2+8.*T**2*ETA+24.*T**4 &
    		-4.*ETA**3+4.*T**2*ETA**2+24.*T**2*ETA**3)/ &
     		(120.*SN**5*C*OK**5)
	T17 = (61.+662.*T**2 +1320.*T**4 +720.*T**6)/ &
    		(5040.*SN**7*C*OK**7)

!* DIFFERENCE IN LONGITUDE **
	DLAM = DE*T14-DE**3*T15+DE**5*T16-DE**7*T17

!* CENTRAL MERIDIAN **
	OLAM = (iutm*6-183)*DegToRad

! LONGITUDE **
	lonr = sngl(OLAM +DLAM)

	lonr=lonr*RadToDeg
	latr=latr*RadToDeg
	end

