!*********from Bob Simpsons' DCL PROGRAM**********

      subroutine vecg2loc (strike,dip, vg,vl)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!   Converts a vector vg in global coordinates to vector vl in local
!   coordinates.
!   Local coordinate system is attached to a plane defined by strike
!   and dip. Convention used is that looking down-dip, strike is to 
!   the left hand.
!
!   Coordinate systems:
!    Global: (1,2,3) = North, East, Down
!    Local: 1 = Vector in direction of strike.
!           2 = Vector in down-dip direction. (See convention above).
!           3 = Normal vector, got by 1 cross 2 - usually points
!               down and to the left of the strike direction
!               when the rectangle is viewed from the Earth's surface.
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - dot
!     - sd2locaxes
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      real vg(3), vl(3)
      real x1axis(3), x2axis(3), x3axis(3)

      call sd2locaxes (strike,dip,x1axis,x2axis,x3axis)

      call dot(x1axis,vg,vl(1))
      call dot(x2axis,vg,vl(2))
      call dot(x3axis,vg,vl(3))

      return
      end


