      Subroutine auxiliary (strike1,dip1,rake1, &
                           strike2,dip2,rake2)

!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!   Calculates the strike, dip and rake for the auxiliary plane 
!   given the first plane.
!*****************************************************************
!      The relationship between the fault and the auxiliary plane 
!      can be derived since the slip vector of the fault plane is  
!      the normal to the auxiliary plane and vice versa.
!      That is: 
!           vector_lamda1=vector_normal2
!           vector_lamda2=vector_normal1
!*****************************************************************
        double precision degtorad,radtodeg

	degtorad=2.D+0*dasin(1.0D+0)/180.D+0
	radtodeg=180.D+0/(2.D+0*dasin(1.0D+0))
      

      if (rake1.lt.0..and.rake1.ge.-180.) rake1=360.+rake1 
      
      cosstrike1=cos(strike1*degtorad)
      sinstrike1=sin(strike1*degtorad)
      cosdip1=cos(dip1*degtorad)                                                  
      sindip1=sin(dip1*degtorad)                                                  
      cosrake1=cos(rake1*degtorad)
      sinrake1=sin(rake1*degtorad)

      cosdip2=sinrake1*sindip1
      sindip2=sin(acos(cosdip2))
      dip2=acos(cosdip2)*radtodeg
      if (dip2.gt.90..and.dip2.le.180.) & 
     dip2=180.-acos(cosdip2)*radtodeg 

      sinrake2=cosdip1/sindip2
      cosrake2=-sindip1*cosrake1/sindip2
      rake2=atan2(sinrake2,cosrake2)*radtodeg
      if (acos(cosdip2)*radtodeg.gt.90. &
     .and.acos(cosdip2)*radtodeg.le.180.) &
     rake2=360.-atan2(sinrake2,cosrake2)*radtodeg
      if (rake2.lt.0..and.rake2.ge.-180.) rake2=360.+rake2
     
      cosstrike12=-cosdip1*cosdip2/(sindip1*sindip2)
      sinstrike12=cosrake1/sindip2
!      write (*,'(f7.1)')atan2(sinstrike12,cosstrike12)*radtodeg
      strike12=atan2(sinstrike12,cosstrike12)*radtodeg
      if (strike12.lt.0..and.strike12.ge.-180.) strike12=360.+strike12
      strike2=strike1-strike12
      if (acos(cosdip2)*radtodeg.gt.90.&
     .and.acos(cosdip2)*radtodeg.le.180.)& 
     strike2=180.+strike1-strike12
 6    if (strike2.lt.0..and.strike2.ge.-180.) strike2=360.+strike2
      if (strike2.gt.360.) strike2=strike2-360.
    
      return
      end
