!	********************
!	Program FarfalleV2.0
!	May 2002
!	All improvments should be suggested to the authors in order
!	to maintain a single version of the code

!	Contacts: 
!	Concetta Nostro - INGV - Roma - Italy - nostro@ingv.it
!	Oona Scotti - IPSN - Paris - France - oona.scotti@ipsn.fr
!       David Baumont - IPSN - Paris - France - baumont@ipsn.fr
!       Massimo Cocco - INGV - Roma - Italy - cocco@ingv.it
!       *************************************************************

          program main 

!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     This program computes displacement, strain tensor, stress tensor 
!     and the Coulomb Failure Function (CFF) value for many faults 
!     with heterogeneous slip (parallel or normal to the fault plane)
!     in a 3D coordinate system.
!     CFF was computed with or without a regional stress.
!
!     INPUT per spostamenti, deformazioni e sforzi: 
!     - parametri di un grigliato geografico regolare OPPURE
!     - coord. dei punti
!     - parametri delle faglie che dislocano
!     INPUT solo per calcolo CFF:
!     - parametri del meccanismo della faglia secondaria (strike, dip, rake)
!     - OPPURE parametri dello stress regionale

!     OUTPUT: 
!     - spostamenti
!     - deformazioni
!     - sforzi
!     se si conosce la FAGLIA SECONDARIA 
!     - cff indotta su la faglia nota
!     se si considera lo STRESS REGIONALE
!     - cff su ciascuno dei due piani coniugati per stress
!     - strike, dip, rake dei due piani coniugati per stress

!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     UNITA' DI MISURA ADOTTATE (MKS)
!     - Displacement:
!       in meters (m) (if the dislocation along the fault 
!                      and the opening of the fault are in m)
!     - Strain:
!       adimensional 
!      (per ottenere i valori delle deformazioni coerenti
!      con il sistema mks e' necessario introdurre un fattore E-3, 
!      essendo m/Km=E-3; 
!     - stress: 
!       in MPa (if the elastic modulii and 
!               the regional stress are in MPa) 
!       1 bar= 1e6 dine/cm**2= 1e5 N/m**2= 1e5 Pa= 0.1 MPa
!      (per ottenere i valori degli sforzi in bar
!      e' necessario introdurre un fattore 1e-5 se lamda e mu sono 
!      dati in N/m**2.)
!       
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     SISTEMA DI RIFERIMENTO ADOTTATO
!     Il sistema di riferimento geografico ha come origine un 
!     punto sulla superficie terrestre (z=0) nel centro parallelepidedo
!     individuato da: 
!     - ylat1, xlon1 = lat,lon punto basso/sinistra
!     - ylat2, xlon2 = lat,lon punto alto/destra 
!     - profmax = profondita' massima lungo z espresso in km
!     X lungo E, Y lungo N e Z verticale uscente dalla sup. terrestre.
!     il file "griglia_main.inc" contiene le informazioni sul grigliato: 
!     - L=numero di punti lungo l'asse x, M=numero di punti lungo l'asse y,
!     - N=numero di punti lungo l'asse z
!     - e,f=costanti elastiche in mks
!     - nmax=numero max di punti del grigliato 
!     (questo numero deve essere magg. o uguale al prodotto L*M*N!)
!     - ylat1, xlon1 
!     - ylat2, xlon2 
!     - profmax
!     dxe, dyn, dzv=passi lungo lat, long e z rispettivamente, espressi 
!     in gradi e km sono calcolati dal programma
               
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     DEFINIZIONE DEI PARAMETRI 
!     D=dip in gradi
!     x,y,z coord. dell'osservatore
!     A=profondita' della sorgente
!     0,0,-A coord. della sorgente
!     U1,U2,U3 dislocazioni elementari sul piano di faglia
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - GP2UTM
!     - UTM2GP
!     - cambio (included)
!     - pianiconiugati
!     - optimal
!     - dc3d
!     - auxiliary
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc


      	include 'griglia_main.inc'
      character stress_out_file*500
      character fil*50
	character file_slip*200
	integer nas,nad,nFaults
	integer index_as(nFaults_max),index_ad(nFaults_max)
	integer navg_slip
	integer ni,nf,i,j,k,nfix,iutm,npunti,ipunti

	real slip_af(nFaults_max),slip_nf(nFaults_max)
	real rake_f(nFaults_max),las,lad,alla,x_subf,y_subf
	real rupture_area,radius,avg_slip,stressdrop,MW,SM
	real lat_hypo,lon_hypo,depth_hypo
	real hypo_x,hypo_y,as,ad
        real SD,CD
	real SF,CF,CDSF,CDCF,SFSF,SFCF,CFCF
        data F0,F1,EPS/0.e0,1.e0,1.e-6/             

	
        real lat,lon,kmx,kmy,lonh,lath,kmx0,kmy0
        real latit(nmax),long(nmax)
	real fmstrike(2,nmax),fmdip(2,nmax),fmrake(2,nmax), &
       fmmg(nmax),p1(nmax),p2(nmax)

!*******************************************************************
!	-Coordinates of the centrum of the trace of the fault after
!	 projecting it on the surface, and depth of the upper limit
!	 of the fault
!	-Half-length and width of the fault, and of the sub-fault
!	-dip,strike of the fault
!	-slip along the fault, tensile displacement
!*******************************************************************
      	real b1e,b2n,prof
	    real length,width,dlength,dwidth,S,W
      	real D,st
      	real u,u3

        real xx1(nmax),yy1(nmax),xx(nmax),yy(nmax),zz(nmax)
        real UX,UY,UZ,UXX,UYX,UZX,UXY,UYY,UZY,UXZ,UYZ,UZZ 
        real DISPLGEO(nmax,3),DISPLMUL(nmax,3)

        real DEFGEO(nmax,3,3),DEFTOT(nmax,3,3),DEFMUL(nmax,3,3)
        real STREMUL(nmax,3,3),STRER(nmax,3,3)
	real STREREG(nmax,3,3),STREREG1(3,3)   
        real STRETG(2,nmax),STREN(2,nmax),CFF(2,nmax)
        real STRETG1(nmax),STREN1(nmax)
        real CFF1(nmax),DIRTG1(nmax),STRIKEM1(nmax),DIPM1(nmax)
        real STRETG2(nmax),STREN2(nmax)
        real CFF2(nmax),DIRTG2(nmax),STRIKEM2(nmax),DIPM2(nmax)
	character*1 color(nmax)
	character*1 color1(nmax),color2(nmax)
        real strikein,dipin,rakein,som(3,3)
	real strike(nang),dip(nang),rake(nang)
        dimension ASTRIKE(3,3),ADIP(3,3),ATSTRIKE(3,3),ATDIP(3,3)
        dimension GEOFAG(3,3),TGEOFAG(3,3), &
                streprin(3,3),regio(3,3),strind(3,3), &
                regioona(6),strindoona(6)
        dimension PRINGEO(3,3)
        double precision pig,pig2,degtorad,radtodeg
        double precision TR1,PL1,TR2,PL2,TR3,PL3
        real x,y,z,A,B,ce
        character filename*20
        character*1 ansreg, anscomp
        integer ising(nmax)
        character*70 pippo
	  character*40 inputfile

	degtorad=2.D+0*dasin(1.0D+0)/180.D+0
	radtodeg=180.D+0/(2.D+0*dasin(1.0D+0))
	pig =2.D+0*dasin(1.0D+0)
        pig2=4.D+0*dasin(1.0D+0)

!*****************
!	Input file
!*****************

	!write(*,*) 'input file name'
	!read(*,*) inputfile
	inputfile='inCan.dat'
	open(unit=18,file=inputfile)
!	open(unit=18,file='inputfile.dat',status='old')

!	********************************************
!	Choice among displacement, strain and stress
!	Displacement [1], strain [2] or stress [3]?
!	********************************************

	read(18,*) pippo
        read(18,*) kscel

!	*******************************
!	Lamda and mu elastic parameters
!       to produce Okada's parameter 
!	alpha
!
!	ce=alpha
!       e=lambda
!       f=mu
!       ce=1-(Vs/Vp)**2
!       ***********************

        read(18,*) pippo
        read(18,*) e,f
        ce=(e+f)/(e+2*f)


!	***************************
!	REGIONAL STRESS INFORMATION
!	***************************
	read(18,*) pippo
	read(18,*) pippo
	read(18,*) pippo
	read(18,*) pippo

!	***************************************
!	Adding the regional stress field [y/n]?
!	***************************************
        read(18,*) pippo
        read(18,'(a1)')ansreg

!	************************************************************
!	Principal components of the regional stress: s1<s2<s3 (MPa)?
!	Strike and dip of SIGMA1
!	Strike and dip of SIGMA2
!	Strike and dip of SIGMA3
!	************************************************************

        read(18,*) pippo
      	read(18,*) SIGMA1,SIGMA2,SIGMA3
        read(18,*) pippo
        read(18,*) TREND1, PLUNGE1
        read(18,*) pippo
        read(18,*) TREND2, PLUNGE2
        read(18,*) pippo
        read(18,*) TREND3, PLUNGE3




!	******************
!	MAP DISCRETIZATION
!	******************

	read(18,*) pippo
	read(18,*) pippo
	read(18,*) pippo
	read(18,*) pippo

!	****************************************
!	Regular grid [1], or irregular grid [2]?
!	****************************************

	read(18,*) pippo
      	read(18,*) kgri

!       *************
!       REGULAR GRID
!       *************

	read(18,*) pippo

!       ***********************************************
!       Point 1 is located on the SW corner of the zone
!       Point 2 is located on the NE corner of the zone
!       ***********************************************

!	Define the map limits for the calculation

        read(18,*) pippo
        read(18,*) ylat1,xlon1,ylat2,xlon2
        nfix=0
	    call GP2UTM(ylat1,xlon1,iutm,kmx0,kmy0,nfix)
	    nfix=1


!       Define the depth max of the calculation [<0]

        read(18,*) pippo
        read(18,*) profmax

        if (profmax.ge.0.) then 
	  write(*,'('' ** POSITIVE Z WAS GIVEN !'')') 
          stop
	endif
	
!	******************************************
!       Define the number of nodes along lon,lat,z
!	******************************************

        read(18,*) pippo
        read(18,*) L,M,N

!       **********************
!       Number of grid points
!       **********************
        npunti=L*M*N
        if (npunti.gt.nmax) then
           write(6,*) 'L*M*N is larger than nmax', nmax
           stop
        endif

!       **********************************************
!       The secondary fault orientation is the same at
!       each point of the grid
!	Strike,dip and rake (degrees)
!       **********************************************

        read(18,*) pippo
        read(18,*) stcampo1,Dcampo1,rakeCAMPO1

!	**************
!	IRREGULAR GRID
!	**************

	read(18,*) pippo

!	*********************************************************************
!	File describing the location and the geometry of the secondary faults
!	*********************************************************************

        read(18,*) pippo
        read(18,'(a20)') filename

!	*************************************************
!	GEOMETRY AND SLIP DISTRIBUTION OF THE MAIN FAULTS
!	*************************************************

	read(18,*) pippo
	read(18,*) pippo

!       **************************************
!     	Number of faults and/or fault segments
!       **************************************

!	read(18,*) pippo
!     	read(18,*) nsg

!       **********************************************************************
!	Filename with parameters of all the faults or/and multi-segment faults
!       **********************************************************************

	read(18,*) pippo
	read(18,*) pippo
        read(18,*) pippo
        read(18,'(a60)') file_slip
      !fil=TRIM(filename)
      !if (LEN(filename).gt.4) then
      !  stress_out_file= filename(1:LEN(filename)-4)//'_NZ_'//file_slip
	  !else
      !  stress_out_file= filename//'_NZ_'//file_slip
	  !  endif
	
	stress_out_file= 'stress_tot_'//file_slip
      

!	***
!	CFF
!	***

	read(18,*) pippo
        read(18,*) pippo
        read(18,*) pippo       
        read(18,*) pippo


!	******************************************
!       Which CFF formula?
!       [1] cff= stre_tg+fric*(1.-Skc)*stre_no
!       [2] cff= stre_tg+fric*(stre_norm+Skc*pore)
!	******************************************

	read(18,*) pippo
	read(18,*) pippo
	read(18,*) pippo
      	read(18,*) iformula
      

!	*******************************************
!	Friction and Skempton coefficients [0<Sk<1]
!	*******************************************

        read(18,*) pippo
        read(18,*) fr,Skc

        if (Skc.lt.0.or.Skc.gt.1.) stop
        
!	**************************************************************
!       When the regional stress is provided, strike, dip and rake can
!       be fixed or free [ioption_*= 1 (fixed),0 (free)]
!       Strike: ioption_strike, strike value (if ioption_strike=0, 
!               strike value is not considered)
!       Dip: ioption_dip, dip value (if ioption_dip=0, 
!            dip value is not considered)
!       Rake: ioption_rake, rake value (if ioption_rake=0, 
!             rake value is not considered)
!	**************************************************************

	read(18,*) pippo
	read(18,*) pippo
        read(18,*) ioption_strike,strikein	
	read(18,*) pippo
        read(18,*) ioption_dip,dipin	
	read(18,*) pippo
        read(18,*) ioption_rake, rakein
        

!	******
!	OUTPUT
!	******
	
	read(18,*) pippo
	read(18,*) pippo
	read(18,*) pippo
	read(18,*) pippo
	
!	********************************
!	Writing the stress tensor [y/n]?
!	********************************

        read(18,*) pippo
       	read(18,'(a1)') anscomp


!	End of the input loading
!	************************


      if (kgri.eq.1) then

!********************************************
!      REGULAR GRID COMPUTATION
!********************************************


!	************************************
!	Width and length of the map (degree)
!	************************************
        Dlon=xlon2-xlon1
        Dlat=ylat2-ylat1

        write(*,*)' width and length of the map (degree)'
        write(*,*)' width= ', Dlon,' length=',Dlat

!	************************
!	Steps along long and lat
!	************************
	if (L.gt.1) then
           dxe=Dlon/float(L-1)
	else
	   dxe=0.
	endif
	if (M.gt.1) then
           dyn=Dlat/float(M-1)
	else
	   dyn=0.
	endif
	if (N.gt.1) then
	   dzv=-profmax/float(N-1)
	else
	   dzv=0.
	endif

	write(*,*)' Steps along longitude, latitude (degree) and z (km)'
	write(*,*)' dxe= ', dxe,' dyn=',dyn, ' dzv=', dzv

!	**************
!	Discretization
!	**************

       ipunti=0
       do K=1,N
        do J=1,M
         do I=1,L
            ipunti=ipunti+1

            long(ipunti)=xlon1+float(I-1)*dxe
	    latit(ipunti)=ylat1+float(J-1)*dyn
	    zz(ipunti)=profmax+float(K-1)*dzv

            lath=latit(ipunti)
            lonh=long(ipunti)

	    nfix=1
	    call GP2UTM(lath,lonh,iutm,kmx,kmy,nfix)
	    nfix=1
            kmx=kmx/1E3
            kmy=kmy/1E3
      	    xx1(ipunti)=kmx
      	    yy1(ipunti)=kmy
      		    

	    if (ansreg.eq.'n'.or.ansreg.eq.'N') then
	       call auxiliary (stcampo1,Dcampo1,rakeCAMPO1,&
                              stcampo2,Dcampo2,rakeCAMPO2)
               fmstrike(1,ipunti)=stcampo1
	       fmdip(1,ipunti)=Dcampo1
               fmrake(1,ipunti)=rakeCAMPO1
               fmstrike(2,ipunti)=stcampo2
	       fmdip(2,ipunti)=Dcampo2
               fmrake(2,ipunti)=rakeCAMPO2
	    endif
        enddo
       enddo     
      enddo     


      else

!	**************
!	Irregular grid
!	**************


	open(unit=7,file=filename,status='unknown')
	read(7,*)
	read(7,*) npunti
	
!	write(*,*) 'npunti', npunti

	read(7,*)
	read(7,*) lat,lon

	nfix=1
	call GP2UTM(lat,lon,iutm,kmx,kmy,nfix)
	nfix=1

!	write(*,*) 'UTM Zone', iutm

!       ****************************************************
!	The strike,dip, and rake information is used only 
!	if the regional stress is not provided
!	****************************************************

	read(7,*)
      	do ipunti=1,npunti
      	   read(7,*)latit(ipunti),long(ipunti),zz(ipunti),&
           stcampo1,Dcampo1,rakeCAMPO1   
!      	   read(7,*)long(ipunti),latit(ipunti),
!     &      stcampo1,Dcampo1,rakeCAMPO1,fmmg(ipunti),
!     &      p1(ipunti),p2(ipunti),zz(ipunti)   
  	    call auxiliary (stcampo1,Dcampo1,rakeCAMPO1,&
                           stcampo2,Dcampo2,rakeCAMPO2)
            fmstrike(1,ipunti)=stcampo1
	    fmdip(1,ipunti)=Dcampo1
            fmrake(1,ipunti)=rakeCAMPO1
            fmstrike(2,ipunti)=stcampo2
	    fmdip(2,ipunti)=Dcampo2
            fmrake(2,ipunti)=rakeCAMPO2

       	   lath=latit(ipunti)
      	   lonh=long(ipunti)

       	   nfix=1
	   call GP2UTM(lath,lonh,iutm,kmx,kmy,nfix)
	   nfix=1
           kmx=kmx/1E3
           kmy=kmy/1E3
      	   xx1(ipunti)=kmx
      	   yy1(ipunti)=kmy
      	enddo

	close(7)

!     endif of regular grid or irregular grid	
      endif




!*********************************************************
!     Initialization of the matrix ouput
!	-displacement
!	-strain tensor
!	-stress tensor
!**********************************************************

      do ipunti=1,npunti
       do ki = 1, 3
       displmul(ipunti,ki) = 0.0
       enddo
        do kk = 1, 2
         do ii = 1, 2
         DEFMUL(ipunti,ii,kk)= 0.0
         STREMUL(ipunti,ii,kk)= 0.0
         enddo
        enddo
       enddo


!**********************************************************
!  BEGINNING OF THE LOOP FOR FAULT SEGMENTS
!**********************************************************

!       ******************************************
!       Opening the file describing all the faults
!       ******************************************
        
        open(30,status='old',file=file_slip)

	read(30,*) pippo
	print *,pippo
      	read(30,*) nsg
      	print *, nsg
      
       	do 1994 jf = 1, nsg     

!**********************************************************
!  READ THE PARAMETERS FOR EACH FAULT SEGMENT 
!**********************************************************

!	   **********************************************
!	   Lat, lon of and depth of the hypocenter 
!		for earthquake jf
!	   **********************************************
	   read(30,*) 
           read(30,*) lat_hypo,lon_hypo,depth_hypo

!          *************************************
!          Strike and dip of the fault (degrees)
!          *************************************
           read(30,*)
           read(30,*) st,D
	   B=degToRad*D
           T=degToRad*(st-90.)
	   
           SD=sin(B)                                                  
           CD=cos(B)
	   CF=cos(T)
           SF=sin(T)  
           IF(ABS(CD).LT.EPS) THEN                                          
            CD=F0                                                           
            IF(SD.GT.F0) SD= F1                                             
            IF(SD.LT.F0) SD=-F1 
           ENDIF 
           IF(ABS(CF).LT.EPS) THEN                                          
            CF=F0                                                           
            IF(SF.GT.F0) SF= F1                                             
            IF(SF.LT.F0) SF=-F1                                             
           ENDIF 
	                                                               
           CDSF=CD*SF
           CDCF=CD*CF
	   SFSF=SF*SF
	   SFCF=SF*CF
           CFCF=CF*CF	 
!         ************************************
!          Fault length and partial length (km)
!          ************************************
           read(30,*)
           read(30,*) length,dlength


!          **********************************
!          Fault width and partial width (km)
!          **********************************
           read(30,*)
           read(30,*) width,dwidth


!	   *****************************************************
!	   Computation of the depth ot the top of the fault (Km)
!	   *****************************************************

	   prof=depth_hypo-dwidth*SD

!	   ***********************************************************
!	   Computation of the lat, and lon of the centre of the trace
!	   of the fault projected on the surface
!
!
!               Coordinates of the center of the trace relative 
!		to the hypocenter nodes  
!               -as positive from left-to-right
!               -ad positive from bottom-to-top
!               Coordinate change
!               x towards the East, y towards the North 
!          *****************************************************

	   nfix=1
	   call GP2UTM(lat_hypo,lon_hypo,iutm,hypo_x,hypo_y,nfix)
	   nfix=1

	   hypo_x=hypo_x/1E3
	   hypo_y=hypo_y/1E3
	
	   if(SD.eq.F0) then
            write (*,*)'Warning: the dip is zero!'
           else
	    ad= depth_hypo/SD
           endif 
	
	   as= 0.5*length-dlength

           b1e= hypo_x+as*CF+ad*CDSF
           b2n= hypo_y-as*SF+ad*CDCF

!	write(*,*) 'lat_hypo,lon_hypo',lat_hypo,lon_hypo
!	write(*,*) hypo_x+as*CF+ad*CDSF
!	write(*,*) hypo_y-as*SF+ad*CDCF
	
!	   write(*,*) 'Coordinates (km) of the fault centre'
!          write(*,*)' b1e= ', b1e,' b2n=', b2n

!	call UTM2GP(lat,lon,iutm,b1e*1E3,b2n*1E3)

!	write(*,*) 'lat,lon centre trace',lat,lon
!          In Okada's definition, S is the half-length of the fault
           length=length/2.

!	******************************************
!	Number of sub-faults along-strike and -dip
!	******************************************
	read(30,*)
	read(30,*) nas,nad

!	************************
!	Slip along the fault (m)
!	************************
	read(30,*)
	do i=1,nad
	   ni=(i-1)*nas+1
	   nf=i*nas
	   read(30,*) (slip_af(j),j=ni,nf)
!	   do j=ni,nf
!	      slip_af(j)=slip_af(j)/100.
!	   end do
	enddo

!	****************************
! 	Slip normal to the fault (m)
!	****************************
	read(30,*)
	do i=1,nad
	   ni=(i-1)*nas+1
	   nf=i*nas
	   read(30,*) (slip_nf(j),j=ni,nf)
	enddo

!	**************************************************
!	Rake of the displacement along the fault (degrees) 
!	**************************************************
	read(30,*)
	do i=1,nad
	   ni=(i-1)*nas+1
	   nf=i*nas
	   read(30,*) (rake_f(j),j=ni,nf)
	enddo

!	****************************
!	Indexation of the sub-faults
!	****************************
	nFaults=0
	do i=1,nad
	   do j=1,nas
	      nFaults=nFaults+1
	      index_ad(nFaults)=i
	      index_as(nFaults)=j
	   enddo
	enddo


!       *****************************************
!	Initialization of miscelleanous variables
!       *****************************************
	SM=0.
	avg_slip=0.	
	navg_slip=0
	rupture_area=0.
	stressdrop=0.
	vol=0.

!	************************************************
!	Loop on the sub-faults to consider the effect of
!	the heterogeneous slip
!	************************************************
	do k=1,nFaults   
	   i=index_ad(k)
	   j=index_as(k)
	   rk=degToRad*rake_f(k)

!	   *********************
!	   slip on the sub-fault
!	   *********************
	   U = slip_af(k)
	   U1= U*cos(rk)
	   U2= U*sin(rk)
	   U3= slip_nf(k)

!	   *********************
!	   dimension of the cell
!	   *********************
	   las=2.*length/float(nas)
	   lad=width/float(nad)
	   S=las/2.
	   W=lad

!	   ************
!	   Average slip
!	   ************
	   if (U.ne.0.) then
	      avg_slip=avg_slip+U
	      navg_slip=navg_slip+1
	      rupture_area=rupture_area+2.*S*W
	   endif

!	   *******************************************************
!	   Coordinates of the center of the trace of the sub-fault
!	   projected on the surface
!	   *******************************************************

	   alla=(float(j-1)+0.5)*las-length
	   x_subf=b1e+alla*CF
	   y_subf=b2n-alla*SF
	   
           do ipunti=1,npunti
              xx(ipunti)=xx1(ipunti) - x_subf
              yy(ipunti)=yy1(ipunti) - y_subf
           enddo

!	   ************************************
!	   Depth of the bottom of the sub-fault
!	   ************************************
           A=prof+float(i)*lad*SD
	   
!	   ***************************************************
!	   Contribution of the sub-fault to the seismic moment
!	   or to volumetric changes
!	   ***************************************************
      	   if (U.ne.0.)then
      	      SM=SM+2.*S*W*f*U*1.E12 
           else if (U3.ne.0.) then
      	      vol=vol+2.*S*W*U3*1e-3 
           end if

!*********************************************************
!  END OF READING FAULT PARAMETERS
!**********************************************************

!**********************************************************
!             DISPLACEMENTS
!       n.b.: U indica lo spostamento
!             X,Y,Z stanno rispettivamente per le componenti x,y,z
!**********************************************************
!
      if (kscel.eq.1.or.kscel.eq.2.or.kscel.eq.3) then
      do ipunti=1,npunti
        xe=xx(ipunti)
        yn=yy(ipunti) 
        z=zz(ipunti) 
      call CAMBIO(xe,yn,CD,SD,CF,SF,A,x,y)
      call DC3D (ce,x,y,z,A,D,S,S,0.,W,U1,U2,U3,& 
                UX,UY,UZ,UXX,UYX,UZX,UXY,UYY,UZY,UXZ,UYZ,UZZ,IRET) 

!*****COMPONENTI DELLO SPOSTAMENTO DOVUTO AD UNA SINGOLA FAGLIA
!*****NEL SISTEMA DI RIFERIMENTO GEOGRAFICO
        
        DISPLGEO(ipunti,1)= UX*CF+UY*SF
        DISPLGEO(ipunti,2)=-UX*SF+UY*CF
        DISPLGEO(ipunti,3)= UZ

!*****COMPONENTI DELLO SPOSTAMENTO DOVUTO AD UN SISTEMA DI FAGLIE
!*****NEL SISTEMA DI RIFERIMENTO GEOGRAFICO

        DISPLMUL(ipunti,1)=DISPLMUL(ipunti,1)+DISPLGEO(ipunti,1)
        DISPLMUL(ipunti,2)=DISPLMUL(ipunti,2)+DISPLGEO(ipunti,2)
        DISPLMUL(ipunti,3)=DISPLMUL(ipunti,3)+DISPLGEO(ipunti,3)
       
!**********************************************************
!                 STRAIN
!      n.b.: U indica il tensore
!            XX indica la comp. 11 del tensore di def.      
!**********************************************************
        DEFTOT(ipunti,1,1)= UXX*1E-3
        DEFTOT(ipunti,1,2)=(UXY+UYX)/2.*1E-3
        DEFTOT(ipunti,1,3)=(UXZ+UZX)/2.*1E-3
        DEFTOT(ipunti,2,1)=(UXY+UYX)/2.*1E-3
        DEFTOT(ipunti,2,2)= UYY*1E-3
        DEFTOT(ipunti,2,3)=(UYZ+UZY)/2.*1E-3
        DEFTOT(ipunti,3,1)=(UXZ+UZX)/2.*1E-3
        DEFTOT(ipunti,3,2)=(UYZ+UZY)/2.*1E-3
        DEFTOT(ipunti,3,3)= UZZ*1E-3

!*****COMPONENTI DELLA DEFORMAZIONE DOVUTA AD UNA SINGOLA FAGLIA
!*****NEL SISTEMA DI RIFERIMENTO GEOGRAFICO

        DEFGEO(ipunti,1,1)=CFCF*DEFTOT(ipunti,1,1)+&
       SFSF*DEFTOT(ipunti,2,2)+&
       2*SFCF*DEFTOT(ipunti,1,2)
        DEFGEO(ipunti,1,2)=-SFCF*(DEFTOT(ipunti,1,1)&
       -DEFTOT(ipunti,2,2))-(SFSF-CFCF)*DEFTOT(ipunti,1,2)
        DEFGEO(ipunti,1,3)=CF*DEFTOT(ipunti,1,3)&
       +SF*DEFTOT(ipunti,2,3)
        DEFGEO(ipunti,2,1)=DEFGEO(ipunti,1,2)
        DEFGEO(ipunti,2,2)=SFSF*DEFTOT(ipunti,1,1)+&
       CFCF*DEFTOT(ipunti,2,2)-&
       2*SFCF*DEFTOT(ipunti,1,2)
        DEFGEO(ipunti,2,3)=-SF*DEFTOT(ipunti,1,3)& 
      +CF*DEFTOT(ipunti,2,3)
        DEFGEO(ipunti,3,1)=DEFGEO(ipunti,1,3)
        DEFGEO(ipunti,3,2)=DEFGEO(ipunti,2,3)
        DEFGEO(ipunti,3,3)=DEFTOT(ipunti,3,3)

!*****COMPONENTI DELLA DEFORMAZIONE DOVUTA AD UN SISTEMA DI FAGLIE
!*****NEL SISTEMA DI RIFERIMENTO GEOGRAFICO

           do ii = 1, 3
              do jj = 1,3
                 defmul(ipunti,ii,jj)=defmul(ipunti,ii,jj)&
     			+DEFGEO(ipunti,ii,jj)
              enddo
           enddo
        ising(ipunti)=IRET
	enddo

!**********************************************************
!                 END OF COMPUTING STRAIN
!**********************************************************


      end if

!	on the sub-fault
	enddo


	if (navg_slip.ne.0) then
!	   ************************************************************
!	   Computation of the moment magnitude using the Kanamori's law
!	   ************************************************************
	   MW=2./3.*log10(SM*1e7)-10.73

!	   write(*,*) 'Seismic moment (N*m)', SM
!	   write(*,*) 'Moment magnitude ', MW

!	   *****************************************************
!	   Computation of the stress drop for a circular rupture
!          *****************************************************
	   avg_slip=avg_slip/float(navg_slip)

   	   radius=sqrt(rupture_area*1e6/pig)
     	   stressdrop=7./16.*pig*f*avg_slip/radius

!	   write(*,*) 'Stress drop (MPa) ',stressdrop

	else
!	   *******************************************************
!	   Volumetric change produced by the aperture of the fault
!	   i.e the volume between the two faces of the fault
!	   *******************************************************
!      	   write(*,*) 'volumetric changes (km^3)= ', vol

	endif


1994  	continue

	close(30)
!
!**********************************************************
!  END OF THE LOOP FOR FAULT SEGMENTS
!**********************************************************




!**********************************************************
!			STRESS
!	Computation of the total stress due to the fault 
!	system in a geographical coordinate system
!
!**********************************************************

	if (kscel.eq.3) then

	   do ipunti=1,npunti


       STREMUL(ipunti,1,1)=(e*(DEFMUL(ipunti,1,1)+DEFMUL(ipunti,2,2)&
      +DEFMUL(ipunti,3,3))+2*f*DEFMUL(ipunti,1,1))
       STREMUL(ipunti,1,2)=2*f*DEFMUL(ipunti,1,2)
       STREMUL(ipunti,1,3)=2*f*DEFMUL(ipunti,1,3)
       STREMUL(ipunti,2,1)=2*f*DEFMUL(ipunti,2,1)
       STREMUL(ipunti,2,2)=(e*(DEFMUL(ipunti,1,1)+DEFMUL(ipunti,2,2)& 
     +DEFMUL(ipunti,3,3))+2*f*DEFMUL(ipunti,2,2))
       STREMUL(ipunti,2,3)=2*f*DEFMUL(ipunti,2,3)
       STREMUL(ipunti,3,1)=2*f*DEFMUL(ipunti,3,1)
       STREMUL(ipunti,3,2)=2*f*DEFMUL(ipunti,3,2)
       STREMUL(ipunti,3,3)=(e*(DEFMUL(ipunti,1,1)+DEFMUL(ipunti,2,2)&
      +DEFMUL(ipunti,3,3))+2*f*DEFMUL(ipunti,3,3))

	   enddo

      	endif

!**********************************************************
!                OUTPUT FILES
!**********************************************************


!**********************************************************
!            OUTPUT DISPLACEMENT
!**********************************************************

      if (kscel.eq.1) then

!       	 write(*,*)' The displacement was computed'

	 open(11,file='displacement.dat',status='unknown')
!	 write(*,*) 'Output displacement file = displacement.dat'
         write(11,*) 'lon,lat,depth,displx,disply,displz,sing'

         do ipunti=1,npunti
            write(11,'(3(f9.4,1x),3(e10.3,1x),i1)')& 
              long(ipunti),latit(ipunti),zz(ipunti),&
               displmul(ipunti,1),displmul(ipunti,2),&
               displmul(ipunti,3),ising(ipunti)
         enddo

         close(11)

!**********************************************************
!            OUTPUT DEFORMAZIONI
!**********************************************************

       else if (kscel.eq.2) then

!          write(*,*) ' The strain tensor was computed'

          open(11,file='strain_tensor.dat',status='unknown')
!	  write(*,*) 'Output strain tensor = strain_tensor.dat'
          write(11,*) 'lon,lat,depth,exx,exy,exz,eyy,eyz,ezz,sing'

          do ipunti=1,npunti
	     write(11,'(3(f9.4,1x),6(e10.3,1x),i1)') &
     		long(ipunti),latit(ipunti),zz(ipunti),&
     		defmul(ipunti,1,1),defmul(ipunti,1,2),&
     		defmul(ipunti,1,3),defmul(ipunti,2,2),&
     		defmul(ipunti,2,3),defmul(ipunti,3,3),ising(ipunti) 
          enddo

          close(11)

       

!**********************************************************
!            OUTPUT FOR THE STRESS OPTION
!**********************************************************

      else if (kscel.eq.3) then

!      	 write(*,*) 'The stress tensor (MPa) was computed'
       	 if (anscomp.eq.'y'.or.anscomp.eq.'Y') then

            open(11,file='stress_tensor.dat',status='unknown')
!	    write(*,*) 'Output stress tensor = stress_tensor.dat'
            write(11,*) 'lon,lat,depth,sxx,sxy,sxz,syy,syz,szz,sing'

            do ipunti=1,npunti
	       write(11,'(3(f9.4,1x),6(e10.3,1x),i1)') &
     		long(ipunti),latit(ipunti),zz(ipunti),&
     		stremul(ipunti,1,1),stremul(ipunti,1,2),&
     		stremul(ipunti,1,3),stremul(ipunti,2,2),&
     		stremul(ipunti,2,3),stremul(ipunti,3,3),ising(ipunti) 
            enddo

            close(11)

         endif


!**********************************************************
!            PART CONCERNING THE COMPUTATION OF THE CFF 
!     INPUT:
!     - parametri del meccanismo della faglia secondaria (strike, dip, rake)
!       OPPURE    
!     - parametri dello stress regionale:
!       Le tre comp. degli sforzi principali in MPa: SIGMA1,SIGMA2,SIGMA3
!       TREND (azimuth) e PLUNGE di ciascuno dei tre assi principali

!     OUTPUT: 
!     se si conosce la FAGLIA SECONDARIA 
!     - cff indotta su la faglia nota
!     se si considera lo STRESS REGIONALE
!     - cff su ciascuno dei due piani coniugati per stress
!     - strike, dip, rake dei due piani coniugati per stress
!
!**********************************************************


!      write(*,*)' Computation of the CFF'

      If (ansreg.eq.'y'.or.ansreg.eq.'Y') then

!        ************************************************
!   	 Computation of the CFF using the regional stress
!        ************************************************

!********************************************************
!	Making the regional stress tensor in the principal
!	axes system
!********************************************************

        streprin(1,1)=SIGMA1
        streprin(1,2)=0.
        streprin(1,3)=0.
        streprin(2,1)=0. 
        streprin(2,2)=SIGMA2
        streprin(2,3)=0.
        streprin(3,1)=0.
        streprin(3,2)=0.
        streprin(3,3)=SIGMA3

!*****************************************************************
!   DEFINIZIONE DEI PARAMETRI
!  il trend (az) di sigma (uno dei tre assi princ.) e' la direzione 
!  che sigma forma con il nord in senso orario e
!  il plunge e' l'angolo che l'asse forma con il piano orizzontale
!  (positivo verso il basso)
!
!     trend1=trend (azimuth) dell'asse sigma1 in gradi
!     plunge1=plunge dell'asse sigma1 in gradi
!     trend2=trend (azimuth) dell'asse sigma2 in gradi
!     plunge2=plunge dell'asse sigma2 in gradi
!     trend3=trend (azimuth) dell'asse sigma3 in gradi
!     plunge3=plunge dell'asse sigma3 in gradi
!     x=E,y=N,z ortogonale al piano EN, positivo verso l'alto
!*****************************************************************

        TR1=TREND1*degtorad
        PL1=PLUNGE1*degtorad
        TR2=TREND2*degtorad
        PL2=PLUNGE2*degtorad
        TR3=TREND3*degtorad
        PL3=PLUNGE3*degtorad 

        xp=cos(-pl1)*sin(tr1)
        yp=cos(-pl1)*cos(tr1)
        zp=sin(-pl1)

        xt=cos(-pl2)*sin(tr2)
        yt=cos(-pl2)*cos(tr2)
        zt=sin(-pl2)

        xb=cos(-pl3)*sin(tr3)
        yb=cos(-pl3)*cos(tr3)
        zb=sin(-pl3)

!       **************************************************
!	Transformation of the system of coordinates from
!	the principal axes to a geographical system
!       **************************************************

        PRINGEO(1,1)=xp
        PRINGEO(1,2)=yp
        PRINGEO(1,3)=zp
        PRINGEO(2,1)=xt
        PRINGEO(2,2)=yt
        PRINGEO(2,3)=zt
        PRINGEO(3,1)=xb
        PRINGEO(3,2)=yb
        PRINGEO(3,3)=zb

        do jj = 1,3
           do ll = 1,3
              som(jj,ll)=0.
              do mm = 1,3
              som(jj,ll)=som(jj,ll)+streprin(jj,mm)*pringeo(mm,ll)
              enddo
           enddo
       enddo

       do jj = 1,3
          do ll = 1,3
             strereg1(jj,ll)=0.
             do mm = 1,3
             strereg1(jj,ll)=strereg1(jj,ll)+pringeo(mm,jj)*som(mm,ll)
             enddo
          enddo
       enddo
          


!	***********************************************
!      Checking the values of regional and total stress
!	***********************************************

!       write(*,*) 'stress regionale nel sistema geografico'
!       do ii = 1,3
!          write(*,*) (strereg1(ii,jj),jj=1,3)        
!       enddo


       do ipunti = 1, npunti
       
!          if (ipunti.eq.1) then 
!          write(*,*)'t dello sforzo ind nel sist. geogr.(i=j=k=1)'
!          do ii = 1,3
!             write(*,*) (STREMUL(ipunti,ii,jj), jj=1,3)        
!          enddo
!          endif

!        *************************************************
!         total stress=indotto+regionale (STREMUL+strereg1)
!        **************************************************

          do ii = 1,3
           do jj = 1,3
            strereg(ipunti,ii,jj)=STREMUL(ipunti,ii,jj)+ &
           strereg1(ii,jj)
           enddo
          enddo

!          if (ipunti.eq.1) then 
!             write(*,*)'tensore degli sforzi (indotto+regionale)'
!             write(*,*)' nel sist. geo.(i=j=k=1)'
!             do ii = 1,3
!                write(*,*) (strereg(ipunti,ii,jj),jj=1,3)        
!             enddo
!          endif
       enddo

!	*********
!	Check end
!	*********

! *********************************************************************
!            CALCOLO DEI PIANI FAVOREVOLMENTE ORIENTATI
!***********************************************************************
!     Subroutine to find the plane that gives the maximum value 
!     of the CFF, when the regional stress is provided.
!     Strike, dip and rake can be fixed or free [ioption_*= 1 (fixed),0 (free)]:
!     Strike: ioption_strike, strike value
!            (if ioption_strike=0, strike value is not considered)
!     Dip: ioption_dip, dip value
!         (if ioption_dip=0, dip value is not considered)
!     Rake: ioption_rake, rake value 
!          (if ioption_rake=0, rake value is not considered)
!
!
!     INPUT: 
!     - strind= induced stress tensor
!     - regio= regionale stress tensor
!     - Skc= Skempton coefficient
!     - fr= friction coefficient
!     - strike= strike can be fixed or free.
!     - d= dip can be fixed or free.
!     - rake= rake can be fixed or free.
!
!     OUTPUT: 
!     - rakeout(RAD)= rake of the plane that gives the maximum value 
!                     of the CFF computed using the total stress
!     - strikeout(RAD)= strike of the plane that gives the maximum value 
!                       of the CFF computed using the total stress
!     - dipout(RAD)= dip of the plane that gives the maximum value 
!                    of the CFF computed using the total stress
!     - stg_ind= induced stress along that plane
!     - sn_ind= induced stress normal to that plane
!     - cffmax= cff computed on that plane  
!
!      (nb:cffmax ha la stessa unita' di misura dello sforzo strind)
! ***************************************************************************
!
!      write(*,*) 'I am computing the optimal planes' 

      if (ioption_strike.eq.1.or. &
      ioption_dip.eq.1.or.ioption_rake.eq.1) then
!	 ****************************
!	 One or more angles are fixed
!	 ****************************
         strikein=ioption_strike*strikein*degtorad
         dipin=ioption_dip*dipin*degtorad
         rakein=ioption_rake*rakein*degtorad
	 iangoli=0
         if (ioption_strike.eq.1) then 
	 nstrike=1
	 else
	 nstrike=nangst
	 endif
	 
	 if (ioption_dip.eq.1) then 
	 ndip=1
	 else
	 ndip=nangdip
	 endif
	 
	 if (ioption_rake.eq.1) then 
	 nrake=1
	 else
	 nrake=nangrake
	 endif

	 nangoli=nstrike*ndip*nrake

          do ii=1, nstrike
           do jj=1, ndip
            do kk=1, nrake
        iangoli=iangoli+1
        strike(iangoli)=ioption_strike*strikein+(2.*pig/nangst)*(ii-1)
        dip(iangoli)=ioption_dip*dipin+(pig/(2.*(nangdip-1)))*(jj-1)
        rake(iangoli)=ioption_rake*rakein+(2.*pig/nangrake)*(kk-1)
            end do
           end do
          end do


         do ipunti=1,npunti
            do ii=1,3
               do jj=1,3
!	          ****************************************
!		  stress tensor induced by the earthquakes
!	          ****************************************
                  strind(ii,jj)=STREMUL(ipunti,ii,jj)

!                 ****************************************
!                 total stress tensor (induced + regional)
!                 ****************************************
                  regio(ii,jj)=strereg(ipunti,ii,jj)
               enddo
            enddo
	    
	          call pianiconiugati (iformula,nangoli,&
      		strind,regio,fr,skc,&
               strike,dip,rake, &
     		sstrikem1,sdipm1,sdirtg1,sstretg1,sstren1,scff1)


            dirtg1(ipunti)=sdirtg1*radtodeg
            strikem1(ipunti)=sstrikem1*radtodeg
            dipm1(ipunti)=sdipm1*radtodeg
            stretg1(ipunti)=sstretg1
            stren1(ipunti)=sstren1
            cff1(ipunti)=scff1

          enddo 
	  


        else if (ioption_strike.eq.0 &
          .and.ioption_dip.eq.0.and.ioption_rake.eq.0) then

!	 *****************************
!	 Strike, dip and rake are free
!	 *****************************
       
         do ipunti=1,npunti
            do ii=1,3
               do jj=1,3
!	          ****************************************
!		  stress tensor induced by the earthquakes
!	          ****************************************
                  strind(ii,jj)=STREMUL(ipunti,ii,jj)

!                 ****************************************
!                 total stress tensor (induced + regional)
!                 ****************************************
                  regio(ii,jj)=strereg(ipunti,ii,jj)
               enddo
            enddo
        
!	    *******************************************
!	    Duplication of the stress tensors according 
!	    to Simpson's coordinate system 
!	    *******************************************
            strindoona(1)= strind(2,2)
            strindoona(4)= strind(2,1)
            strindoona(5)=-strind(2,3)
            strindoona(2)= strind(1,1)
            strindoona(6)=-strind(1,3)
            strindoona(3)= strind(3,3)

            regioona(1)= regio(2,2)
            regioona(4)= regio(2,1)
            regioona(5)=-regio(2,3)
            regioona(2)= regio(1,1)
            regioona(6)=-regio(1,3)
            regioona(3)= regio(3,3) 

            call optimal (iformula,strindoona,regioona,fr,skc, &
             sdirtg1,sstrikem1,sdipm1,sstretg1,sstren1,scff1, & 
            sdirtg2,sstrikem2,sdipm2,sstretg2,sstren2,scff2)

            dirtg1(ipunti)=sdirtg1
            strikem1(ipunti)=sstrikem1
            dipm1(ipunti)=sdipm1
            stretg1(ipunti)=sstretg1
            stren1(ipunti)=sstren1
            cff1(ipunti)=scff1

            dirtg2(ipunti)=sdirtg2
            strikem2(ipunti)=sstrikem2
            dipm2(ipunti)=sdipm2
            stretg2(ipunti)=sstretg2
            stren2(ipunti)=sstren2
            cff2(ipunti)=scff2

         enddo 

       endif
!      endif for rake free or not
      

      Else 

!	**********************************************
!	Since the regional stress was not provided
!	we assume the secondary faults with a fixed 
!	orientation (strike,dip,rake)
!
!       Computation of the CFF on the secondary faults
!       **********************************************

!     ********************************************
!     The secondary fault orientation is described
!     by the focal mechanisms
!     ********************************************

       do ipunti=1,npunti
        do kk = 1,2
!****************************************************************
!   DEFINIZIONE DELLE MATRICI DI ROTAZIONE
!   - ASTRIKE: permette di passare dal sistema di rif. geogr. 
!              a quello di okada relativo alla faglia di campo 
!   - ADIP: permette di passare dal sistema di rif. di okada 
!           a quello della faglia di campo 
!****************************************************************

      TCAMPO=degToRad*(fmstrike(kk,ipunti)-90.)
      ASTRIKE(1,1)=COS(TCAMPO)
      ASTRIKE(2,1)=SIN(TCAMPO)
      ASTRIKE(3,1)=0.
      ASTRIKE(1,2)=-SIN(TCAMPO)
      ASTRIKE(2,2)=COS(TCAMPO)
      ASTRIKE(3,2)=0.
      ASTRIKE(1,3)=0.
      ASTRIKE(2,3)=0.
      ASTRIKE(3,3)=1.

      BCAMPO=degToRad*fmdip(kk,ipunti)
      ADIP(1,1)=1.
      ADIP(2,1)=0.
      ADIP(3,1)=0.
      ADIP(1,2)=0.
      ADIP(2,2)=-COS(BCAMPO)
      ADIP(3,2)=-SIN(BCAMPO)
      ADIP(1,3)=0.
      ADIP(2,3)=-SIN(BCAMPO)
      ADIP(3,3)=COS(BCAMPO)

!
! CALCOLO LA MATRICE DI ROTAZIONE TOTALE
!

      DO I=1,3
       DO J=1,3
        GEOFAG(I,J)=0.
        TGEOFAG(I,J)=0.
	  ATSTRIKE(I,J)=ASTRIKE(J,I)
        ATDIP(I,J)=ADIP(J,I)
        enddo
        enddo
      
      DO I=1,3
       DO J=1,3
!       GEOFAG(I,J)=0.
!       TGEOFAG(I,J)=0.
!	  ATSTRIKE(I,J)=ASTRIKE(J,I)
!        ATDIP(I,J)=ADIP(J,I)

        DO K=1,3 
        GEOFAG(I,J)=GEOFAG(I,J)+ADIP(I,K)*ASTRIKE(K,J)
        TGEOFAG(I,J)=TGEOFAG(I,J)+ATSTRIKE(I,K)*ATDIP(K,J)
        END DO
       END DO
      END DO

!**************************************************************
!    CALCOLO DEI TENSORI DI SFORZO NEL SISTEMA
!    DELLA FAGLIA DI CAMPO
!************************************************************** 

        do ii = 1,3
         do jj = 1,3
         STRER(ipunti,ii,jj)=0.   
          do ll = 1,3
          som(ll,jj)=0. 
           do mm = 1,3
           som(ll,jj)=som(ll,jj)+STREMUL(ipunti,ll,mm)*TGEOFAG(mm,jj)     
           enddo
           STRER(ipunti,ii,jj)=STRER(ipunti,ii,jj)+ &
     	                       GEOFAG(ii,ll)*som(ll,jj)
          enddo
         enddo
        enddo
        RKCAMPO=degToRad*fmrake(kk,ipunti)
        STREN(kk,ipunti)=STRER(ipunti,3,3)
        STRETG(kk,ipunti)=(STRER(ipunti,1,3))*cos(RKCAMPO) &
       -(STRER(ipunti,2,3))*sin(RKCAMPO)               
     	if (iformula.eq.1) then
        CFF(kk,ipunti)=STRETG(kk,ipunti)+fr*(1-SKc)*STREN(kk,ipunti)	
	else
        CFF(kk,ipunti)=STRETG(kk,ipunti) &
          +fr*STREN(kk,ipunti) &
          -SKc/3.*(STRER(ipunti,1,1) &
         +STRER(ipunti,2,2)+STREN(kk,ipunti))
        endif
	enddo
	stretg1(ipunti)= STRETG(1,ipunti)
        stren1(ipunti)=  STREN(1,ipunti)
	cff1(ipunti)=    CFF(1,ipunti)
	strikem1(ipunti)=fmstrike(1,ipunti)
        dipm1(ipunti)=   fmdip(1,ipunti)
	dirtg1(ipunti)=  fmrake(1,ipunti)
	stretg2(ipunti)= STRETG(2,ipunti)
        stren2(ipunti)=  STREN(2,ipunti)
	cff2(ipunti)=    CFF(2,ipunti)
	strikem2(ipunti)=fmstrike(2,ipunti)
        dipm2(ipunti)=   fmdip(2,ipunti)
	dirtg2(ipunti)=  fmrake(2,ipunti)
       enddo


       End if
!      end of If for the computation of the CFF with or without 
!	regional stress



!**********************************************************************
!**********************************************************************
!	Writing the output of the CFF
!**********************************************************************
!**********************************************************************

!	write(*,*)'Output file name= '//stress_out_file

        open(3,file=stress_out_file,status='unknown')

!	   **********************************
!	   Regional stress considered or not 
!	   **********************************
           write(3,*) ' lon lat depth vol tg norm cff strike ' &
          //'dip rake tg norm cff strike dip rake'

      	   do ipunti=1,npunti
	      if (dirtg1(ipunti).gt.180.) dirtg1(ipunti)= &
     	      dirtg1(ipunti)-360.
	      if (dirtg2(ipunti).gt.180.) dirtg2(ipunti)= &
            dirtg2(ipunti)-360.
     	       if (strikem1(ipunti).lt.strikem2(ipunti)) then 
	      write(3,'(3(f9.4,1x),e10.3,1x,2(3(e10.3,1x),3f7.1,1x))')  &
     		long(ipunti),latit(ipunti), & 
              zz(ipunti),1/3.*(STREMUL(ipunti,1,1)+ &
     		STREMUL(ipunti,2,2)+STREMUL(ipunti,3,3)),stretg1(ipunti), &
     		stren1(ipunti),cff1(ipunti),strikem1(ipunti), &    
          dipm1(ipunti),dirtg1(ipunti),stretg2(ipunti),& 
              stren2(ipunti),cff2(ipunti),strikem2(ipunti),& 
              dipm2(ipunti),dirtg2(ipunti)

	       else 
		
		      write(3,'(3(f9.4,1x),e10.3,1x,2(3(e10.3,1x),3f7.1,1x))') &	
     	    long(ipunti),latit(ipunti), & 
              zz(ipunti),1/3.*(STREMUL(ipunti,1,1)+ &	
     	    STREMUL(ipunti,2,2)+STREMUL(ipunti,3,3)),stretg2(ipunti),& 
              stren2(ipunti),cff2(ipunti),strikem2(ipunti), &  
            dipm2(ipunti),dirtg2(ipunti),stretg1(ipunti), &
     		stren1(ipunti),cff1(ipunti),strikem1(ipunti),  &
             dipm1(ipunti),dirtg1(ipunti) 
     
	       endif
	   enddo
	   
	close(3)

        if (ansreg.eq.'n'.or.ansreg.eq.'N') then
!        write(*,*) 'Second output stress tensor = stress_color.dat'
        open(3,file='stress_color.dat',status='unknown')

!	   **********************************
!	   Regional stress not considered 
!	   **********************************
           write(3,*) ' lon lat depth vol tg norm cff strike ' & 
         //'dip rake tg norm cff strike dip rake color'

      	   do ipunti=1,npunti
	      if (dirtg1(ipunti).gt.180.) dirtg1(ipunti)= &
     	      dirtg1(ipunti)-360.
	      if (dirtg2(ipunti).gt.180.) dirtg2(ipunti)= & 
            dirtg2(ipunti)-360.

	       if (cff1(ipunti).ge.cff2(ipunti)) then 
 
                if (cff1(ipunti).ge.0..and.cff2(ipunti).ge.0.) &
                   color(ipunti)='r'
                 
     		if (cff1(ipunti).ge.0..and.cff2(ipunti).lt.0.) &  
                 color(ipunti)='g'

     		if (cff1(ipunti).lt.0..and.cff2(ipunti).lt.0.) & 
                color(ipunti)='b'
                
	        write(3,'(3(f9.4,1x),e10.3,1x,2(3(e10.3,1x),3f7.1,1x),a1)')  &	
     	long(ipunti),latit(ipunti), & 
              zz(ipunti),1/3.*(STREMUL(ipunti,1,1)+ &	
     	STREMUL(ipunti,2,2)+STREMUL(ipunti,3,3)),stretg1(ipunti), &	
     	stren1(ipunti),cff1(ipunti),strikem1(ipunti), & 
              dipm1(ipunti),dirtg1(ipunti),stretg2(ipunti),&  
              stren2(ipunti),cff2(ipunti),strikem2(ipunti), &  
             dipm2(ipunti),dirtg2(ipunti),color(ipunti)

	       else 
	       
                 if (cff2(ipunti).ge.0..and.cff1(ipunti).ge.0.) &
                  color(ipunti)='r'

                 if (cff2(ipunti).ge.0..and.cff1(ipunti).lt.0.) &
                  color(ipunti)='g'

                 if (cff2(ipunti).lt.0..and.cff1(ipunti).lt.0.) &
                  color(ipunti)='b'
                 

		write(3,'(3(f9.4,1x),e10.3,1x,2(3(e10.3,1x),3f7.1,1x),a1)')  &
     		long(ipunti),latit(ipunti), &
               zz(ipunti),1/3.*(STREMUL(ipunti,1,1)+ &
     		STREMUL(ipunti,2,2)+STREMUL(ipunti,3,3)),stretg2(ipunti), &  
             stren2(ipunti),cff2(ipunti),strikem2(ipunti), & 
              dipm2(ipunti),dirtg2(ipunti),stretg1(ipunti), &
     		stren1(ipunti),cff1(ipunti),strikem1(ipunti), & 
              dipm1(ipunti),dirtg1(ipunti),color(ipunti)
     
	       endif
	   enddo
	   
	close(3)


	else
!        write(*,*) 'Second output stress tensor = stress_color.dat'
        open(3,file='stress_color.dat',status='unknown')

!	   **********************************
!	   Regional stress is considered 
!	   **********************************
           write(3,*) ' lon lat depth vol tg norm cff strike '  &
         //'dip rake tg norm cff strike dip rake color1 color2'

      	   do ipunti=1,npunti
	      if (dirtg1(ipunti).gt.180.) dirtg1(ipunti)= &
     	      dirtg1(ipunti)-360.
	      if (dirtg2(ipunti).gt.180.) dirtg2(ipunti)= &
             dirtg2(ipunti)-360.
	       
	        if (cff1(ipunti).ge.0.) color1(ipunti)='r'
     		if (cff1(ipunti).lt.0.) color1(ipunti)='b'

	        if (cff2(ipunti).ge.0.) color2(ipunti)='r'
     		if (cff2(ipunti).lt.0.) color2(ipunti)='b'
     
	        write(3,'(3(f9.4,1x),e10.3,1x,2(3(e10.3,1x),3f7.1,1x),a1,  &
    			1x,a1)')    &	
  	        long(ipunti),latit(ipunti), &
               zz(ipunti),1/3.*(STREMUL(ipunti,1,1)+ &
    	    STREMUL(ipunti,2,2)+STREMUL(ipunti,3,3)),stretg1(ipunti), &	
    		stren1(ipunti),cff1(ipunti),strikem1(ipunti),  &
              dipm1(ipunti),dirtg1(ipunti),stretg2(ipunti),  &
              stren2(ipunti),cff2(ipunti),strikem2(ipunti), & 
                 dipm2(ipunti),dirtg2(ipunti), &
                 color1(ipunti),color2(ipunti)

	   enddo
	   
	close(3)


	endif
      endif
    
!      stop 'ciao conci!!!'
        
      stop
      end program
      

      subroutine CAMBIO(xe,yn,CD,SD,CF,SF,A,x,y)
!     trasforma le coord. geografiche in x e y di Okada.
      data F0/0.e0/             

      if(SD.eq.F0) then
       write (*,*)'Warning: the dip is zero!'
      else
       x1=xe*CF-yn*SF
       y1=xe*SF+yn*CF
       y0=A*CD/SD
       x=x1
       y=y1+y0
      endif 
      return
      end
