      subroutine pianiconiugati (iformula,nangoli, &
      		strind,regio,fr,skc, &
               st,d,rake, & 
     		strikeout,dipout,rakeout,stg_ind,sn_ind,cffmax)

!***********************************************************************
!     Subroutine to find the plane that gives the maximum value 
!     of the CFF, when the regional stress is provided.
!     Strike, dip and rake can be fixed or free.
!
!     INPUT: 
!     - strind= induced stress tensor
!     - regio= regionale stress tensor
!     - Skc= Skempton coefficient
!     - fr= friction coefficient
!     - st= strike can be fixed or free.
!     - d= dip can be fixed or free.
!     - rake= rake can be fixed or free.
!
!     OUTPUT: 
!     - rakeout(RAD)= rake of the plane that gives the maximum value 
!                     of the CFF computed using the total stress
!     - strikeout(RAD)= strike of the plane that gives the maximum value 
!                       of the CFF computed using the total stress
!     - dipout(RAD)= dip of the plane that gives the maximum value 
!                    of the CFF computed using the total stress
!     - stg_ind= induced stress along that plane
!     - sn_ind= induced stress normal to that plane
!     - cffmax= cff computed on that plane  
!
!**************************************************************************
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - gf (included)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      include 'griglia_main.inc'

      real regio(3,3), strind(3,3)
      real st(nang), d(nang), rake(nang) 
      real sr(3,3)
      integer iformula
      real strikeout,dipout,rakeout,stg_ind,sn_ind,cffmax

      double precision pig,uno
      uno=1.
      pig=2.*dasin(uno)


	   if (iformula.eq.1) then
!     ****************************************
!     iformula=1  
!     [1] cff= stre_tg+fric*(1.-Skc)*stre_norm
!     ****************************************


!	 *********************************
!	 Initialization of the grid search
!	 *********************************
         cffmax=-1.e30
         strikeout=0.
         dipout=0.
	 rakeout=0.
	 
          do iangoli=1, nangoli
           call gf(regio,st(iangoli),d(iangoli),sr)
           sn=sr(3,3)  
           tg=sr(1,3)*cos(rake(iangoli))-sr(2,3)*sin(rake(iangoli))
           cffwr=tg+fr*(1-Skc)*sn
!          *******************************
!          Searching the maximum cff value
!          *******************************
           if (cffwr.gt.cffmax) then
            cffmax=cffwr
            strikeout=st(iangoli)
	    dipout=d(iangoli)
            rakeout=rake(iangoli)
           endif
          end do

!         ******************************************************
!	  Tangential and normal components of the induced stress
!         The maximum cff value computed with the induced stress
!         ******************************************************

          call gf(strind,strikeout,dipout,sr)
          stg_ind=sr(1,3)*cos(rakeout)-sr(2,3)*sin(rakeout)        
          sn_ind=sr(3,3)
          cffmax=stg_ind+fr*(1-Skc)*sn_ind

!********verifica
!       write(*,'(3(f6.1,4x),f9.4)')180./pig*strikeout,
!     &       180./pig*dipout,
!     &       180./pig*rakeout,cffmax



           else
!     *******************************************
!     iformula=2  
!     [2] cff= stre_tg+fric*(stre_norm+Skc*pore)
!     *******************************************


!	 *********************************
!	 Initialization of the grid search
!	 *********************************
         cffmax=-1.e30
         strikeout=0.
         dipout=0.
	 rakeout=0.
	 
          do iangoli=1, nangoli
           call gf(regio,st(iangoli),d(iangoli),sr)
           sn=sr(3,3)  
           tg=sr(1,3)*cos(rake(iangoli))-sr(2,3)*sin(rake(iangoli))
           cffwr=tg+fr*(sn-Skc/3.*(sr(1,1)+sr(2,2)+sr(3,3)))
!          *******************************
!          Searching the maximum cff value
!          *******************************
           if (cffwr.gt.cffmax) then
            cffmax=cffwr
            strikeout=st(iangoli)
	    dipout=d(iangoli)
            rakeout=rake(iangoli)
           endif
          end do

!         ******************************************************
!	  Tangential and normal components of the induced stress
!         The maximum cff value computed with the induced stress
!         ******************************************************

          call gf(strind,strikeout,dipout,sr)
          stg_ind=sr(1,3)*cos(rakeout)-sr(2,3)*sin(rakeout)        
          sn_ind=sr(3,3)
          cffmax=stg_ind+fr*(sn_ind-Skc/3.*(sr(1,1)+sr(2,2)+sr(3,3)))

!********verifica
!       write(*,'(3(f6.1,4x),f9.4)')180./pig*strikeout,
!     &       180./pig*dipout,
!     &       180./pig*rakeout,cffmax


           endif


      return
      end

!**************************************************************************
!  subroutine per generare la matrice di rotazione da sistema geografico
!  al sistema della faglia con strike=STRIKE e dip=DIP e la rotazione del 
!  tensore di stress da S nel geografico a SR nel sistema di faglia
!************************************************************************** 
!  INPUT: s, strike, dip
!
!  OUTPUT: sr

      subroutine gf(s,strike,dip,sr)
      dimension astrike(3,3),adip(3,3),geofag(3,3),s(3,3),sr(3,3)
      dimension som(3,3)
      double precision pig,uno
      uno=1.
      pig=2.*dasin(uno)

          tcampo=strike-pig/2.
          bcampo=dip

          astrike(1,1)=cos(tcampo)
          astrike(2,1)=sin(tcampo)
          astrike(3,1)=0
          astrike(1,2)=-sin(tcampo)
          astrike(2,2)=cos(tcampo)
          astrike(3,2)=0
          astrike(1,3)=0
          astrike(2,3)=0
          astrike(3,3)=1
          adip(1,1)=1
          adip(2,1)=0
          adip(3,1)=0
          adip(1,2)=0
          adip(2,2)=-cos(bcampo)
          adip(3,2)=-sin(bcampo)
          adip(1,3)=0
          adip(2,3)=-sin(bcampo)
          adip(3,3)=cos(bcampo)

!   MATRICE DI ROTAZIONE GEOGRAFICO-FAGLIA geofag

          do i=1,3
            do j=1,3
              geofag(i,j)=0
              do k=1,3 
               geofag(i,j)=geofag(i,j)+adip(i,k)*astrike(k,j)
              end do
            end do
          end do

          do i = 1,3
           do j = 1,3
            sr(i,j)=0
            do l = 1,3
             som(l,j)=0.
             do m = 1,3
              som(l,j)=som(l,j)+s(l,m)*geofag(j,m)     
             enddo
            sr(i,j)=sr(i,j)+geofag(i,l)*som(l,j)
            enddo
           enddo
          end do 
          return
          end
 
