!*********from Bob Simpsons' DCL PROGRAM**********

      subroutine sd2locaxes (strike,dip,x1axis,x2axis,x3axis)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!   Calculates the local-coordinate-system axis-vectors for 
!   a plane defined by strike and dip.  
!   The local axis vector components are given in the
!   1,2,3 (N,E,D) global coordinate system.
!
!   Local coordinate system is attached to the plane like this.
!   Axes: 1 = Vector in direction of strike.
!         2 = Vector in down-dip direction. (See convention below).
!         3 = Normal vector, got by 1 cross 2 - usually points
!             down and to the left of the strike direction
!             when the rectangle is viewed from the Earth's
!             surface.
!
!   Convention assumed (even for dip=0):
!   If one stands and extends one's left hand sideways in the 
!   direction of strike, one is looking in the down-dip direction.
!   Normal vector is cross-product of strike direction with down-dip
!   direction, so it points downward for dips .ge.0 and .lt.90
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Its subroutine:
!     - cross
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      real x1axis(3), x2axis(3), x3axis(3)
      parameter (pi=3.1415927, deg2rad=0.17453293e-1, rad2deg=57.295779)

      cosstr = cos ( strike * deg2rad )
      sinstr = sin ( strike * deg2rad )
      cosdip = cos ( dip * deg2rad )
      sindip = sin ( dip * deg2rad )

!     x1axis points along strike.
      x1axis(1) = cosstr
      x1axis(2) = sinstr
      x1axis(3) = 0.0

!     x2axis points down-dip. (See assumed convention above.)
      x2axis(1) = - sinstr * cosdip
      x2axis(2) =   cosstr * cosdip
      x2axis(3) =   sindip

!     x3axis is perpendicular to the plane in a right-handed sense.
      call cross (x1axis,x2axis,x3axis)

      return
      end


