!*********from Bob Simpsons' DCL PROGRAM**********

      subroutine stress2trac (stress, xperp, traction)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!     Calculates traction vector (in global 1,2,3 coordinates) acting
!     on a plane with normal vector 'xperp'.  Stress tensor in the 
!     global coordinate system is given by 'stress'.
!
!     AMBIGUITY HERE...
!       NEED TO STATE CONVENTIONS (WHICH SIDE OF PLANE ACTS ON WHICH?)
!
!       Essentially a matrix multiplication.
!       stress = symmetric stress tensor (6 components):
!          stress(1 or 2 or 3) = sig11 or sig22 or sig33
!          stress(4 or 5 or 6) = sig12 or sig13 or sig23
!       xperp = normal to the plane.
!       traction = stress resolved onto the plane (= a vector given in
!          global coordinates).
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      real  stress(6), xperp(3), traction(3)


      traction(1) =       stress(1) * xperp(1) &
                       + stress(4) * xperp(2) & 
                      + stress(5) * xperp(3)

      traction(2) =       stress(4) * xperp(1) &
                       + stress(2) * xperp(2) &
                       + stress(6) * xperp(3)

      traction(3) =       stress(5) * xperp(1) &
                       + stress(6) * xperp(2)  &
                      + stress(3) * xperp(3)

      return
      end


