program CSEP
use strings
parameter (nmax=10000000)
character*600 h1,nada
character*14 date(nmax),datestr,date1,datefin
character*60 eventID(nmax),eventID1
character*1000 master_fid,fileoutSTEP,fileinput,arg,args2(10)
character*60 filen
character*1000 path1,SlipModelsFile,moment_tensor_file,pathToPrograms
character*1100 programa,h2
real lon(nmax),lat(nmax),st1(nmax),dip1(nmax),rake1(nmax),st2(nmax),dip2(nmax),rake2(nmax),prof(nmax),mw(nmax),ml(nmax)
real st(nmax),dip(nmax),rake(nmax)
integer K,npuntos,year,month,day,hour,min,nargs
real x(16),kk,daten(nmax),sec,mmin,datfin,dat
character*60 filename,gridfile
character yn1,m5yn
integer grid,grx,gry,grz
real lam,mu,s1,s2,s3,str1,str2,str3,d1,d2,d3
real lat1,lat2,lon1,lon2,depth
real sta,dipa,rakea,fric,sk
real resolution

!write(*,*) 'Please write the name of the master file'
!read(*,*) master_fid
!fileinput='./parameter_input.txt'
call get_command_argument(1, arg)
fileinput=TRIM(arg)
write(*,*) fileinput

open(unit=16,file=fileinput)
read(16,fmt='(A)',IOSTAT=IOstatus)h2
call parse(h2,' ',args2,nargs)
master_fid=trim(args2(2))
read(16,fmt='(A)',IOSTAT=IOstatus)h2
call parse(h2,' ',args2,nargs)
pathToPrograms=trim(args2(2))
read(16,*)nada,datefin
read(16,fmt='(A)',IOSTAT=IOstatus)h2
call parse(h2,' ',args2,nargs)
SlipModelsFile=trim(args2(2))
!SlipModelsFile=trim(SlipModelsFile)
read(16,fmt='(A)',IOSTAT=IOstatus)h2
call parse(h2,' ',args2,nargs)
moment_tensor_file=trim(args2(2))
!moment_tensor_file=trim(moment_tensor_file)
read(16,fmt='(A)',IOSTAT=IOstatus)h2
call parse(h2,' ',args2,nargs)
fileoutSTEP=trim(args2(2))

close(16)
!write(*,*)master_fid
!We read the master file
open(unit=15,file=trim(master_fid))

filen='slip_m5.dat'
filename='inCan.dat'
gridfile='Hyp_dar.dat'
read(15,fmt='(A)')nada
read(15,*)lam,mu
read(15,fmt='(A)')nada
read(15,fmt='(A)')yn1
read(15,fmt='(A)')nada
read(15,*)s1,s2,s3
read(15,fmt='(A)')nada
read(15,*)str1,d1
read(15,fmt='(A)')nada
read(15,*)str2,d2
read(15,fmt='(A)')nada
read(15,*)str3,d3
read(15,fmt='(A)')nada
read(15,*)lat1,lat2,lon1,lon2
read(15,fmt='(A)')nada
read(15,*)depth
read(15,fmt='(A)')nada
read(15,*)sta,dipa,rakea
read(15,fmt='(A)')nada
read(15,*)fric,sk
read(15,fmt='(A)')nada
read(15,*)resolution
read(15,fmt='(A)')nada
read(15,fmt='(A)')m5yn
close(15)




read( datefin(1:4), '(i4)' )  year
read( datefin(5:6), '(i2)' )  month
read( datefin(7:8), '(i2)' )  day
read( datefin(9:10), '(i2)' )  hour
read( datefin(11:12), '(i2)' )  min
read( datefin(13:14), '(f4.0)' )  sec
call datenumer (day,month,year,hour,min,sec,datfin)



!moment_tensor_file='Canterbury_moment_tensor.csv'


mmin=5

open(unit=11,file=moment_tensor_file)
read(11,fmt='(A)')h1

npuntos=0
do K=1,nmax
    read(11,*,IOSTAT=IOstatus)eventID1,date1,x(1),x(2),x(3),x(4),x(5),x(6),x(7),x(8),x(9),x(10),kk,x(11),kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk,kk 
    
    
    if (IOstatus==0) then
            read( date1(1:4), '(i4)' )  year
            read( date1(5:6), '(i2)' )  month
            read( date1(7:8), '(i2)' )  day
            read( date1(9:10), '(i2)' )  hour
            read( date1(11:12), '(i2)' )  min
            read( date1(13:14), '(f4.0)' )  sec
            call datenumer (day,month,year,hour,min,sec,dat)

        !We only save the ones that have a magnitude Mw higher than 5
        if ((x(10) .GE. mmin) .and. (dat .LT. datfin)) then
        
            npuntos=npuntos+1
            eventID(npuntos)=eventID1
            date(npuntos)=date1
            lat(npuntos)=x(1)
            lon(npuntos)=x(2)
            st1(npuntos)=x(3)
            dip1(npuntos)=x(4)
            rake1(npuntos)=x(5)
            st2(npuntos)=x(6)
            dip2(npuntos)=x(7)
            rake2(npuntos)=x(8)
            ml(npuntos)=x(9)
            mw(npuntos)=x(10)
            prof(npuntos)=x(11)
            datestr=date(npuntos)
            !we choose right lateral
            if (abs((abs(rake1(npuntos))-180)) .GE. (abs(abs(rake2(npuntos))-180))) then
                st(npuntos)=st2(npuntos)
                dip(npuntos)=dip2(npuntos)
                rake(npuntos)=rake2(npuntos)
            else
                st(npuntos)=st1(npuntos)
                dip(npuntos)=dip1(npuntos)
                rake(npuntos)=rake1(npuntos)
 
            endif
            
            read( datestr(1:4), '(i4)' )  year
            read( datestr(5:6), '(i2)' )  month
            read( datestr(7:8), '(i2)' )  day
            read( datestr(9:10), '(i2)' )  hour
            read( datestr(11:12), '(i2)' )  min
            read( datestr(13:14), '(f4.0)' )  sec
            call datenumer (day,month,year,hour,min,sec,daten(npuntos))
            
        endif
    else

        exit
    endif

    
enddo
close(11)



call escribe_slip(eventID,mw,st,dip,rake,lat,lon,prof,filen,npuntos,SlipModelsFile,m5yn,pathToPrograms)
call escribe(sta,dipa,rakea,lat1,lat2,lon1,lon2,depth,resolution,filen,filename,gridfile,lam,mu,yn1,s1,s2,s3,str1,d1,str2,d2,str3,d3,fric,sk)
programa=trim(pathToPrograms)//'./farfalle_3.exe'
write(*,*)programa
call system(programa)
!Escribimos output para STEP
!write(*,*)pathToPrograms//'stress_tot_'//filen
open(unit=11,file='stress_tot_'//filen)
read(11,fmt='(A)',IOSTAT=IOstatus)h1
open(unit=15,file=fileoutSTEP)
do while (IOstatus .EQ. 0) 
    read(11,*,IOSTAT=IOstatus)x(1),x(2),x(3),x(4),x(5),x(6),x(7),x(8),x(9),x(10),x(11),x(12),x(13),x(14),x(15),x(16)
    if (yn1=='y') then
        if (x(7) .GT. 0) then
            write(15,*)x(1),x(2),1
        else
            write(15,*)x(1),x(2),0
        endif
    else
        if ((abs(sta-x(8))) .LE. (abs(sta-x(14)))) then
            if (x(7) .GT. 0) then
                write(15,*)x(1),x(2),1
            else
                write(15,*)x(1),x(2),0
            endif

        else
            if (x(13) .GT. 0) then
                write(15,*)x(1),x(2),1
            else
                write(15,*)x(1),x(2),0
            endif

        endif
    endif
enddo
close(15)
close(11)
END

subroutine datenumer (d,mo,y,hh,min,sec,daten1)
integer ::datenum,hh,min
real :: daten1,sec
integer, intent(in) :: d, mo, y
integer, dimension(14) :: daypermonth


daypermonth(1) = 0
daypermonth(2) = daypermonth(1)+31
daypermonth(3) = daypermonth(2)+28
daypermonth(4) = daypermonth(3)+31
daypermonth(5) = daypermonth(4)+30
daypermonth(6) = daypermonth(5)+31
daypermonth(7) = daypermonth(6)+30
daypermonth(8) = daypermonth(7)+31
daypermonth(9) = daypermonth(8)+31
daypermonth(10) = daypermonth(9)+30
daypermonth(11) = daypermonth(10)+31
daypermonth(12) = daypermonth(11)+30

datenum=int(y*365 &
+ ceiling(y/4.)-ceiling(y/100.)+ceiling(y/400.) &
+ daypermonth(mo) &
+ d)

if( ((mo .GT. 2) .and. ((mod(y,4).eq.0).and.(mod(y,100).ne.0).or.(mod(y,400).eq.0))) ) then
datenum = datenum + 1
endif

daten1=real (datenum)+ real(hh)/24+ real(min)/(24*60)+real(sec)/(24*3600)
return
end
