"""
Module CatalogPreProcessingTest
"""

__version__ = "$Revision$"
__revision__ = "$Id$"


import os, unittest, shutil, filecmp, datetime

import CSEPGeneric, Environment
from CSEPTestCase import CSEPTestCase
from RELMCatalog import RELMCatalog
from CatalogDataSource import CatalogDataSource
from GeoNetNZDataSource import GeoNetNZDataSource
from CSEPLogging import CSEPLogging


 #--------------------------------------------------------------------
 #
 # Test pre-processing of the catalog data.
 #
class CatalogPreProcessingTest (CSEPTestCase):
    
    # Reference data directory
    __referenceDataDir = os.path.join(Environment.Environment.Variable[Environment.CENTER_CODE_ENV],
                                      'src',
                                      'SCECModels',
                                      'NewZealand',
                                      'test',
                                      'data',
                                      'preProcess')

    # Flag if raw catalog data should be downloaded
    __downloadRawData = False


    #----------------------------------------------------------------------------
    #
    # Test pre-processing of raw GeoNet NZ catalog data and evaluate generated filtered 
    # catalog.
    #
    def test(self):
        """ Test pre-processing of GeoNet NZ catalog data and succeed. \
(the result catalog is in so-called ZMAP-format)."""
   
        # Setup test name
        CSEPTestCase.setTestName(self, "GeoNetNZPreProcessing")
   
        # Don't invoke any kind of post-processing for the catalog data.
        # Instantiating of catalog object takes care of generating a test directory
        data_start_date = datetime.datetime(2006, 1, 1)
        input_args = "depthLower=35, magnitudeUpper=3.5"
        
        data_source = GeoNetNZDataSource(data_start_date, 
                                         CatalogPreProcessingTest.__downloadRawData,
                                         args = input_args)
        data_source.RawFile = os.path.join(CSEPTestCase.TestDirPath,
                                           CatalogDataSource._RawFile)
        
        catalog = RELMCatalog(CSEPTestCase.TestDirPath,
                              data_source)
                
        # Copy reference raw data file to the test directory
        shutil.copyfile(os.path.join(CatalogPreProcessingTest.__referenceDataDir, 
                                     CatalogDataSource._RawFile),
                        os.path.join(CSEPTestCase.TestDirPath, 
                                     CatalogDataSource._RawFile))
   
        catalog.create(CSEPTestCase.Date)
        
        test_file = os.path.join(CSEPTestCase.TestDirPath, 
                                 CatalogDataSource.PreProcessedFile)
        
        result_file = os.path.join(CatalogPreProcessingTest.__referenceDataDir,
                                   CatalogDataSource.PreProcessedFile)
        
        CSEPLogging.getLogger(CatalogPreProcessingTest.__name__).info(
           "Comparing reference catalog file %s to generated GeoNet NZ catalog file %s..." \
           %(result_file, test_file))

        self.failIf(filecmp.cmp(result_file, test_file) == False, 
                    'Catalog pre-processing failed.')


# Invoke the module
if __name__ == '__main__':

   # Invoke all tests - must have testXXX method in the class defined
   unittest.main()
   
# end of main
