/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.XYZ_DataSetAPI;
import org.opensha.commons.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbDiscretizedXYZ_DataSet
implements XYZ_DataSetAPI,
Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<Double> xValues;
    ArrayList<Double> yValues;
    ArrayList<Double> zValues;

    public ArbDiscretizedXYZ_DataSet() {
        this.xValues = new ArrayList();
        this.yValues = new ArrayList();
        this.zValues = new ArrayList();
    }

    public ArbDiscretizedXYZ_DataSet(ArrayList<Double> xVals, ArrayList<Double> yVals, ArrayList<Double> zVals) {
        this.xValues = xVals;
        this.yValues = yVals;
        this.zValues = zVals;
    }

    @Override
    public void setXYZ_DataSet(ArrayList<Double> xVals, ArrayList<Double> yVals, ArrayList<Double> zVals) {
        this.xValues = xVals;
        this.yValues = yVals;
        this.zValues = zVals;
    }

    @Override
    public ArrayList<Double> getX_DataSet() {
        return this.xValues;
    }

    @Override
    public ArrayList<Double> getY_DataSet() {
        return this.yValues;
    }

    @Override
    public ArrayList<Double> getZ_DataSet() {
        return this.zValues;
    }

    @Override
    public double getMinX() {
        return this.getMin(this.xValues);
    }

    @Override
    public double getMaxX() {
        return this.getMax(this.xValues);
    }

    @Override
    public double getMinY() {
        return this.getMin(this.yValues);
    }

    @Override
    public double getMaxY() {
        return this.getMax(this.yValues);
    }

    @Override
    public double getMinZ() {
        return this.getMin(this.zValues);
    }

    @Override
    public double getMaxZ() {
        return this.getMax(this.zValues);
    }

    @Override
    public boolean checkXYZ_NumVals() {
        return this.xValues.size() == this.yValues.size() && this.xValues.size() == this.zValues.size();
    }

    private double getMin(ArrayList xyz) {
        int size = xyz.size();
        double min = Double.POSITIVE_INFINITY;
        for (int i = 1; i < size; ++i) {
            double val = (Double)xyz.get(i);
            if (Double.isNaN(val) || !(val < min)) continue;
            min = val;
        }
        return min;
    }

    private double getMax(ArrayList xyz) {
        int size = xyz.size();
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 1; i < size; ++i) {
            double val = (Double)xyz.get(i);
            if (Double.isNaN(val) || !(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static void writeXYZFile(XYZ_DataSetAPI xyz, String fileName) throws IOException {
        if (!xyz.checkXYZ_NumVals()) {
            throw new RuntimeException("Bad XYZ dataset!");
        }
        ArrayList<Double> xData = xyz.getX_DataSet();
        ArrayList<Double> yData = xyz.getY_DataSet();
        ArrayList<Double> zData = xyz.getZ_DataSet();
        int size = xData.size();
        FileWriter fw = new FileWriter(fileName);
        for (int i = 0; i < size; ++i) {
            fw.write(xData.get(i) + "\t" + yData.get(i) + "\t" + zData.get(i) + "\n");
        }
        fw.close();
    }

    public static ArbDiscretizedXYZ_DataSet loadXYZFile(String fileName) throws FileNotFoundException, IOException {
        ArrayList<String> lines = FileUtils.loadFile(fileName);
        ArbDiscretizedXYZ_DataSet xyz = new ArbDiscretizedXYZ_DataSet();
        for (String line : lines) {
            StringTokenizer tok;
            if (line.startsWith("#") || line.length() < 2 || (tok = new StringTokenizer(line)).countTokens() != 3) continue;
            double x = Double.parseDouble(tok.nextToken());
            double y = Double.parseDouble(tok.nextToken());
            double z = Double.parseDouble(tok.nextToken());
            xyz.addValue(x, y, z);
        }
        return xyz;
    }

    @Override
    public void addValue(double xVal, double yVal, double zVal) {
        this.xValues.add(xVal);
        this.yValues.add(yVal);
        this.zValues.add(zVal);
    }
}

