/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    protected Comparator comparator = null;
    protected transient Entry root = null;
    protected transient int size = 0;
    protected transient int modCount = 0;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;
    protected static final int KEYS = 0;
    protected static final int VALUES = 1;
    protected static final int ENTRIES = 2;
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected static final long serialVersionUID = 919286545866124006L;

    public TreeMap() {
    }

    public TreeMap(Comparator c) {
        this.comparator = c;
    }

    public TreeMap(Map m) {
        this.putAll(m);
    }

    public TreeMap(SortedMap m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    public Object get(Object key) {
        Entry p = this.getEntry(key);
        return p == null ? null : p.value;
    }

    protected Entry getEntry(Object key) {
        Entry p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp == 0) {
                return p;
            }
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            p = p.right;
        }
        return null;
    }

    protected Entry getCeilEntry(Object key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) == 0) {
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right == null) break;
            p = p.right;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.right) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    protected Entry getPrecedingEntry(Object key) {
        Entry p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left == null) break;
            p = p.left;
        }
        Entry parent = p.parent;
        Entry ch = p;
        while (parent != null && ch == parent.left) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    protected void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    protected void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.root == null ? false : (value == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, value));
    }

    protected boolean valueSearchNull(Entry n) {
        if (n.value == null) {
            return true;
        }
        return n.left != null && this.valueSearchNull(n.left) || n.right != null && this.valueSearchNull(n.right);
    }

    protected boolean valueSearchNonNull(Entry n, Object value) {
        if (value.equals(n.value)) {
            return true;
        }
        return n.left != null && this.valueSearchNonNull(n.left, value) || n.right != null && this.valueSearchNonNull(n.right, value);
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        return TreeMap.key(this.firstEntry());
    }

    public Object lastKey() {
        return TreeMap.key(this.lastEntry());
    }

    public void putAll(Map map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && ((Object)c).equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException cannotHappen) {
            }
            catch (ClassNotFoundException cannotHappen) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    protected static Object key(Entry e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    public Object put(Object key, Object value) {
        Entry t = this.root;
        if (t == null) {
            this.incrementSize();
            this.root = new Entry(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = new Entry(key, value, t);
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = new Entry(key, value, t);
        this.fixAfterInsertion(t.right);
        return null;
    }

    public Object remove(Object key) {
        Entry p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public Object clone() {
        TreeMap clone = null;
        try {
            clone = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        clone.keySet = null;
        clone.values = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public java.util.Iterator iterator() {
                    return new Iterator(0);
                }

                public int size() {
                    return TreeMap.this.size();
                }

                public boolean contains(Object o) {
                    return TreeMap.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    int oldSize = TreeMap.this.size;
                    TreeMap.this.remove(o);
                    return TreeMap.this.size != oldSize;
                }

                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public java.util.Iterator iterator() {
                    return new Iterator(1);
                }

                public int size() {
                    return TreeMap.this.size();
                }

                public boolean contains(Object o) {
                    Entry e = TreeMap.this.firstEntry();
                    while (e != null) {
                        if (TreeMap.valEquals(e.getValue(), o)) {
                            return true;
                        }
                        e = TreeMap.this.successor(e);
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    Entry e = TreeMap.this.firstEntry();
                    while (e != null) {
                        if (TreeMap.valEquals(e.getValue(), o)) {
                            TreeMap.this.deleteEntry(e);
                            return true;
                        }
                        e = TreeMap.this.successor(e);
                    }
                    return false;
                }

                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public java.util.Iterator iterator() {
                    return new Iterator(2);
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = TreeMap.this.getEntry(entry.getKey());
                    return p != null && TreeMap.valEquals(p.getValue(), value);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = TreeMap.this.getEntry(entry.getKey());
                    if (p != null && TreeMap.valEquals(p.getValue(), value)) {
                        TreeMap.this.deleteEntry(p);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return TreeMap.this.size();
                }

                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return new SubMap(fromKey, toKey);
    }

    public SortedMap headMap(Object toKey) {
        return new SubMap(toKey, true);
    }

    public SortedMap tailMap(Object fromKey) {
        return new SubMap(fromKey, false);
    }

    protected int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    protected static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected Entry firstEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    protected Entry lastEntry() {
        Entry p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    protected Entry successor(Entry t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    protected static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    protected static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    protected static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    protected static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    protected void rotateLeft(Entry p) {
        Entry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    protected void rotateRight(Entry p) {
        Entry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    protected void fixAfterInsertion(Entry x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (TreeMap.parentOf(x) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)))) {
                y = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(x)));
                if (!TreeMap.colorOf(y)) {
                    TreeMap.setColor(TreeMap.parentOf(x), true);
                    TreeMap.setColor(y, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                    x = TreeMap.parentOf(TreeMap.parentOf(x));
                    continue;
                }
                if (x == TreeMap.rightOf(TreeMap.parentOf(x))) {
                    x = TreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                if (TreeMap.parentOf(TreeMap.parentOf(x)) == null) continue;
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(x)));
                continue;
            }
            y = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)));
            if (!TreeMap.colorOf(y)) {
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(y, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                x = TreeMap.parentOf(TreeMap.parentOf(x));
                continue;
            }
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                x = TreeMap.parentOf(x);
                this.rotateRight(x);
            }
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
            if (TreeMap.parentOf(TreeMap.parentOf(x)) == null) continue;
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    protected void deleteEntry(Entry p) {
        Entry replacement;
        this.decrementSize();
        if (p.left != null && p.right != null) {
            Entry s = this.successor(p);
            this.swapPosition(s, p);
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    protected void fixAfterDeletion(Entry x) {
        while (x != this.root && TreeMap.colorOf(x)) {
            Entry sib;
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                sib = TreeMap.rightOf(TreeMap.parentOf(x));
                if (!TreeMap.colorOf(sib)) {
                    TreeMap.setColor(sib, true);
                    TreeMap.setColor(TreeMap.parentOf(x), false);
                    this.rotateLeft(TreeMap.parentOf(x));
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(sib)) && TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(sib, false);
                    x = TreeMap.parentOf(x);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(TreeMap.leftOf(sib), true);
                    TreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                this.rotateLeft(TreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = TreeMap.leftOf(TreeMap.parentOf(x));
            if (!TreeMap.colorOf(sib)) {
                TreeMap.setColor(sib, true);
                TreeMap.setColor(TreeMap.parentOf(x), false);
                this.rotateRight(TreeMap.parentOf(x));
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(sib)) && TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(sib, false);
                x = TreeMap.parentOf(x);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                TreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.leftOf(sib), true);
            this.rotateRight(TreeMap.parentOf(x));
            x = this.root;
        }
        TreeMap.setColor(x, true);
    }

    protected void swapPosition(Entry x, Entry y) {
        boolean yWasLeftChild;
        Entry px = x.parent;
        Entry lx = x.left;
        Entry rx = x.right;
        Entry py = y.parent;
        Entry ly = y.left;
        Entry ry = y.right;
        boolean xWasLeftChild = px != null && x == px.left;
        boolean bl = yWasLeftChild = py != null && y == py.left;
        if (x == py) {
            x.parent = y;
            if (yWasLeftChild) {
                y.left = x;
                y.right = rx;
            } else {
                y.right = x;
                y.left = lx;
            }
        } else {
            x.parent = py;
            if (py != null) {
                if (yWasLeftChild) {
                    py.left = x;
                } else {
                    py.right = x;
                }
            }
            y.left = lx;
            y.right = rx;
        }
        if (y == px) {
            y.parent = x;
            if (xWasLeftChild) {
                x.left = y;
                x.right = ry;
            } else {
                x.right = y;
                x.left = ly;
            }
        } else {
            y.parent = px;
            if (px != null) {
                if (xWasLeftChild) {
                    px.left = y;
                } else {
                    px.right = y;
                }
            }
            x.left = ly;
            x.right = ry;
        }
        if (x.left != null) {
            x.left.parent = x;
        }
        if (x.right != null) {
            x.right.parent = x;
        }
        if (y.left != null) {
            y.left.parent = y;
        }
        if (y.right != null) {
            y.right.parent = y;
        }
        boolean c = x.color;
        x.color = y.color;
        y.color = c;
        if (this.root == x) {
            this.root = y;
        } else if (this.root == y) {
            this.root = x;
        }
    }

    protected void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Entry e : this.entrySet()) {
            s.writeObject(e.key);
            s.writeObject(e.value);
        }
    }

    protected void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, Object defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet set, Object defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void buildFromSorted(int size, java.util.Iterator it, ObjectInputStream str, Object defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = TreeMap.buildFromSorted(0, 0, size - 1, TreeMap.computeRedLevel(size), it, str, defaultVal);
    }

    protected static Entry buildFromSorted(int level, int lo, int hi, int redLevel, java.util.Iterator it, ObjectInputStream str, Object defaultVal) throws IOException, ClassNotFoundException {
        Object value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry left = null;
        if (lo < mid) {
            left = TreeMap.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry middle = new Entry(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry right;
            middle.right = right = TreeMap.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            right.parent = middle;
        }
        return middle;
    }

    protected static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;
        Entry left = null;
        Entry right = null;
        Entry parent;
        boolean color = true;

        Entry(Object key, Object value, Entry parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return TreeMap.valEquals(this.key, e.getKey()) && TreeMap.valEquals(this.value, e.getValue());
        }

        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    protected class Iterator
    implements java.util.Iterator {
        protected int type;
        protected int expectedModCount;
        protected Entry lastReturned;
        protected Entry next;
        protected Entry firstExcluded;

        Iterator(int type) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.firstExcluded = null;
            this.type = type;
            this.next = TreeMap.this.firstEntry();
        }

        Iterator(Entry first, Entry firstExcluded) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.firstExcluded = null;
            this.type = 2;
            this.next = first;
            this.firstExcluded = firstExcluded;
        }

        public boolean hasNext() {
            return this.next != this.firstExcluded;
        }

        public Object next() {
            if (this.next == this.firstExcluded) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeMap.this.successor(this.next);
            return this.type == 0 ? this.lastReturned.key : (this.type == 1 ? this.lastReturned.value : this.lastReturned);
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    protected class SubMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        protected static final long serialVersionUID = -6520786458950516097L;
        protected boolean fromStart = false;
        protected boolean toEnd = false;
        protected Object fromKey;
        protected Object toKey;
        protected transient Set entrySet = new EntrySetView();

        SubMap(Object fromKey, Object toKey) {
            if (TreeMap.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(Object key, boolean headMap) {
            TreeMap.this.compare(key, key);
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, Object fromKey, boolean toEnd, Object toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public Object get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return TreeMap.this.get(key);
        }

        public boolean containsKey(Object key) {
            return this.inRange(key) && TreeMap.this.containsKey(key);
        }

        public Object put(Object key, Object value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return TreeMap.this.put(key, value);
        }

        public Comparator comparator() {
            return TreeMap.this.comparator;
        }

        public Object firstKey() {
            Object first = TreeMap.key(this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(this.fromKey));
            if (!this.toEnd && TreeMap.this.compare(first, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return first;
        }

        public Object lastKey() {
            Object last = TreeMap.key(this.toEnd ? TreeMap.this.lastEntry() : TreeMap.this.getPrecedingEntry(this.toKey));
            if (!this.fromStart && TreeMap.this.compare(last, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return last;
        }

        public Set entrySet() {
            return this.entrySet;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(fromKey, toKey);
        }

        public SortedMap headMap(Object toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, toKey);
        }

        public SortedMap tailMap(Object fromKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, fromKey, this.toEnd, this.toKey);
        }

        protected boolean inRange(Object key) {
            return !(!this.fromStart && TreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(key, this.toKey) >= 0);
        }

        protected boolean inRange2(Object key) {
            return !(!this.fromStart && TreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(key, this.toKey) > 0);
        }

        protected class EntrySetView
        extends AbstractSet {
            protected transient int size = -1;
            protected transient int sizeModCount;

            protected EntrySetView() {
            }

            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public int size() {
                if (this.size == -1 || this.sizeModCount != TreeMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = TreeMap.this.modCount;
                    java.util.Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = TreeMap.this.getEntry(key);
                return node != null && TreeMap.valEquals(node.getValue(), entry.getValue());
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = TreeMap.this.getEntry(key);
                if (node != null && TreeMap.valEquals(node.getValue(), entry.getValue())) {
                    TreeMap.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            public java.util.Iterator iterator() {
                return new Iterator(SubMap.this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : TreeMap.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }
}

