/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.region;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.util.MathUtils;
import org.dom4j.Element;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.region.BorderType;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.sha.earthquake.EqkRupture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region
implements Serializable,
XMLSaveable,
NamedObjectAPI {
    private static final long serialVersionUID = 1L;
    private LocationList border;
    private ArrayList<LocationList> interiors;
    private Area area;
    private static final double WEDGE_WIDTH = 10.0;
    private static final double GC_SEGMENT = 100.0;
    public static final String XML_METADATA_NAME = "Region";
    public static final String XML_METADATA_OUTLINE_NAME = "OutlineLocations";
    private String name = "Unnamed Region";

    private Region() {
    }

    public Region(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null) {
            throw new NullPointerException();
        }
        double lat1 = loc1.getLatitude();
        double lat2 = loc2.getLatitude();
        double lon1 = loc1.getLongitude();
        double lon2 = loc2.getLongitude();
        if (lat1 == lat2 || lon1 == lon2) {
            throw new IllegalArgumentException("Input lats or lons cannot be the same");
        }
        LocationList ll = new LocationList();
        double minLat = Math.min(lat1, lat2);
        double minLon = Math.min(lon1, lon2);
        double maxLat = Math.max(lat1, lat2);
        double maxLon = Math.max(lon1, lon2);
        double offset = 1.0E-5;
        double d = maxLat <= 90.0 - offset ? offset : 0.0;
        double d2 = maxLon <= 180.0 - offset ? offset : 0.0;
        ll.addLocation(new Location(minLat, minLon));
        ll.addLocation(new Location(minLat, maxLon += d2));
        ll.addLocation(new Location(maxLat += d, maxLon));
        ll.addLocation(new Location(maxLat, minLon));
        this.initBorderedRegion(ll, BorderType.MERCATOR_LINEAR);
    }

    public Region(LocationList border, BorderType type) {
        if (border == null) {
            throw new NullPointerException();
        }
        if (border.size() < 3) {
            throw new IllegalArgumentException("Border must have at least 3 vertices");
        }
        if (type == null) {
            type = BorderType.MERCATOR_LINEAR;
        }
        this.initBorderedRegion(border, type);
    }

    public Region(Location center, double radius) {
        if (radius <= 0.0 || radius > 1000.0) {
            throw new IllegalArgumentException("Radius is out of [0 1000] km range");
        }
        if (center == null) {
            throw new NullPointerException();
        }
        this.initCircularRegion(center, radius);
    }

    public Region(LocationList line, double buffer) {
        if (buffer <= 0.0 || buffer > 500.0) {
            throw new IllegalArgumentException("Buffer is out of [0 500] km range");
        }
        if (line == null) {
            throw new NullPointerException();
        }
        if (line.size() == 0) {
            throw new IllegalArgumentException("LocationList argument is empty");
        }
        this.initBufferedRegion(line, buffer);
    }

    public Region(Region region) {
        if (region == null) {
            throw new NullPointerException("Supplied Region is null");
        }
        this.name = region.name;
        this.border = region.border.copyImmutable();
        this.area = (Area)region.area.clone();
        if (region.interiors != null) {
            this.interiors = new ArrayList();
            for (LocationList interior : region.interiors) {
                this.interiors.add(interior.copyImmutable());
            }
        }
    }

    public Region(EqkRupture rupture, double buffer) throws Exception {
        throw new Exception("Unimplemented constructor -- build me");
    }

    boolean contains(double lat, double lon) {
        return this.area.contains(lon, lat);
    }

    public boolean contains(Location loc) {
        return this.contains(loc.getLatitude(), loc.getLongitude());
    }

    public boolean contains(Region region) {
        Area areaUnion = (Area)this.area.clone();
        areaUnion.add(region.area);
        return this.area.equals(areaUnion);
    }

    public boolean isRectangular() {
        return this.area.isRectangular();
    }

    public void addInterior(Region region) {
        Region.validateRegion(region);
        if (!this.contains(region)) {
            throw new IllegalArgumentException("Region must completely contain supplied interior Region");
        }
        if (this.interiors == null) {
            this.interiors = new ArrayList();
        }
        LocationList newInterior = region.border.copy();
        Area newArea = Region.createArea(newInterior);
        for (LocationList interior : this.interiors) {
            Area existing = Region.createArea(interior);
            existing.intersect(newArea);
            if (existing.isEmpty()) continue;
            throw new IllegalArgumentException("Supplied interior Region overlaps existing interiors");
        }
        this.interiors.add(newInterior);
        this.area.subtract(region.area);
    }

    public List<LocationList> getInteriors() {
        return this.interiors != null ? Collections.unmodifiableList(this.interiors) : null;
    }

    public LocationList getBorder() {
        return this.border;
    }

    public boolean equals(Region r) {
        return this.area.equals(r.area);
    }

    public double getMinLat() {
        double val = this.area.getBounds2D().getMinY();
        return MathUtils.round(val, 5);
    }

    public double getMaxLat() {
        double val = this.area.getBounds2D().getMaxY();
        return MathUtils.round(val, 5);
    }

    public double getMinLon() {
        double val = this.area.getBounds2D().getMinX();
        return MathUtils.round(val, 5);
    }

    public double getMaxLon() {
        double val = this.area.getBounds2D().getMaxX();
        return MathUtils.round(val, 5);
    }

    public double distanceToLocation(Location loc) {
        if (this.contains(loc)) {
            return 0.0;
        }
        double min = this.border.getMinHorzDistToLine(loc);
        double temp = RelativeLocation.getApproxHorzDistToLine(this.border.getLocationAt(this.border.size() - 1), this.border.getLocationAt(0), loc);
        return temp < min ? temp : min;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml = this.border.toXMLMetadata(xml);
        return root;
    }

    public static Region fromXMLMetadata(Element e) {
        LocationList list = LocationList.fromXMLMetadata(e.element("LocationList"));
        return new Region(list, BorderType.MERCATOR_LINEAR);
    }

    public String toString() {
        String str = "Region\n\tMinimum Lat: " + this.getMinLat() + "\n" + "\tMinimum Lon: " + this.getMinLon() + "\n" + "\tMaximum Lat: " + this.getMaxLat() + "\n" + "\tMaximum Lon: " + this.getMaxLon();
        return str;
    }

    public static Region getGlobalRegion() {
        LocationList gll = new LocationList();
        gll.addLocation(new Location(-90.0, -180.0));
        gll.addLocation(new Location(-90.0, 180.0));
        gll.addLocation(new Location(90.0, 180.0));
        gll.addLocation(new Location(90.0, -180.0));
        return new Region(gll, BorderType.MERCATOR_LINEAR);
    }

    public static Region intersect(Region r1, Region r2) {
        Region.validateRegion(r1);
        Region.validateRegion(r2);
        Area newArea = (Area)r1.area.clone();
        newArea.intersect(r2.area);
        if (newArea.isEmpty()) {
            return null;
        }
        Region newRegion = new Region();
        newRegion.area = newArea;
        newRegion.border = Region.createBorder(newArea, true);
        return newRegion;
    }

    public static Region union(Region r1, Region r2) {
        Region.validateRegion(r1);
        Region.validateRegion(r2);
        Area newArea = (Area)r1.area.clone();
        newArea.add(r2.area);
        if (!newArea.isSingular()) {
            return null;
        }
        Region newRegion = new Region();
        newRegion.area = newArea;
        newRegion.border = Region.createBorder(newArea, true);
        return newRegion;
    }

    private static void validateRegion(Region r) {
        if (r == null) {
            throw new NullPointerException("Supplied Region is null");
        }
        if (!r.area.isSingular()) {
            throw new IllegalArgumentException("Region must be singular");
        }
    }

    private static Area createArea(LocationList border) {
        GeneralPath path = new GeneralPath(0, border.size());
        boolean starting = true;
        for (Location loc : border) {
            float lat = (float)loc.getLatitude();
            float lon = (float)loc.getLongitude();
            if (starting) {
                path.moveTo(lon, lat);
                starting = false;
                continue;
            }
            path.lineTo(lon, lat);
        }
        path.closePath();
        Area area = new Area(path);
        if (area.isEmpty()) {
            throw new IllegalArgumentException("Area is empty");
        }
        if (!area.isSingular()) {
            throw new IllegalArgumentException("Area is not a single closed path");
        }
        LocationList ll = Region.createBorder(area, false);
        return area;
    }

    private void initBorderedRegion(LocationList border, BorderType type) {
        int lastIndex = border.size() - 1;
        if (border.getLocationAt(lastIndex).equalsLocation(border.getLocationAt(0))) {
            border.remove(lastIndex);
        }
        if (type.equals((Object)BorderType.GREAT_CIRCLE)) {
            LocationList gcBorder = new LocationList();
            Location start = border.getLocationAt(border.size() - 1);
            for (int i = 0; i < border.size(); ++i) {
                gcBorder.addLocation(start);
                Location end = border.getLocationAt(i);
                double distance = RelativeLocation.surfaceDistance(start, end);
                while (distance > 100.0) {
                    double azRad = RelativeLocation.azimuthRad(start, end);
                    Location segLoc = RelativeLocation.location(start, azRad, 100.0);
                    gcBorder.addLocation(segLoc);
                    start = segLoc;
                    distance = RelativeLocation.surfaceDistance(start, end);
                }
                start = end;
            }
            this.border = gcBorder.copyImmutable();
        } else {
            this.border = border.copyImmutable();
        }
        this.area = Region.createArea(this.border);
    }

    private void initCircularRegion(Location center, double radius) {
        this.border = Region.createLocationCircle(center, radius);
        this.area = Region.createArea(this.border);
    }

    private void initBufferedRegion(LocationList line, double buffer) {
        this.area = new Area();
        Location prevLoc = null;
        for (Location loc : line) {
            if (this.area.isEmpty()) {
                this.area.add(Region.createArea(Region.createLocationCircle(loc, buffer)));
                prevLoc = loc;
                continue;
            }
            this.area.add(Region.createArea(Region.createLocationBox(prevLoc, loc, buffer)));
            this.area.add(Region.createArea(Region.createLocationCircle(loc, buffer)));
            prevLoc = loc;
        }
        this.border = Region.createBorder(this.area, true);
    }

    private static LocationList createBorder(Area area, boolean clean) {
        PathIterator pi = area.getPathIterator(null);
        LocationList ll = new LocationList();
        double[] vertex = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(vertex);
            double lon = MathUtils.round(vertex[0], 5);
            double lat = MathUtils.round(vertex[1], 5);
            if (type != 4) {
                ll.addLocation(Location.immutableLocation(lat, lon));
            }
            pi.next();
        }
        if (clean) {
            LocationList llClean = new LocationList();
            Location prev = ll.getLocationAt(ll.size() - 1);
            for (Location loc : ll) {
                if (loc.equals(prev)) continue;
                llClean.addLocation(loc);
                prev = loc;
            }
            ll = llClean;
        }
        return ll;
    }

    private static LocationList createLocationCircle(Location center, double radius) {
        LocationList ll = new LocationList();
        for (double angle = 0.0; angle < 360.0; angle += 10.0) {
            ll.addLocation(Location.immutableLocation(RelativeLocation.location(center, angle * RelativeLocation.TO_RAD, radius)));
        }
        return ll;
    }

    private static LocationList createLocationBox(Location p1, Location p2, double distance) {
        double az12 = RelativeLocation.azimuthRad(p1, p2);
        double az21 = RelativeLocation.azimuthRad(p2, p1);
        LocationList ll = new LocationList();
        ll.addLocation(RelativeLocation.location(p1, az12 - 1.5707963267948966, distance));
        ll.addLocation(RelativeLocation.location(p1, az12 + 1.5707963267948966, distance));
        ll.addLocation(RelativeLocation.location(p2, az21 - 1.5707963267948966, distance));
        ll.addLocation(RelativeLocation.location(p2, az21 + 1.5707963267948966, distance));
        return ll;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeObject(this.name);
        os.writeObject(this.border);
        os.writeObject(this.interiors);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.name = (String)is.readObject();
        this.border = (LocationList)is.readObject();
        this.interiors = (ArrayList)is.readObject();
        this.area = Region.createArea(this.border);
        if (this.interiors != null) {
            for (LocationList interior : this.interiors) {
                Area intArea = Region.createArea(interior);
                this.area.subtract(intArea);
            }
        }
    }

    public static void main(String[] args) {
        Line2D.Double line = new Line2D.Double(new Point(1, 1), new Point(2, 1));
        Polygon poly = new Polygon(new int[]{1, 4, 3, 2}, new int[]{1, 1, 1, 1}, 4);
        Area testArea = new Area(poly);
        System.out.println(testArea.isEmpty());
    }
}

