/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.siteData.CachedSiteDataWrapper;
import org.opensha.commons.data.siteData.SiteDataAPI;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.SiteDataValueList;
import org.opensha.commons.data.siteData.impl.CVM2BasinDepth;
import org.opensha.commons.data.siteData.impl.CVM4BasinDepth;
import org.opensha.commons.data.siteData.impl.USGSBayAreaBasinDepth;
import org.opensha.commons.data.siteData.impl.WaldAllenGlobalVs30;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.data.siteData.impl.WillsMap2006;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.ParameterListEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSiteData<Element>
implements SiteDataAPI<Element> {
    protected ParameterList paramList = new ParameterList();
    protected ParameterListEditor paramEdit = null;
    public static final String PARAM_MIN_BASIN_DEPTH_DOUBLE_NAME = "Minimum Basin Depth";
    public static final Double PARAM_MIN_BASIN_DEPTH_DOUBLE_MIN = 0.0;
    public static final Double PARAM_MIN_BASIN_DEPTH_DOUBLE_MAX = 100000.0;
    public static final Double PARAM_MIN_BASIN_DEPTH_DOUBLE_DEFAULT = PARAM_MIN_BASIN_DEPTH_DOUBLE_MIN;
    public static final String PARAM_MIN_BASIN_INFO = "This can be used to constrain the minimum basin depth value returned by the basin depth provider. If the provider gives a value that is less than this minimum value,the minimum value will be used.";
    protected DoubleParameter minBasinDoubleParam = null;
    public static final String PARAM_MAX_BASIN_DEPTH_DOUBLE_NAME = "Maximum Basin Depth";
    public static final Double PARAM_MAX_BASIN_DEPTH_DOUBLE_MIN = 0.0;
    public static final Double PARAM_MAX_BASIN_DEPTH_DOUBLE_MAX;
    public static final Double PARAM_MAX_BASIN_DEPTH_DOUBLE_DEFAULT;
    public static final String PARAM_MAX_BASIN_INFO = "This can be used to constrain the maximum basin depth value returned by the basin depth provider. If the provider gives a value that is greater than this maximum value,the maximum value will be used.";
    protected DoubleParameter maxBasinDoubleParam = null;
    public static final String PARAM_MIN_VS30_NAME = "Minimum Vs30";
    public static final Double PARAM_MIN_VS30_MIN;
    public static final Double PARAM_MIN_VS30_MAX;
    public static final Double PARAM_MIN_VS30_DEFAULT;
    public static final String PARAM_MIN_VS30_INFO = "This can be used to constrain the minimum Vs30 value returned by the Vs30 provider. If the provider gives a value that is less than this minimum value,the minimum value will be used.";
    protected DoubleParameter minVs30Param = null;
    public static final String PARAM_MAX_VS30_NAME = "Maximum Vs30";
    public static final Double PARAM_MAX_VS30_MIN;
    public static final Double PARAM_MAX_VS30_MAX;
    public static final Double PARAM_MAX_VS30_DEFAULT;
    public static final String PARAM_MAX_VS30_INFO = "This can be used to constrain the maximum Vs30 value returned by the Vs30 provider. If the provider gives a value that is greater than this maximum value,the maximum value will be used.";
    protected DoubleParameter maxVs30Param = null;

    @Override
    public SiteDataValue<Element> getAnnotatedValue(Location loc) throws IOException {
        Object val = this.getValue(loc);
        return new SiteDataValue(this.getDataType(), this.getDataMeasurementType(), val, this.getName());
    }

    @Override
    public SiteDataValueList<Element> getAnnotatedValues(LocationList locs) throws IOException {
        ArrayList<Element> vals = this.getValues(locs);
        return new SiteDataValueList<Element>(this.getDataType(), this.getDataMeasurementType(), vals, this.getName());
    }

    @Override
    public ArrayList<Element> getValues(LocationList locs) throws IOException {
        ArrayList vals = new ArrayList();
        for (Location loc : locs) {
            vals.add(this.getValue(loc));
        }
        return vals;
    }

    @Override
    public boolean hasDataForLocation(Location loc, boolean checkValid) {
        if (this.getApplicableRegion().contains(loc)) {
            if (checkValid) {
                try {
                    Object val = this.getValue(loc);
                    return this.isValueValid(val);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.paramList;
    }

    protected void initParamListEditor() {
        this.paramEdit = new ParameterListEditor(this.paramList);
        if (this.paramList.size() == 0) {
            this.paramEdit.setTitle("No Adjustable Parameters");
        } else {
            this.paramEdit.setTitle("Adjustable Parameters");
        }
    }

    @Override
    public ParameterListEditor getParameterListEditor() {
        if (this.paramEdit == null) {
            this.initParamListEditor();
        } else {
            this.paramEdit.refreshParamEditor();
        }
        return this.paramEdit;
    }

    protected void initDefaultBasinParams() {
        this.minBasinDoubleParam = new DoubleParameter(PARAM_MIN_BASIN_DEPTH_DOUBLE_NAME, PARAM_MIN_BASIN_DEPTH_DOUBLE_MIN, PARAM_MIN_BASIN_DEPTH_DOUBLE_MAX, PARAM_MIN_BASIN_DEPTH_DOUBLE_DEFAULT);
        this.minBasinDoubleParam.setInfo(PARAM_MIN_BASIN_INFO);
        this.maxBasinDoubleParam = new DoubleParameter(PARAM_MAX_BASIN_DEPTH_DOUBLE_NAME, PARAM_MAX_BASIN_DEPTH_DOUBLE_MIN, PARAM_MAX_BASIN_DEPTH_DOUBLE_MAX, PARAM_MAX_BASIN_DEPTH_DOUBLE_DEFAULT);
        this.maxBasinDoubleParam.setInfo(PARAM_MAX_BASIN_INFO);
    }

    protected void initDefaultVS30Params() {
        this.minVs30Param = new DoubleParameter(PARAM_MIN_VS30_NAME, PARAM_MIN_VS30_MIN, PARAM_MIN_VS30_MAX, PARAM_MIN_VS30_DEFAULT);
        this.minVs30Param.setInfo(PARAM_MIN_VS30_INFO);
        this.maxVs30Param = new DoubleParameter(PARAM_MAX_VS30_NAME, PARAM_MAX_VS30_MIN, PARAM_MAX_VS30_MAX, PARAM_MAX_VS30_DEFAULT);
        this.maxVs30Param.setInfo(PARAM_MAX_VS30_INFO);
    }

    private Double getDoubleInMinMaxRange(Double val, Double min, Double max) {
        if (val.isNaN()) {
            return val;
        }
        if (min != null && val < min) {
            return min;
        }
        if (max != null && val > max) {
            return max;
        }
        return val;
    }

    protected Double certifyMinMaxBasinDepth(Double val) {
        Double min = (Double)this.minBasinDoubleParam.getValue();
        Double max = (Double)this.maxBasinDoubleParam.getValue();
        return this.getDoubleInMinMaxRange(val, min, max);
    }

    protected Double certifyMinMaxVs30(Double val) {
        Double min = (Double)this.minVs30Param.getValue();
        Double max = (Double)this.maxVs30Param.getValue();
        return this.getDoubleInMinMaxRange(val, min, max);
    }

    protected Element addXMLParameters(Element paramsEl) {
        return paramsEl;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        return this.toXMLMetadata(root, -1);
    }

    public Element toXMLMetadata(Element root, int cacheSize) {
        Element el = root.addElement("SiteDataAPI");
        el.addAttribute("Name", this.getName());
        el.addAttribute("Ref_ClassName", this.getClass().getName());
        el.addAttribute("CacheSize", cacheSize + "");
        Element paramsEl = el.addElement("DataParameters");
        this.addXMLParameters(paramsEl);
        Iterator<ParameterAPI<?>> paramIt = this.paramList.iterator();
        Element paramsElement = el.addElement("Parameters");
        while (paramIt.hasNext()) {
            ParameterAPI<?> param = paramIt.next();
            paramsElement = param.toXMLMetadata(paramsElement);
        }
        return root;
    }

    public static SiteDataAPI<?> fromXMLMetadata(Element dataElem) throws IOException {
        AbstractSiteData provider;
        String name = dataElem.attributeValue("Name");
        int cacheSize = Integer.parseInt(dataElem.attributeValue("CacheSize"));
        Element paramsEl = dataElem.element("DataParameters");
        if (name.equals("SCEC Community Velocity Model Version 2 Basin Depth")) {
            provider = CVM2BasinDepth.fromXMLParams(paramsEl);
        } else if (name.equals("SCEC Community Velocity Model Version 4 Basin Depth")) {
            provider = CVM4BasinDepth.fromXMLParams(paramsEl);
        } else if (name.equals("CGS/Wills Preliminary Site Classification Map (2000)")) {
            provider = WillsMap2000.fromXMLParams(paramsEl);
        } else if (name.equals("CGS/Wills Site Classification Map (2006)")) {
            provider = WillsMap2006.fromXMLParams(paramsEl);
        } else if (name.equals("USGS Bay Area Velocity Model Release 8.3.0")) {
            provider = USGSBayAreaBasinDepth.fromXMLParams(paramsEl);
        } else if (name.equals("Global Vs30 from Topographic Slope (Wald & Allen 2008)")) {
            provider = WaldAllenGlobalVs30.fromXMLParams(paramsEl);
        } else {
            throw new RuntimeException("Cannot load Site Data Provider '" + name + "' from XML!");
        }
        Element paramsElement = dataElem.element("Parameters");
        for (ParameterAPI<?> param : provider.getAdjustableParameterList()) {
            Iterator it = paramsElement.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (!param.getName().equals(el.attribute("name").getValue()) || param.setValueFromXMLMetadata(el)) continue;
                System.out.println("Parameter could not be set from XML!");
                System.out.println("It is possible that the parameter type doesn't yet support loading from XML");
            }
        }
        if (cacheSize > 0) {
            return new CachedSiteDataWrapper(provider);
        }
        return provider;
    }

    static {
        PARAM_MAX_BASIN_DEPTH_DOUBLE_DEFAULT = PARAM_MAX_BASIN_DEPTH_DOUBLE_MAX = Double.valueOf(100000.0);
        PARAM_MIN_VS30_MIN = 0.0;
        PARAM_MIN_VS30_MAX = 100000.0;
        PARAM_MIN_VS30_DEFAULT = PARAM_MIN_VS30_MIN;
        PARAM_MAX_VS30_MIN = 0.0;
        PARAM_MAX_VS30_DEFAULT = PARAM_MAX_VS30_MAX = Double.valueOf(5000.0);
    }
}

