/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.BorderType;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.siteData.SiteDataAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteDataToXYZ {
    public static void writeXYZ(SiteDataAPI<?> data, GriddedRegion region, String fileName) throws IOException {
        SiteDataToXYZ.writeXYZ(data, region, fileName, true);
    }

    public static void writeXYZ(SiteDataAPI<?> data, double gridSpacing, String fileName) throws IOException {
        GriddedRegion region = new GriddedRegion(data.getApplicableRegion().getBorder(), BorderType.MERCATOR_LINEAR, gridSpacing, new Location(0.0, 0.0));
        SiteDataToXYZ.writeXYZ(data, region, fileName, true);
    }

    public static void writeXYZ(SiteDataAPI<?> data, GriddedRegion region, String fileName, boolean latFirst) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        LocationList locs = region.getNodeList();
        ArrayList<?> vals = data.getValues(locs);
        for (int i = 0; i < locs.size(); ++i) {
            Location loc = locs.getLocationAt(i);
            String str = latFirst ? loc.getLatitude() + "\t" + loc.getLongitude() + "\t" : loc.getLongitude() + "\t" + loc.getLatitude() + "\t";
            str = str + vals.get(i).toString();
            fw.write(str + "\n");
        }
        fw.close();
    }
}

