/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.CachedSiteDataWrapper;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVM4BasinDepth
extends AbstractSiteData<Double> {
    public static final String NAME = "SCEC Community Velocity Model Version 4 Basin Depth";
    public static final String SHORT_NAME = "CVM4";
    public static final double minLat = 31.0;
    public static final double minLon = -121.0;
    private static final int nx = 1701;
    private static final int ny = 1101;
    private static final long MAX_FILE_POS = 7480000L;
    public static final double gridSpacing = 0.005;
    public static final String DEPTH_2_5_FILE = "data/siteData/CVM4/depth_2.5.bin";
    public static final String DEPTH_1_0_FILE = "data/siteData/CVM4/depth_1.0.bin";
    public static final String SERVLET_2_5_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/CVM4_2_5";
    public static final String SERVLET_1_0_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/CVM4_1_0";
    private RandomAccessFile file = null;
    private String fileName = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private boolean useServlet;
    private String type;
    private SiteDataServletAccessor<Double> servlet = null;

    public CVM4BasinDepth(String type) throws IOException {
        this(type, null, true);
    }

    public CVM4BasinDepth(String type, boolean useServlet) throws IOException {
        this(type, null, useServlet);
    }

    public CVM4BasinDepth(String type, String dataFile) throws IOException {
        this(type, dataFile, false);
    }

    public CVM4BasinDepth(String type, String dataFile, boolean useServlet) throws IOException {
        this.useServlet = useServlet;
        this.fileName = dataFile;
        this.type = type;
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(3, 1701, 1101, 31.0, -121.0, 0.005);
        if (useServlet) {
            this.servlet = type.equals("Depth to Vs = 1.0 km/sec") ? new SiteDataServletAccessor(SERVLET_1_0_URL) : new SiteDataServletAccessor(SERVLET_2_5_URL);
        } else {
            if (dataFile == null) {
                dataFile = type.equals("Depth to Vs = 1.0 km/sec") ? DEPTH_1_0_FILE : DEPTH_2_5_FILE;
            }
            this.file = new RandomAccessFile(new File(dataFile), "r");
            this.calc.setStartBottom(true);
            this.calc.setStartLeft(true);
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.initDefaultBasinParams();
        this.paramList.addParameter(this.minBasinDoubleParam);
        this.paramList.addParameter(this.maxBasinDoubleParam);
    }

    @Override
    public Region getApplicableRegion() {
        return this.calc.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return this.type + ", extracted from version 4 of the SCEC Community Velocity Model with patches from" + "Geoff Ely and others. Extracted Feb 17, 2009 by Kevin Milner.\n\n" + "It has a grid spacing of " + 0.005 + " degrees";
    }

    @Override
    public double getResolution() {
        return 0.005;
    }

    @Override
    public String getDataType() {
        return this.type;
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.certifyMinMaxBasinDepth(this.servlet.getValue(loc));
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos > 7480000L || pos < 0L) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        Double dobVal = val / 1000.0;
        return this.certifyMinMaxBasinDepth(dobVal);
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            for (int i = 0; i < vals.size(); ++i) {
                vals.set(i, this.certifyMinMaxBasinDepth(vals.get(i)));
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", this.useServlet + "");
        paramsEl.addAttribute("fileName", this.fileName);
        paramsEl.addAttribute("type", this.type);
        return super.addXMLParameters(paramsEl);
    }

    public static CVM4BasinDepth fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        String type = paramsElem.attributeValue("type");
        return new CVM4BasinDepth(type, fileName, useServlet);
    }

    public static void main(String[] args) throws IOException {
        double val;
        CVM4BasinDepth map = new CVM4BasinDepth("Depth to Vs = 1.0 km/sec");
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        map.getAdjustableParameterList().getParameter("Minimum Basin Depth").setValue(new Double(1.0));
        Element mapEl = map.toXMLMetadata(root).element("SiteDataAPI");
        XMLUtils.writeDocumentToFile("/tmp/cvm4.xml", doc);
        map = (CVM4BasinDepth)AbstractSiteData.fromXMLMetadata(mapEl);
        System.out.println("Min: " + map.getAdjustableParameterList().getParameter("Minimum Basin Depth").getValue());
        CachedSiteDataWrapper<Double> cache = new CachedSiteDataWrapper<Double>(map);
        LocationList locs = new LocationList();
        locs.addLocation(new Location(34.0192, -118.288));
        locs.addLocation(new Location(34.9192, -118.32));
        locs.addLocation(new Location(34.78192, -118.886));
        locs.addLocation(new Location(34.2192, -118.386));
        locs.addLocation(new Location(34.78192, -118.886));
        locs.addLocation(new Location(34.2192, -118.386));
        locs.addLocation(new Location(34.78192, -118.886));
        locs.addLocation(new Location(34.2192, -118.386));
        locs.addLocation(new Location(34.792, -118.8));
        locs.addLocation(new Location(34.292, -118.386));
        locs.addLocation(new Location(34.6192, -118.186));
        locs.addLocation(new Location(34.792, -118.8));
        locs.addLocation(new Location(34.292, -118.386));
        locs.addLocation(new Location(34.792, -118.8));
        locs.addLocation(new Location(34.292, -118.386));
        locs.addLocation(new Location(34.792, -118.8));
        locs.addLocation(new Location(34.292, -118.386));
        map.getValues(locs);
        long time = System.currentTimeMillis();
        for (Location loc : locs) {
            double val2 = map.getValue(loc);
        }
        double secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Raw time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            val = cache.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Cache time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            val = map.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Raw time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            val = cache.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Cache time: " + secs + "s");
    }
}

