/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteDataToXYZ;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.sha.gui.servlets.siteEffect.WillsSiteClass;
import org.opensha.sha.util.SiteTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WillsMap2000
extends AbstractSiteData<String> {
    public static final String NAME = "CGS/Wills Preliminary Site Classification Map (2000)";
    public static final String SHORT_NAME = "Wills2000";
    public static final double minLat = 31.4;
    public static final double maxLat = 41.983;
    public static final double minLon = -124.45;
    public static final double maxLon = -114.0;
    public static final double spacing = 0.01667;
    private Region applicableRegion;
    private String fileName = "data/siteType/Wills2000/usgs_cgs_geology_60s_mod.txt";
    private boolean useServlet;
    public static final String SERVLET_URL = "http://opensha.usc.edu:8080/OpenSHA_dev/SiteData/Wills2000";
    SiteDataServletAccessor<String> servlet = null;

    public WillsMap2000() {
        this(true);
    }

    public WillsMap2000(String fileName) {
        this(false);
        this.fileName = fileName;
    }

    public WillsMap2000(boolean useServlet) {
        this.useServlet = useServlet;
        this.applicableRegion = new Region(new Location(31.4, -124.45), new Location(41.983, -114.0));
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor(SERVLET_URL);
            this.servlet.setMaxLocsPerRequest(10000);
        }
    }

    @Override
    public Region getApplicableRegion() {
        return this.applicableRegion;
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        if (this.useServlet) {
            return this.servlet.getClosestLocation(loc);
        }
        LocationList locs = new LocationList();
        locs.addLocation(loc);
        WillsSiteClass wills = new WillsSiteClass(locs, "data/siteType/Wills2000/usgs_cgs_geology_60s_mod.txt");
        wills.getWillsSiteClass();
        return wills.getLastLocation();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return 0.01667;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return "Wills site classifications as defined in:\n\nA Site-Conditions Map for California Based on Geology and Shear-Wave Velocity\nby C. J. Wills, M. Petersen, W. A. Bryant, M. Reichle, G. J. Saucedo, S. Tan, G. Taylor, and J. Treiman\nBulletin of the Seismological Society of America, 90, 6B, pp. S187\u00e2\u0080\u0093S208, December 2000\n\nNOTE: The gridded datafile used for this dataset had lat/lon values rounded to two decimal places resulting in an irregular mesh, therefore data results are not precise. It is recommended that you use the 2006 version of the map. It has a grid spacing of apporximately 0.01667 degrees";
    }

    @Override
    public String getDataType() {
        return "Wills Class";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public String getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValue(loc);
        }
        LocationList locs = new LocationList();
        locs.addLocation(loc);
        return this.getValues(locs).get(0);
    }

    @Override
    public ArrayList<String> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValues(locs);
        }
        WillsSiteClass wills = new WillsSiteClass(locs, this.fileName);
        return wills.getWillsSiteClass();
    }

    @Override
    public boolean isValueValid(String val) {
        Set<String> keys = SiteTranslator.wills_vs30_map.keySet();
        return keys.contains(val);
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", this.useServlet + "");
        paramsEl.addAttribute("fileName", this.fileName);
        return super.addXMLParameters(paramsEl);
    }

    public static WillsMap2000 fromXMLParams(Element paramsElem) {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        if (useServlet) {
            return new WillsMap2000(true);
        }
        return new WillsMap2000(fileName);
    }

    public static void main(String[] args) throws IOException {
        WillsMap2000 map = new WillsMap2000();
        SiteDataToXYZ.writeXYZ(map, 0.02, "/tmp/wills2000.txt");
    }
}

