/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.raster;

import com.lowagie.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.opensha.commons.mapping.gmt.raster.ASCII85InputStream;
import org.opensha.commons.util.FileUtils;

public class RasterExtractor {
    String psFileName;
    String outFileName;
    boolean doTrans = true;
    byte transR = 0;
    byte transG = 0;
    byte transB = 0;

    public RasterExtractor(String psFileName, String outFileName) {
        this.psFileName = psFileName;
        this.outFileName = outFileName;
    }

    public BufferedImage getRasterImage() throws FileNotFoundException, IOException {
        ArrayList<String> lines = FileUtils.loadFile(this.psFileName);
        boolean reading = false;
        boolean colorimage = false;
        boolean ascii85 = false;
        boolean lzwDecode = false;
        int width = 0;
        int height = 0;
        int pixels = 0;
        int expected = 0;
        byte[] bytes = null;
        int byteCount = 0;
        int curLine = 0;
        String asciiImage = "";
        for (String line : lines) {
            if (!reading) {
                if (line.contains("false 3 colorimage")) {
                    reading = true;
                    StringTokenizer tok = new StringTokenizer(line);
                    width = Integer.parseInt(tok.nextToken());
                    height = Integer.parseInt(tok.nextToken());
                    int depth = Integer.parseInt(tok.nextToken());
                    if (depth != 8) {
                        System.out.println("BAD DEPTH! EXITING!");
                        return null;
                    }
                    pixels = width * height;
                    expected = pixels * 3;
                    bytes = new byte[expected];
                    System.out.println("time to READ: false 3 colorimage " + width + "x" + height + " " + pixels + " px");
                    colorimage = true;
                    continue;
                }
                if (line.contains("ASCII85Decode")) {
                    lzwDecode = line.contains("LZWDecode");
                    int depth = 0;
                    for (int i = curLine - 2; i < curLine + 3; ++i) {
                        String parseLine = lines.get(i);
                        StringTokenizer parseTok = new StringTokenizer(parseLine);
                        while (parseTok.hasMoreTokens()) {
                            String token = parseTok.nextToken();
                            if (token.contains("/Width")) {
                                width = Integer.parseInt(parseTok.nextToken());
                                continue;
                            }
                            if (token.contains("/Height")) {
                                height = Integer.parseInt(parseTok.nextToken());
                                continue;
                            }
                            if (!token.contains("/BitsPerComponent")) continue;
                            depth = Integer.parseInt(parseTok.nextToken());
                        }
                        if (width > 0 && height > 0 && depth > 0) break;
                    }
                    System.out.println(width + " " + height + " " + depth);
                    if (width <= 0 || height <= 0 || depth != 8) {
                        return null;
                    }
                    pixels = width * height;
                    expected = pixels * 3;
                    bytes = new byte[expected];
                    System.out.println("time to READ! ASCII85Decode " + width + "x" + height + " " + pixels + " px");
                    reading = true;
                    ascii85 = true;
                    continue;
                }
            }
            if (reading && bytes != null) {
                if (ascii85) {
                    if (line.startsWith(">> image")) continue;
                    asciiImage = asciiImage + line + "\n";
                    if (line.contains("~>")) {
                        break;
                    }
                } else if (colorimage) {
                    if (line.startsWith("U")) break;
                    for (int i = 0; i < line.length(); i += 2) {
                        bytes[byteCount] = (byte)Integer.parseInt(line.substring(i, i + 2), 16);
                        ++byteCount;
                    }
                }
            }
            ++curLine;
        }
        System.out.println("Done reading...converting.");
        if (ascii85) {
            ByteArrayInputStream is = new ByteArrayInputStream(asciiImage.getBytes("UTF-8"));
            ASCII85InputStream ais = new ASCII85InputStream(is);
            while (!ais.isEndReached() && byteCount < expected) {
                int data = ais.read();
                bytes[byteCount] = (byte)data;
                ++byteCount;
            }
            if (lzwDecode) {
                bytes = PdfReader.LZWDecode(bytes);
            }
        }
        System.out.println("Read in " + byteCount + " bytes...expected: " + expected);
        return this.getBufferedImage(bytes, width, height);
    }

    public BufferedImage getBufferedImage(byte[] bytes, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        int i = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                byte b = bytes[i++];
                byte g = bytes[i++];
                byte r = bytes[i++];
                int a = -1;
                if (this.doTrans && r == this.transR && b == this.transB && g == this.transG) {
                    a = 0;
                }
                int argb = r & 0xFF | (g & 0xFF) << 8 | (b & 0xFF) << 16 | (a & 0xFF) << 24 | 0;
                image.setRGB(x, y, argb);
            }
        }
        return image;
    }

    public void writePNG() throws FileNotFoundException, IOException {
        ImageIO.write((RenderedImage)this.getRasterImage(), "png", new File(this.outFileName));
        System.out.println("DONE!");
    }

    public static void main(String[] args) {
        String psFileName = null;
        String pngFileName = null;
        if (args.length == 0) {
            System.err.println("WARNING: Running from debug mode with hardcoded paths!");
            psFileName = "/home/kevin/OpenSHA/basin/plots/temp/basin.ps";
            pngFileName = "/home/kevin/OpenSHA/basin/plots/temp/extract.png";
        } else if (args.length == 2) {
            psFileName = args[0];
            pngFileName = args[1];
        } else {
            System.err.println("USAGE: RasterExtractor ps_file_name png_file_name");
            System.exit(2);
        }
        RasterExtractor extract = new RasterExtractor(psFileName, pngFileName);
        try {
            extract.writePNG();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

