/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleDiscreteParameter;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.ParameterAPI;
import org.opensha.commons.param.ParameterConstraint;
import org.opensha.commons.param.WarningParameterAPI;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarningDoubleParameter
extends DoubleParameter
implements WarningParameterAPI<Double> {
    protected static final String C = "WarningDoubleParameter";
    protected static final boolean D = false;
    protected DoubleConstraint warningConstraint = null;
    protected transient ArrayList warningListeners = null;
    private boolean ignoreWarning;

    public WarningDoubleParameter(String name) {
        super(name);
    }

    public WarningDoubleParameter(String name, String units) {
        super(name, units);
    }

    public WarningDoubleParameter(String name, double min, double max) throws ConstraintException {
        super(name, min, max);
    }

    public WarningDoubleParameter(String name, double min, double max, String units) throws ConstraintException {
        super(name, min, max, units);
    }

    public WarningDoubleParameter(String name, Double min, Double max) throws ConstraintException {
        super(name, min, max);
    }

    public WarningDoubleParameter(String name, Double min, Double max, String units) throws ConstraintException {
        super(name, min, max, units);
    }

    public WarningDoubleParameter(String name, DoubleConstraint constraint) throws ConstraintException {
        super(name, constraint);
    }

    public WarningDoubleParameter(String name, DoubleConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units);
    }

    public WarningDoubleParameter(String name, Double value) {
        super(name, value);
    }

    public WarningDoubleParameter(String name, String units, Double value) throws ConstraintException {
        super(name, units, value);
    }

    public WarningDoubleParameter(String name, double min, double max, Double value) throws ConstraintException {
        super(name, min, max, value);
    }

    public WarningDoubleParameter(String name, DoubleConstraint constraint, Double value) throws ConstraintException {
        super(name, constraint, value);
    }

    public WarningDoubleParameter(String name, double min, double max, String units, Double value) throws ConstraintException {
        super(name, min, max, units, value);
    }

    public WarningDoubleParameter(String name, Double min, Double max, String units, Double value) throws ConstraintException {
        super(name, min, max, units, value);
    }

    public WarningDoubleParameter(String name, DoubleConstraint constraint, String units, Double value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public synchronized void addParameterChangeWarningListener(ParameterChangeWarningListener listener) throws EditableException {
        String S = "WarningDoubleParameter: addParameterChangeWarningListener(): ";
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList();
        }
        if (!this.warningListeners.contains(listener)) {
            this.warningListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeParameterChangeWarningListener(ParameterChangeWarningListener listener) throws EditableException {
        String S = "WarningDoubleParameter: removeParameterChangeWarningListener(): ";
        if (this.warningListeners != null && this.warningListeners.contains(listener)) {
            this.warningListeners.remove(listener);
        }
    }

    @Override
    public void setWarningConstraint(ParameterConstraint warningConstraint) throws ParameterException, EditableException {
        String S = "WarningDoubleParameter: setWarningConstraint(): ";
        this.checkEditable(S);
        this.warningConstraint = (DoubleConstraint)warningConstraint;
    }

    @Override
    public ParameterConstraint getWarningConstraint() throws ParameterException {
        return this.warningConstraint;
    }

    @Override
    public Double getWarningMin() throws Exception {
        if (this.warningConstraint != null) {
            return this.warningConstraint.getMin();
        }
        return null;
    }

    @Override
    public Double getWarningMax() {
        if (this.warningConstraint != null) {
            return this.warningConstraint.getMax();
        }
        return null;
    }

    @Override
    public synchronized void setValue(Double value) throws ConstraintException, WarningException {
        String S = this.getName() + ": setValue(): ";
        if (!this.isAllowed(value)) {
            String err = S + "Value is not allowed: ";
            if (value != null) {
                err = err + value.toString();
            }
            throw new ConstraintException(err);
        }
        if (value == null) {
            this.value = null;
            ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
            this.firePropertyChange(event);
        } else {
            if (!this.ignoreWarning && !this.isRecommended(value)) {
                ParameterChangeWarningEvent event = new ParameterChangeWarningEvent(this, this, this.value, value);
                this.fireParameterChangeWarning(event);
                throw new WarningException(S + "Value is not recommended: " + value.toString());
            }
            this.value = value;
            ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
            this.firePropertyChange(event);
        }
    }

    @Override
    public void setValueIgnoreWarning(Double value) throws ConstraintException, ParameterException {
        String S = "WarningDoubleParameter: setValueIgnoreWarning(): ";
        super.setValue(value);
    }

    @Override
    public boolean isRecommended(Double obj) {
        if (this.warningConstraint != null) {
            return this.warningConstraint.isAllowed(obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireParameterChangeWarning(ParameterChangeWarningEvent event) {
        ArrayList vector;
        String S = "WarningDoubleParameter: firePropertyChange(): ";
        WarningDoubleParameter warningDoubleParameter = this;
        synchronized (warningDoubleParameter) {
            if (this.warningListeners == null) {
                return;
            }
            vector = (ArrayList)this.warningListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParameterChangeWarningListener listener = (ParameterChangeWarningListener)vector.get(i);
            listener.parameterChangeWarning(event);
        }
    }

    @Override
    public int compareTo(Object obj) throws ClassCastException {
        String S = "WarningDoubleParameter:compareTo(): ";
        if (!(obj instanceof DoubleParameter || obj instanceof DoubleDiscreteParameter || obj instanceof WarningDoubleParameter)) {
            throw new ClassCastException(S + "Object not a DoubleParameter, WarningDoubleParameter, or DoubleDiscreteParameter, unable to compare");
        }
        boolean result = false;
        Double n1 = (Double)this.getValue();
        Double n2 = null;
        if (obj instanceof DoubleParameter) {
            DoubleParameter param = (DoubleParameter)obj;
            n2 = (Double)param.getValue();
        } else if (obj instanceof DoubleDiscreteParameter) {
            DoubleDiscreteParameter param = (DoubleDiscreteParameter)obj;
            n2 = (Double)param.getValue();
        } else if (obj instanceof WarningDoubleParameter) {
            WarningDoubleParameter param = (WarningDoubleParameter)obj;
            n2 = (Double)param.getValue();
        }
        if (n1 == null && n2 == null) {
            return 0;
        }
        return n1.compareTo(n2);
    }

    @Override
    public boolean equals(Object obj) throws ClassCastException {
        String S = "WarningDoubleParameter:equals(): ";
        if (!(obj instanceof DoubleParameter || obj instanceof DoubleDiscreteParameter || obj instanceof WarningDoubleParameter)) {
            throw new ClassCastException(S + "Object not a DoubleParameter, WarningDoubleParameter, or DoubleDiscreteParameter, unable to compare");
        }
        String otherName = ((DoubleParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    @Override
    public Object clone() {
        String S = "WarningDoubleParameter:clone(): ";
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        WarningDoubleParameter param = null;
        param = this.value == null ? new WarningDoubleParameter(this.name, c1, this.units) : new WarningDoubleParameter(this.name, c1, this.units, new Double(((Double)this.value).toString()));
        if (param == null) {
            return null;
        }
        param.setWarningConstraint(c2);
        ListIterator it = this.getIndependentParametersIterator();
        while (it.hasNext()) {
            ParameterAPI p1 = it.next();
            ParameterAPI p2 = (ParameterAPI)p1.clone();
            param.addIndependentParameter(p2);
        }
        if (this.warningListeners != null) {
            it = this.warningListeners.listIterator();
            while (it.hasNext()) {
                ParameterChangeWarningListener listener = (ParameterChangeWarningListener)((Object)it.next());
                param.addParameterChangeWarningListener(listener);
            }
        }
        param.setInfo(this.info);
        param.setIgnoreWarning(this.ignoreWarning);
        param.editable = true;
        return param;
    }

    @Override
    public void setIgnoreWarning(boolean ignoreWarning) {
        this.ignoreWarning = ignoreWarning;
    }

    @Override
    public boolean isIgnoreWarning() {
        return this.ignoreWarning;
    }
}

