/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtoNMap<Element1, Element2> {
    public HashMap<Element1, Collection<Element2>> oneToTwoMap = new HashMap();
    public HashMap<Element2, Collection<Element1>> twoToOneMap = new HashMap();
    private int size = 0;

    public void clear() {
        this.oneToTwoMap.clear();
        this.twoToOneMap.clear();
        this.size = 0;
    }

    public void put(Element1 elem1, Element2 elem2) {
        Collection<Element2> twos = this.oneToTwoMap.get(elem1);
        Collection<Element1> ones = this.twoToOneMap.get(elem2);
        if (ones == null) {
            ones = new ArrayList<Element1>();
            this.twoToOneMap.put(elem2, ones);
        }
        if (twos == null) {
            twos = new ArrayList<Element2>();
            this.oneToTwoMap.put(elem1, twos);
        }
        if (!ones.contains(elem1) && !twos.contains(elem2)) {
            ones.add(elem1);
            twos.add(elem2);
            ++this.size;
        }
    }

    public void putAll(NtoNMap<Element1, Element2> map) {
        for (Element1 one : map.getOnes()) {
            for (Element2 two : map.getTwos(one)) {
                this.put(one, two);
            }
        }
    }

    public Set<Element1> getOnes() {
        return this.oneToTwoMap.keySet();
    }

    public Collection<Element1> getOnes(Element2 two) {
        return this.twoToOneMap.get(two);
    }

    public Set<Element2> getTwos() {
        return this.twoToOneMap.keySet();
    }

    public Collection<Element2> getTwos(Element1 one) {
        return this.oneToTwoMap.get(one);
    }

    public boolean containsMapping(Element1 one, Element2 two) {
        Collection<Element1> ones = this.getOnes(two);
        if (ones == null) {
            return false;
        }
        for (Element1 oneTest : ones) {
            if (!oneTest.equals(one)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Element1 one, Element2 two) {
        Collection<Element1> ones = this.getOnes(two);
        Collection<Element2> twos = this.getTwos(one);
        if (ones != null && twos != null && ones.contains(one) && twos.contains(two)) {
            boolean success;
            boolean bl = success = ones.remove(one) && twos.remove(two);
            if (success) {
                --this.size;
                return true;
            }
        }
        return false;
    }
}

