/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.vo.Contributor;
import sun.misc.BASE64Encoder;

public class ContributorDB_DAO {
    private static final String SEQUENCE_NAME = "Contributors_Sequence";
    private static final String TABLE_NAME = "Contributors";
    private static final String CONTRIBUTOR_ID = "Contributor_Id";
    public static final String CONTRIBUTOR_NAME = "Contributor_Name";
    private static final String FIRST_NAME = "First_Name";
    private static final String LAST_NAME = "Last_Name";
    private static final String EMAIL = "Email";
    private static final String PASSWORD = "Password";
    private DB_AccessAPI dbAccessAPI;

    public ContributorDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public int addContributor(Contributor contributor, String password) throws InsertException {
        int contributorId = -1;
        try {
            contributorId = this.dbAccessAPI.getNextSequenceNumber(SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String passwordStr = this.getEnryptedPassword(password);
        String sql = "insert into Contributors(Contributor_Id,Contributor_Name,First_Name,Last_Name,Email,Password) values (" + contributorId + ",'" + contributor.getName() + "','" + contributor.getFirstName() + "','" + contributor.getLastName() + "','" + contributor.getEmail() + "','" + passwordStr + "')";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        return contributorId;
    }

    private String getEnryptedPassword(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            return new BASE64Encoder().encode(md.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean updatePassword(String userName, String oldPassword, String newPassword) throws UpdateException {
        String sql = "update Contributors set Password= '" + this.getEnryptedPassword(newPassword) + "' where " + CONTRIBUTOR_NAME + "='" + userName + "' and " + PASSWORD + "='" + this.getEnryptedPassword(oldPassword) + "'";
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public String resetPasswordByEmail(String email) throws UpdateException {
        String randomPass = this.getRandomPassword();
        String sql = "update Contributors set Password= '" + this.getEnryptedPassword(randomPass) + "' where " + EMAIL + "='" + email + "'";
        try {
            int numRows = this.dbAccessAPI.resetPasswordByEmail(sql);
            if (numRows == 1) {
                return randomPass;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return null;
    }

    private int rand(int lo, int hi, Random rn) {
        int n = hi - lo + 1;
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    private String getRandomPassword() {
        Random rn = new Random();
        int n = this.rand(8, 12, rn);
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)this.rand(97, 122, rn);
        }
        return new String(b, 0);
    }

    public Contributor getContributor(int contributorId) throws QueryException {
        Contributor contributor = null;
        String condition = " where Contributor_Id=" + contributorId;
        ArrayList contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            contributor = (Contributor)contributorList.get(0);
        }
        return contributor;
    }

    public Contributor getContributor(String name) throws QueryException {
        Contributor contributor = null;
        String condition = " where " + CONTRIBUTOR_NAME + "='" + name + "'";
        ArrayList contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            contributor = (Contributor)contributorList.get(0);
        }
        return contributor;
    }

    public Contributor getContributorByEmail(String emailAdd) throws QueryException {
        Contributor contributor = null;
        String condition = " where " + EMAIL + "='" + emailAdd + "'";
        ArrayList contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            contributor = (Contributor)contributorList.get(0);
        }
        return contributor;
    }

    public Contributor isContributorValid(String name, String password) {
        Object contributor = null;
        String condition = " where " + CONTRIBUTOR_NAME + "='" + name + "' and " + PASSWORD + "='" + this.getEnryptedPassword(password) + "'";
        ArrayList contributorList = this.query(condition);
        if (contributorList.size() > 0) {
            return (Contributor)contributorList.get(0);
        }
        return null;
    }

    public boolean removeContributor(int contributorId) throws UpdateException {
        String sql = "delete from Contributors  where Contributor_Id=" + contributorId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public ArrayList getAllContributors() throws QueryException {
        return this.query(" ");
    }

    private ArrayList query(String condition) throws QueryException {
        ArrayList<Contributor> contributorList = new ArrayList<Contributor>();
        String sql = "select Contributor_Id,Contributor_Name from Contributors " + condition;
        try {
            CachedRowSetImpl rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                contributorList.add(new Contributor(rs.getInt(CONTRIBUTOR_ID), rs.getString(CONTRIBUTOR_NAME)));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return contributorList;
    }
}

