/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;

public class DB_ConnectionPool
implements Runnable,
DB_AccessAPI {
    private Thread runner;
    private Connection[] connPool;
    private int[] connStatus;
    private long[] connLockTime;
    private long[] connCreateDate;
    private String[] connID;
    private String dbDriver;
    private String dbServer;
    private String dbLogin;
    private String dbPassword;
    private String logFileString;
    private int currConnections;
    private int connLast;
    private int minConns;
    private int maxConns;
    private int maxConnMSec;
    private int maxCheckoutSeconds;
    private int debugLevel;
    private boolean available = true;
    private PrintWriter log;
    private SQLWarning currSQLWarning;
    private String pid;
    private final int DEFAULTMAXCHECKOUTSECONDS = 60;
    private final int DEFAULTDEBUGLEVEL = 1;

    public DB_ConnectionPool() {
        Properties p = new Properties();
        try {
            InputStream inpStream = this.getClass().getResourceAsStream("/org/opensha/refFaultParamDb/dao/db/DB_AccessProp.dat");
            p.load(inpStream);
            inpStream.close();
            String dbDriver = (String)p.get("dbDriver");
            String dbServer = (String)p.get("dbServer");
            String dbLogin = (String)p.get("userName");
            String dbPassword = (String)p.get("password");
            int minConns = Integer.parseInt((String)p.get("minConns"));
            int maxConns = Integer.parseInt((String)p.get("maxConns"));
            String logFileString = (String)p.get("logFileString");
            double maxConnTime = new Double((String)p.get("maxConnTime"));
            p.clear();
            this.setupBroker(dbDriver, dbServer, dbLogin, dbPassword, minConns, maxConns, logFileString, maxConnTime, false, 60, 1);
        }
        catch (FileNotFoundException f) {
            f.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DB_ConnectionPool(String dbDriver, String dbServer, String dbLogin, String dbPassword, int minConns, int maxConns, String logFileString, double maxConnTime) throws IOException {
        this.setupBroker(dbDriver, dbServer, dbLogin, dbPassword, minConns, maxConns, logFileString, maxConnTime, false, 60, 1);
    }

    public DB_ConnectionPool(String dbDriver, String dbServer, String dbLogin, String dbPassword, int minConns, int maxConns, String logFileString, double maxConnTime, boolean logAppend) throws IOException {
        this.setupBroker(dbDriver, dbServer, dbLogin, dbPassword, minConns, maxConns, logFileString, maxConnTime, logAppend, 60, 1);
    }

    public DB_ConnectionPool(String dbDriver, String dbServer, String dbLogin, String dbPassword, int minConns, int maxConns, String logFileString, double maxConnTime, boolean logAppend, int maxCheckoutSeconds, int debugLevel) throws IOException {
        this.setupBroker(dbDriver, dbServer, dbLogin, dbPassword, minConns, maxConns, logFileString, maxConnTime, logAppend, maxCheckoutSeconds, debugLevel);
    }

    private void setupBroker(String dbDriver, String dbServer, String dbLogin, String dbPassword, int minConns, int maxConns, String logFileString, double maxConnTime, boolean logAppend, int maxCheckoutSeconds, int debugLevel) throws IOException {
        this.connPool = new Connection[maxConns];
        this.connStatus = new int[maxConns];
        this.connLockTime = new long[maxConns];
        this.connCreateDate = new long[maxConns];
        this.connID = new String[maxConns];
        this.currConnections = minConns;
        this.maxConns = maxConns;
        this.dbDriver = dbDriver;
        this.dbServer = dbServer;
        this.dbLogin = dbLogin;
        this.dbPassword = dbPassword;
        this.logFileString = logFileString;
        this.maxCheckoutSeconds = maxCheckoutSeconds;
        this.debugLevel = debugLevel;
        this.maxConnMSec = (int)(maxConnTime * 8.64E7);
        if (this.maxConnMSec < 30000) {
            this.maxConnMSec = 30000;
        }
        try {
            this.log = new PrintWriter(new FileOutputStream(logFileString, logAppend), true);
        }
        catch (IOException e1) {
            try {
                this.log = new PrintWriter(new FileOutputStream("DCB_" + System.currentTimeMillis() + ".log", logAppend), true);
            }
            catch (IOException e2) {
                throw new IOException("Can't open any log file");
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
        Date nowc = new Date();
        this.pid = formatter.format(nowc);
        boolean connectionsSucceeded = false;
        int dbLoop = 2;
        try {
            for (int i = 1; i < dbLoop; ++i) {
                try {
                    for (int j = 0; j < this.currConnections; ++j) {
                        this.createConn(j);
                    }
                    connectionsSucceeded = true;
                    break;
                }
                catch (SQLException e) {
                    if (debugLevel <= 0) continue;
                    this.log.println("--->Attempt (" + String.valueOf(i) + " of " + String.valueOf(dbLoop) + ") failed to create new connections set at startup: ");
                    this.log.println("    " + e);
                    continue;
                }
            }
            if (!connectionsSucceeded) {
                if (debugLevel > 0) {
                    this.log.println("\r\nAll attempts at connecting to Database exhausted");
                }
                throw new IOException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException();
        }
        this.runner = new Thread(this);
        this.runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        boolean forever = true;
        Statement stmt = null;
        Object currCatalog = null;
        long maxCheckoutMillis = this.maxCheckoutSeconds * 1000;
        while (forever) {
            int i;
            block42: {
                try {
                    BufferedReader in = new BufferedReader(new FileReader(this.logFileString + "pid"));
                    String curr_pid = in.readLine();
                    if (curr_pid.equals(this.pid)) {
                        in.close();
                        break block42;
                    }
                    this.log.close();
                    int i2 = 0;
                    while (i2 < this.currConnections) {
                        try {
                            this.connPool[i2].close();
                        }
                        catch (SQLException e1) {
                            // empty catch block
                        }
                        ++i2;
                    }
                    return;
                }
                catch (IOException e1) {
                    this.log.println("Can't read the file for pid info: " + this.logFileString + "pid");
                }
            }
            for (i = 0; i < this.currConnections; ++i) {
                try {
                    this.currSQLWarning = this.connPool[i].getWarnings();
                    if (this.currSQLWarning == null) continue;
                    if (this.debugLevel > 1) {
                        this.log.println("Warnings on connection " + String.valueOf(i) + " " + this.currSQLWarning);
                    }
                    this.connPool[i].clearWarnings();
                    continue;
                }
                catch (SQLException e) {
                    if (this.debugLevel <= 1) continue;
                    this.log.println("Cannot access Warnings: " + e);
                }
            }
            for (i = 0; i < this.currConnections; ++i) {
                long age = System.currentTimeMillis() - this.connCreateDate[i];
                try {
                    int[] e1 = this.connStatus;
                    // MONITORENTER : this.connStatus
                    if (this.connStatus[i] > 0) {
                        long timeInUse = System.currentTimeMillis() - this.connLockTime[i];
                        if (this.debugLevel > 2) {
                            this.log.println("Warning.  Connection " + i + " in use for " + timeInUse + " ms");
                        }
                        if (maxCheckoutMillis != 0L && timeInUse > maxCheckoutMillis) {
                            if (this.debugLevel <= 1) throw new SQLException();
                            this.log.println("Warning. Connection " + i + " failed to be returned in time.  Recycling...");
                            throw new SQLException();
                        }
                        // MONITOREXIT : e1
                        continue;
                    }
                    this.connStatus[i] = 2;
                    // MONITOREXIT : e1
                    if (age > (long)this.maxConnMSec) {
                        throw new SQLException();
                    }
                    stmt = this.connPool[i].createStatement();
                    this.connStatus[i] = 0;
                    if (!this.connPool[i].isClosed()) continue;
                    throw new SQLException();
                }
                catch (SQLException e) {
                    block43: {
                        if (this.debugLevel > 1) {
                            this.log.println(new Date().toString() + " ***** Recycling connection " + String.valueOf(i) + ":");
                        }
                        try {
                            this.connPool[i].close();
                        }
                        catch (SQLException e0) {
                            if (this.debugLevel <= 0) break block43;
                            this.log.println("Error!  Can't close connection!  Might have been closed already.  Trying to recycle anyway... (" + e0 + ")");
                        }
                    }
                    try {
                        this.createConn(i);
                    }
                    catch (SQLException e1) {
                        if (this.debugLevel > 0) {
                            this.log.println("Failed to create connection: " + e1);
                        }
                        this.connStatus[i] = 0;
                    }
                    continue;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e1) {}
                }
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Connection getConnection() {
        Connection conn = null;
        if (!this.available) {
            if (this.debugLevel > 0) {
                this.log.println("Unsuccessful getConnection() request during destroy()");
            }
        } else {
            boolean gotOne = false;
            for (int outerloop = 1; outerloop <= 10; ++outerloop) {
                block20: {
                    try {
                        int loop = 0;
                        int roundRobin = this.connLast + 1;
                        if (roundRobin >= this.currConnections) {
                            roundRobin = 0;
                        }
                        do {
                            int[] nArray = this.connStatus;
                            // MONITORENTER : this.connStatus
                            if (this.connStatus[roundRobin] < 1 && !this.connPool[roundRobin].isClosed()) {
                                conn = this.connPool[roundRobin];
                                this.connStatus[roundRobin] = 1;
                                this.connLockTime[roundRobin] = System.currentTimeMillis();
                                this.connLast = roundRobin;
                                gotOne = true;
                                // MONITOREXIT : nArray
                                break;
                            }
                            ++loop;
                            if (++roundRobin >= this.currConnections) {
                                roundRobin = 0;
                            }
                            // MONITOREXIT : nArray
                        } while (!gotOne && loop < this.currConnections);
                    }
                    catch (SQLException e1) {
                        this.log.println("Error: " + e1);
                    }
                    if (gotOne) break;
                    DB_ConnectionPool e1 = this;
                    // MONITORENTER : e1
                    if (this.currConnections < this.maxConns) {
                        try {
                            this.createConn(this.currConnections);
                            ++this.currConnections;
                        }
                        catch (SQLException e) {
                            if (this.debugLevel <= 0) break block20;
                            this.log.println("Error: Unable to create new connection: " + e);
                        }
                    }
                }
                // MONITOREXIT : e1
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.debugLevel <= 0) continue;
                this.log.println("-----> Connections Exhausted!  Will wait and try again in loop " + String.valueOf(outerloop));
            }
        }
        if (this.debugLevel <= 2) return conn;
        this.log.println("Handing out connection " + this.idOfConnection(conn) + " --> " + new SimpleDateFormat("MM/dd/yyyy  hh:mm:ss a").format(new Date()));
        return conn;
    }

    public int idOfConnection(Connection conn) {
        String tag;
        try {
            tag = conn.toString();
        }
        catch (NullPointerException e1) {
            tag = "none";
        }
        int match = -1;
        for (int i = 0; i < this.currConnections; ++i) {
            if (!this.connID[i].equals(tag)) continue;
            match = i;
            break;
        }
        return match;
    }

    public String freeConnection(Connection conn) {
        String res = "";
        int thisconn = this.idOfConnection(conn);
        if (thisconn >= 0) {
            this.connStatus[thisconn] = 0;
            res = "freed " + conn.toString();
        } else if (this.debugLevel > 0) {
            this.log.println("----> Error: Could not free connection!!!");
        }
        return res;
    }

    public long getAge(Connection conn) {
        int thisconn = this.idOfConnection(conn);
        return System.currentTimeMillis() - this.connLockTime[thisconn];
    }

    private void createConn(int i) throws SQLException {
        Date now;
        block2: {
            now = new Date();
            try {
                Class.forName(this.dbDriver);
                this.connPool[i] = DriverManager.getConnection(this.dbServer, this.dbLogin, this.dbPassword);
                this.connStatus[i] = 0;
                this.connID[i] = this.connPool[i].toString();
                this.connLockTime[i] = 0L;
                this.connCreateDate[i] = now.getTime();
            }
            catch (ClassNotFoundException e2) {
                if (this.debugLevel <= 0) break block2;
                this.log.println("Error creating connection: " + e2);
            }
        }
        this.log.println(now.toString() + "  Opening connection " + String.valueOf(i) + " " + this.connPool[i].toString() + ":");
    }

    public void destroy(int millis) throws SQLException {
        int useCount;
        this.available = false;
        this.runner.interrupt();
        try {
            this.runner.join(millis);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long startTime = System.currentTimeMillis();
        while ((useCount = this.getUseCount()) > 0 && System.currentTimeMillis() - startTime <= (long)millis) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        for (int i = 0; i < this.currConnections; ++i) {
            try {
                this.connPool[i].close();
                continue;
            }
            catch (SQLException e1) {
                if (this.debugLevel <= 0) continue;
                this.log.println("Cannot close connections on Destroy");
            }
        }
        if (useCount > 0) {
            String msg = "Unsafe shutdown: Had to close " + useCount + " active DB connections after " + millis + "ms";
            this.log.println(msg);
            this.log.close();
            throw new SQLException(msg);
        }
        this.log.close();
    }

    public void destroy() {
        try {
            this.destroy(10000);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUseCount() {
        int useCount = 0;
        int[] nArray = this.connStatus;
        synchronized (this.connStatus) {
            for (int i = 0; i < this.currConnections; ++i) {
                if (this.connStatus[i] <= 0) continue;
                ++useCount;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return useCount;
        }
    }

    public int getSize() {
        return this.currConnections;
    }

    public int resetPasswordByEmail(String sql) throws SQLException {
        return this.insertUpdateOrDeleteData(sql);
    }

    public int insertUpdateOrDeleteData(String sql) throws SQLException {
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        int rows = stat.executeUpdate(sql);
        stat.close();
        this.freeConnection(conn);
        return rows;
    }

    public String getSystemDate() throws SQLException {
        String sql = "select to_char(sysdate) from dual";
        CachedRowSetImpl result = this.queryData(sql);
        result.next();
        return result.getString(1);
    }

    public int getNextSequenceNumber(String sequenceName) throws SQLException {
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        ResultSet result = stat.executeQuery("select " + sequenceName + ".nextval  from dual");
        result.next();
        int key = result.getInt(1);
        result.close();
        stat.close();
        this.freeConnection(conn);
        return key;
    }

    public CachedRowSetImpl queryData(String sql) throws SQLException {
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        ResultSet result = stat.executeQuery(sql);
        CachedRowSetImpl crs = new CachedRowSetImpl();
        crs.populate(result);
        result.close();
        stat.close();
        this.freeConnection(conn);
        return crs;
    }

    public SpatialQueryResult queryData(String sqlWithSpatialColumnNames, String sqlWithNoSpatialColumnNames, ArrayList spatialColumnNames) throws SQLException {
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        ResultSet result = stat.executeQuery(sqlWithSpatialColumnNames);
        SpatialQueryResult queryResult = new SpatialQueryResult();
        while (result.next()) {
            ArrayList<JGeometry> geomteryObjectsList = new ArrayList<JGeometry>();
            for (int i = 0; i < spatialColumnNames.size(); ++i) {
                Object obj = result.getObject((String)spatialColumnNames.get(i));
                if (result.wasNull()) {
                    geomteryObjectsList.add(null);
                    continue;
                }
                STRUCT st1 = (STRUCT)obj;
                JGeometry geometry = JGeometry.load((STRUCT)st1);
                geomteryObjectsList.add(geometry);
            }
            queryResult.add(geomteryObjectsList);
        }
        result.close();
        ResultSet result1 = stat.executeQuery(sqlWithNoSpatialColumnNames);
        CachedRowSetImpl crs = new CachedRowSetImpl();
        crs.populate(result1);
        queryResult.setCachedRowSet(crs);
        result1.close();
        stat.close();
        this.freeConnection(conn);
        return queryResult;
    }

    public int insertUpdateOrDeleteData(String sql, ArrayList geometryList) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement ps = conn.prepareStatement(sql);
        for (int i = 0; i < geometryList.size(); ++i) {
            STRUCT obj = JGeometry.store((JGeometry)((JGeometry)geometryList.get(i)), (Connection)conn);
            ps.setObject(i + 1, obj);
        }
        boolean success = ps.execute();
        this.freeConnection(conn);
        if (success) {
            return 1;
        }
        return 0;
    }
}

