/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.FaultModelSummary;

public class FaultModelSummaryDB_DAO
implements Serializable {
    private static final String SEQUENCE_NAME = "Fault_Model_Summary_Sequence";
    private static final String TABLE_NAME = "Fault_Model_Summary";
    private static final String FAULT_MODEL_ID = "Fault_Model_Id";
    private static final String CONTRIBUTOR_ID = "Contributor_Id";
    private static final String FAULT_MODEL_NAME = "Fault_Model_Name";
    private DB_AccessAPI dbAccessAPI;

    public FaultModelSummaryDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public int addFaultModel(FaultModelSummary faultModel) throws InsertException {
        int faultModelId = -1;
        try {
            faultModelId = this.dbAccessAPI.getNextSequenceNumber(SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String sql = "insert into Fault_Model_Summary(Fault_Model_Id,Contributor_Id,Fault_Model_Name)  values (" + faultModelId + "," + SessionInfo.getContributor().getId() + ",'" + faultModel.getFaultModelName() + "')";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            faultModel.setFaultModelId(faultModelId);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        return faultModelId;
    }

    public boolean updateFaultModel(int faultModelId, FaultModelSummary faultModel) throws UpdateException {
        String sql = "update Fault_Model_Summary set Fault_Model_Name= '" + faultModel.getFaultModelName() + "'," + CONTRIBUTOR_ID + "=" + SessionInfo.getContributor().getId() + " where " + FAULT_MODEL_ID + "=" + faultModelId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public FaultModelSummary getFaultModel(int faultModelId) throws QueryException {
        FaultModelSummary faultModel = null;
        String condition = " where Fault_Model_Id=" + faultModelId;
        ArrayList faultModelList = this.query(condition);
        if (faultModelList.size() > 0) {
            faultModel = (FaultModelSummary)faultModelList.get(0);
        }
        return faultModel;
    }

    public boolean removeFaultModel(int faultModelId) throws UpdateException {
        String sql = "delete from Fault_Model_Summary  where Fault_Model_Id=" + faultModelId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public ArrayList getAllFaultModels() throws QueryException {
        return this.query(" ");
    }

    private ArrayList query(String condition) throws QueryException {
        ArrayList<FaultModelSummary> faultModelList = new ArrayList<FaultModelSummary>();
        String sql = "select Fault_Model_Id,Fault_Model_Name,Contributor_Id from Fault_Model_Summary" + condition;
        try {
            CachedRowSetImpl rs = this.dbAccessAPI.queryData(sql);
            ContributorDB_DAO contributorDAO = new ContributorDB_DAO(this.dbAccessAPI);
            while (rs.next()) {
                faultModelList.add(new FaultModelSummary(rs.getInt(FAULT_MODEL_ID), rs.getString(FAULT_MODEL_NAME), contributorDAO.getContributor(rs.getInt(CONTRIBUTOR_ID))));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultModelList;
    }
}

