/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.refFaultParamDb.dao.EstimateDAO_API;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;

public class MinMaxPrefEstimateDB_DAO
implements EstimateDAO_API {
    private static final String TABLE_NAME = "Min_Max_Pref_Est";
    private static final String MIN_X = "Min_X";
    private static final String MAX_X = "Max_X";
    private static final String PREF_X = "Pref_X";
    private static final String MIN_PROB = "Min_Prob";
    private static final String MAX_PROB = "Max_Prob";
    private static final String PREF_PROB = "Pref_Prob";
    private static final String EST_ID = "Est_Id ";
    private DB_AccessAPI dbAccessAPI;
    public static final String EST_TYPE_NAME = "MinMaxPrefEstimate";
    private static final String ERR_MSG = "This class just deals with Min/Max/Pref Estimates";

    public MinMaxPrefEstimateDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public MinMaxPrefEstimateDB_DAO() {
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public void addEstimate(int estimateInstanceId, Estimate estimate) throws InsertException {
        double prefProb;
        double maxProb;
        double minProb;
        double prefX;
        double maxX;
        if (!(estimate instanceof MinMaxPrefEstimate)) {
            throw new InsertException(ERR_MSG);
        }
        MinMaxPrefEstimate minMaxPrefEstimate = (MinMaxPrefEstimate)estimate;
        String colNames = "";
        String colVals = "";
        double minX = minMaxPrefEstimate.getMinimum();
        if (!Double.isNaN(minX)) {
            colNames = colNames + "Min_X,";
            colVals = colVals + minX + ",";
        }
        if (!Double.isNaN(maxX = minMaxPrefEstimate.getMaximum())) {
            colNames = colNames + "Max_X,";
            colVals = colVals + maxX + ",";
        }
        if (!Double.isNaN(prefX = minMaxPrefEstimate.getPreferred())) {
            colNames = colNames + "Pref_X,";
            colVals = colVals + prefX + ",";
        }
        if (!Double.isNaN(minProb = minMaxPrefEstimate.getMinimumProb())) {
            colNames = colNames + "Min_Prob,";
            colVals = colVals + minProb + ",";
        }
        if (!Double.isNaN(maxProb = minMaxPrefEstimate.getMaximumProb())) {
            colNames = colNames + "Max_Prob,";
            colVals = colVals + maxProb + ",";
        }
        if (!Double.isNaN(prefProb = minMaxPrefEstimate.getPreferredProb())) {
            colNames = colNames + "Pref_Prob,";
            colVals = colVals + prefProb + ",";
        }
        String sql = "insert into Min_Max_Pref_Est(" + colNames + EST_ID + ")" + " values (" + colVals + estimateInstanceId + ")";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public Estimate getEstimate(int estimateInstanceId) throws QueryException {
        MinMaxPrefEstimate estimate = null;
        String condition = " where Est_Id =" + estimateInstanceId;
        ArrayList estimateList = this.query(condition);
        if (estimateList.size() > 0) {
            estimate = (MinMaxPrefEstimate)estimateList.get(0);
        }
        return estimate;
    }

    public boolean removeEstimate(int estimateInstanceId) throws UpdateException {
        String sql = "delete from Min_Max_Pref_Est  where Est_Id =" + estimateInstanceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public String getEstimateTypeName() {
        return EST_TYPE_NAME;
    }

    private ArrayList query(String condition) throws QueryException {
        ArrayList<MinMaxPrefEstimate> estimateList = new ArrayList<MinMaxPrefEstimate>();
        String sql = "select Est_Id ,(Min_X+0) Min_X,(Max_X+0) Max_X,(Pref_X+0) Pref_X,(Min_Prob+0) Min_Prob,(Max_Prob+0) Max_Prob, (Pref_Prob+0) Pref_Prob from Min_Max_Pref_Est " + condition;
        try {
            CachedRowSetImpl rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                double minX = rs.getFloat(MIN_X);
                if (rs.wasNull()) {
                    minX = Double.NaN;
                }
                double maxX = rs.getFloat(MAX_X);
                if (rs.wasNull()) {
                    maxX = Double.NaN;
                }
                double prefX = rs.getFloat(PREF_X);
                if (rs.wasNull()) {
                    prefX = Double.NaN;
                }
                double minProb = rs.getFloat(MIN_PROB);
                if (rs.wasNull()) {
                    minProb = Double.NaN;
                }
                double maxProb = rs.getFloat(MAX_PROB);
                if (rs.wasNull()) {
                    maxProb = Double.NaN;
                }
                double prefProb = rs.getFloat(PREF_PROB);
                if (rs.wasNull()) {
                    prefProb = Double.NaN;
                }
                MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(minX, maxX, prefX, minProb, maxProb, prefProb);
                estimateList.add(estimate);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return estimateList;
    }
}

