/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.vo;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.opensha.commons.data.Location;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.FaultTraceUtils;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class FaultSectionPrefData
implements Serializable,
XMLSaveable,
Cloneable {
    public static final String XML_METADATA_NAME = "FaultSectionPrefData";
    private int sectionId = -1;
    private String sectionName;
    private String shortName;
    private double aveLongTermSlipRate;
    private double slipRateStdDev;
    private double aveDip;
    private double aveRake;
    private double aveUpperDepth;
    private double aveLowerDepth;
    private double aseismicSlipFactor;
    private FaultTrace faultTrace;
    private float dipDirection;

    public String getShortName() {
        return this.shortName;
    }

    public void setFaultSectionPrefData(FaultSectionPrefData faultSectionPrefData) {
        this.sectionId = faultSectionPrefData.getSectionId();
        this.sectionName = faultSectionPrefData.getSectionName();
        this.shortName = faultSectionPrefData.getShortName();
        this.aveLongTermSlipRate = faultSectionPrefData.getAveLongTermSlipRate();
        this.slipRateStdDev = faultSectionPrefData.getSlipRateStdDev();
        this.aveDip = faultSectionPrefData.getAveDip();
        this.aveRake = faultSectionPrefData.getAveRake();
        this.aveUpperDepth = faultSectionPrefData.getAveUpperDepth();
        this.aveLowerDepth = faultSectionPrefData.getAveLowerDepth();
        this.aseismicSlipFactor = faultSectionPrefData.getAseismicSlipFactor();
        this.faultTrace = faultSectionPrefData.getFaultTrace();
        this.dipDirection = faultSectionPrefData.getDipDirection();
    }

    public String toString() {
        String str = new String();
        str = str + "sectionId = " + this.getSectionId() + "\n";
        str = str + "sectionName = " + this.getSectionName() + "\n";
        str = str + "shortName = " + this.getShortName() + "\n";
        str = str + "aveLongTermSlipRate = " + this.getAveLongTermSlipRate() + "\n";
        str = str + "slipRateStdDev = " + this.getSlipRateStdDev() + "\n";
        str = str + "aveDip = " + this.getAveDip() + "\n";
        str = str + "aveRake = " + this.getAveRake() + "\n";
        str = str + "aveUpperDepth = " + this.getAveUpperDepth() + "\n";
        str = str + "aveLowerDepth = " + this.getAveLowerDepth() + "\n";
        str = str + "aseismicSlipFactor = " + this.getAseismicSlipFactor() + "\n";
        str = str + "dipDirection = " + this.getDipDirection() + "\n";
        str = str + "faultTrace:\n";
        for (int i = 0; i < this.getFaultTrace().size(); ++i) {
            Location loc = this.getFaultTrace().getLocationAt(i);
            str = str + "\t" + loc.getLatitude() + ", " + loc.getLongitude() + ", " + loc.getDepth() + "\n";
        }
        return str;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public double getAseismicSlipFactor() {
        return this.aseismicSlipFactor;
    }

    public void setAseismicSlipFactor(double aseismicSlipFactor) {
        this.aseismicSlipFactor = aseismicSlipFactor;
    }

    public double getAveDip() {
        return this.aveDip;
    }

    public void setAveDip(double aveDip) {
        this.aveDip = aveDip;
    }

    public double getAveLongTermSlipRate() {
        return this.aveLongTermSlipRate;
    }

    public void setAveLongTermSlipRate(double aveLongTermSlipRate) {
        this.aveLongTermSlipRate = aveLongTermSlipRate;
    }

    public double getAveLowerDepth() {
        return this.aveLowerDepth;
    }

    public void setAveLowerDepth(double aveLowerDepth) {
        this.aveLowerDepth = aveLowerDepth;
    }

    public double getAveRake() {
        return this.aveRake;
    }

    public void setAveRake(double aveRake) {
        this.aveRake = aveRake;
    }

    public double getAveUpperDepth() {
        return this.aveUpperDepth;
    }

    public void setAveUpperDepth(double aveUpperDepth) {
        this.aveUpperDepth = aveUpperDepth;
    }

    public float getDipDirection() {
        return this.dipDirection;
    }

    public void setDipDirection(float dipDirection) {
        this.dipDirection = dipDirection;
    }

    public FaultTrace getFaultTrace() {
        return this.faultTrace;
    }

    public void setFaultTrace(FaultTrace faultTrace) {
        this.faultTrace = faultTrace;
    }

    public int getSectionId() {
        return this.sectionId;
    }

    public void setSectionId(int sectionId) {
        this.sectionId = sectionId;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public double getLength() {
        return this.faultTrace.getTraceLength();
    }

    public double getDownDipWidth() {
        return (this.getAveLowerDepth() - this.getAveUpperDepth()) / Math.sin(this.getAveDip() * Math.PI / 180.0);
    }

    public ArrayList getSubSectionsList(double maxSubSectionLen) {
        ArrayList<FaultTrace> equalLengthSubsTrace = FaultTraceUtils.getEqualLengthSubsectionTraces(this.faultTrace, maxSubSectionLen);
        ArrayList<FaultSectionPrefData> subSectionList = new ArrayList<FaultSectionPrefData>();
        for (int i = 0; i < equalLengthSubsTrace.size(); ++i) {
            FaultSectionPrefData subSection = new FaultSectionPrefData();
            subSection.setFaultSectionPrefData(this);
            subSection.setFaultTrace(equalLengthSubsTrace.get(i));
            subSection.setSectionId(this.sectionId * 1000 + i);
            subSectionList.add(subSection);
            subSection.setSectionName(this.sectionName + " Subsection:" + (i + 1));
        }
        return subSectionList;
    }

    public double getSlipRateStdDev() {
        return this.slipRateStdDev;
    }

    public void setSlipRateStdDev(double slipRateStdDev) {
        this.slipRateStdDev = slipRateStdDev;
    }

    public SimpleFaultData getSimpleFaultData(boolean aseisReducesArea) {
        if (!aseisReducesArea) {
            SimpleFaultData simpleFaultData = new SimpleFaultData(this.getAveDip(), this.getAveLowerDepth(), this.getAveUpperDepth(), this.getFaultTrace());
            return simpleFaultData;
        }
        double depthToReduce = this.aseismicSlipFactor * (this.getAveLowerDepth() - this.getAveUpperDepth());
        double lowerDepth = this.getAveLowerDepth() - depthToReduce / 2.0;
        double upperDepth = this.getAveUpperDepth() + depthToReduce / 2.0;
        SimpleFaultData simpleFaultData = new SimpleFaultData(this.getAveDip(), lowerDepth, upperDepth, this.getFaultTrace());
        return simpleFaultData;
    }

    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("sectionId", this.getSectionId() + "");
        el.addAttribute("sectionName", this.getSectionName());
        el.addAttribute("shortName", this.getShortName());
        el.addAttribute("aveLongTermSlipRate", this.getAveLongTermSlipRate() + "");
        el.addAttribute("slipRateStdDev", this.getSlipRateStdDev() + "");
        el.addAttribute("aveDip", this.getAveDip() + "");
        el.addAttribute("aveRake", this.getAveRake() + "");
        el.addAttribute("aveUpperDepth", this.getAveUpperDepth() + "");
        el.addAttribute("aveLowerDepth", this.getAveLowerDepth() + "");
        el.addAttribute("aseismicSlipFactor", this.getAseismicSlipFactor() + "");
        el.addAttribute("dipDirection", this.getDipDirection() + "");
        FaultTrace trace = this.getFaultTrace();
        Element traceEl = el.addElement("FaultTrace");
        traceEl.addAttribute("name", trace.getName());
        for (int j = 0; j < trace.getNumLocations(); ++j) {
            Location loc = trace.getLocationAt(j);
            traceEl = loc.toXMLMetadata(traceEl);
        }
        return root;
    }

    public static FaultSectionPrefData fromXMLMetadata(Element el) throws InvocationTargetException {
        int sectionId = Integer.parseInt(el.attributeValue("sectionId"));
        String sectionName = el.attributeValue("sectionName");
        String shortName = el.attributeValue("shortName");
        double aveLongTermSlipRate = Double.parseDouble(el.attributeValue("aveLongTermSlipRate"));
        double aveDip = Double.parseDouble(el.attributeValue("aveDip"));
        double aveRake = Double.parseDouble(el.attributeValue("aveRake"));
        double aveUpperDepth = Double.parseDouble(el.attributeValue("aveUpperDepth"));
        double aveLowerDepth = Double.parseDouble(el.attributeValue("aveLowerDepth"));
        double aseismicSlipFactor = Double.parseDouble(el.attributeValue("aseismicSlipFactor"));
        float dipDirection = Float.parseFloat(el.attributeValue("dipDirection"));
        Element traceEl = el.element("FaultTrace");
        String traceName = traceEl.attributeValue("name");
        FaultTrace trace = new FaultTrace(traceName);
        Iterator traceIt = traceEl.elementIterator();
        while (traceIt.hasNext()) {
            Element locEl = (Element)traceIt.next();
            trace.addLocation(Location.fromXMLMetadata(locEl));
        }
        FaultSectionPrefData data = new FaultSectionPrefData();
        data.setSectionId(sectionId);
        data.setSectionName(sectionName);
        data.setShortName(shortName);
        data.setAveLongTermSlipRate(aveLongTermSlipRate);
        data.setAveDip(aveDip);
        data.setAveRake(aveRake);
        data.setAveUpperDepth(aveUpperDepth);
        data.setAveLowerDepth(aveLowerDepth);
        data.setAseismicSlipFactor(aseismicSlipFactor);
        data.setDipDirection(dipDirection);
        data.setFaultTrace(trace);
        return data;
    }

    public FaultSectionPrefData clone() {
        FaultSectionPrefData section = new FaultSectionPrefData();
        section.setFaultSectionPrefData(this);
        return section;
    }
}

