/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import org.dom4j.Element;
import org.opensha.commons.gridComputing.GridCalculationParameters;

public class HazardMapCalculationParameters
extends GridCalculationParameters {
    public static final String XML_METADATA_NAME = "HazardMapCalculationParameters";
    private int sitesPerJob;
    private double maxSourceDistance;
    private boolean useCVM;
    private boolean serializeERF;

    public HazardMapCalculationParameters(int maxWallTime, int sitesPerJob, double maxSourceDistance, boolean useCVM, boolean serializeERF) {
        super(maxWallTime);
        this.sitesPerJob = sitesPerJob;
        this.maxSourceDistance = maxSourceDistance;
        this.useCVM = useCVM;
        this.serializeERF = serializeERF;
    }

    public HazardMapCalculationParameters(Element parentElement) {
        super(parentElement, XML_METADATA_NAME);
        this.sitesPerJob = Integer.parseInt(this.element.attribute("sitesPerJob").getValue());
        this.maxSourceDistance = Double.parseDouble(this.element.attribute("maxSourceDistance").getValue());
        this.useCVM = Boolean.parseBoolean(this.element.attribute("useCVM").getValue());
        this.serializeERF = Boolean.parseBoolean(this.element.attribute("serializeERF").getValue());
    }

    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        xml.addAttribute("maxWallTime", this.maxWallTime + "");
        xml.addAttribute("sitesPerJob", this.sitesPerJob + "");
        xml.addAttribute("maxSourceDistance", (float)this.maxSourceDistance + "");
        xml.addAttribute("useCVM", this.useCVM + "");
        xml.addAttribute("serializeERF", this.serializeERF + "");
        return root;
    }

    public String toString() {
        String str = super.toString();
        str = str + "\n";
        str = str + "\tsitesPerJob: " + this.sitesPerJob + "\n";
        str = str + "\tmaxSourceDistance: " + this.maxSourceDistance + "\n";
        str = str + "\tuseCVM: " + this.useCVM + "\n";
        str = str + "\tserializeERF: " + this.serializeERF;
        return str;
    }

    public int getSitesPerJob() {
        return this.sitesPerJob;
    }

    public double getMaxSourceDistance() {
        return this.maxSourceDistance;
    }

    public boolean isUseCVM() {
        return this.useCVM;
    }

    public boolean isSerializeERF() {
        return this.serializeERF;
    }
}

