/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.region.Region;
import org.opensha.sha.earthquake.EqkSourceAPI;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.util.TectonicRegionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProbEqkSource
implements EqkSourceAPI,
NamedObjectAPI {
    protected String name = new String("ProbEqkSource");
    private TectonicRegionType tectonicRegionType = TectonicRegionType.ACTIVE_SHALLOW;
    protected ProbEqkRupture probEqkRupture;
    private int sourceIndex;
    protected boolean isPoissonian = true;
    private String info;

    public boolean isSourcePoissonian() {
        return this.isPoissonian;
    }

    @Override
    public Iterator getRupturesIterator() {
        ArrayList v = this.getRuptureList();
        return v.iterator();
    }

    public boolean isPoissonianSource() {
        return this.isPoissonian;
    }

    public abstract double getMinDistance(Site var1);

    @Override
    public abstract int getNumRuptures();

    @Override
    public abstract ProbEqkRupture getRupture(int var1);

    @Override
    public ProbEqkRupture getRuptureClone(int nRupture) {
        ProbEqkRupture eqkRupture = this.getRupture(nRupture);
        ProbEqkRupture eqkRuptureClone = (ProbEqkRupture)eqkRupture.clone();
        return eqkRuptureClone;
    }

    @Override
    public ArrayList getRuptureList() {
        ArrayList<ProbEqkRupture> v = new ArrayList<ProbEqkRupture>();
        for (int i = 0; i < this.getNumRuptures(); ++i) {
            v.add(this.getRuptureClone(i));
        }
        return v;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setInfo(String infoString) {
        this.info = new String(infoString);
    }

    public String getInfo() {
        return this.info;
    }

    public String getSourceMetadata() {
        String sourceMetadata = this.sourceIndex + "\t";
        sourceMetadata = sourceMetadata + this.getNumRuptures() + "\t";
        sourceMetadata = sourceMetadata + this.isPoissonian + "\t";
        sourceMetadata = sourceMetadata + (float)this.computeTotalProb() + "\t";
        sourceMetadata = sourceMetadata + "\"" + this.getName() + "\"";
        return sourceMetadata;
    }

    public double computeTotalProb() {
        return this.computeTotalProbAbove(-10.0);
    }

    public double computeTotalProbAbove(double mag) {
        return this.computeTotalProbAbove(mag, null);
    }

    public double computeApproxTotalProbAbove(double mag, Region region) {
        double totProb = 0.0;
        for (int i = 0; i < this.getNumRuptures(); ++i) {
            ProbEqkRupture tempRup = this.getRupture(i);
            if (tempRup.getMag() < mag) continue;
            totProb += this.getApproxRupProbWithinRegion(tempRup, region);
        }
        if (this.isPoissonian) {
            return 1.0 - Math.exp(totProb);
        }
        return totProb;
    }

    public double computeTotalProbAbove(double mag, Region region) {
        double totProb = 0.0;
        for (int i = 0; i < this.getNumRuptures(); ++i) {
            ProbEqkRupture tempRup = this.getRupture(i);
            if (tempRup.getMag() < mag) continue;
            totProb += this.getRupProbWithinRegion(tempRup, region);
        }
        if (this.isPoissonian) {
            return 1.0 - Math.exp(totProb);
        }
        return totProb;
    }

    private double getRupProbWithinRegion(ProbEqkRupture tempRup, Region region) {
        int numLocsInside = 0;
        int totPoints = 0;
        if (region != null) {
            ListIterator locIt = tempRup.getRuptureSurface().getLocationsIterator();
            while (locIt.hasNext()) {
                if (region.contains((Location)locIt.next())) {
                    ++numLocsInside;
                }
                ++totPoints;
            }
        } else {
            totPoints = numLocsInside = 1;
        }
        if (this.isPoissonian) {
            return Math.log(1.0 - tempRup.getProbability() * (double)numLocsInside / (double)totPoints);
        }
        return tempRup.getProbability() * (double)numLocsInside / (double)totPoints;
    }

    private double getApproxRupProbWithinRegion(ProbEqkRupture tempRup, Region region) {
        int numLocsInside = 0;
        int totPoints = 0;
        if (region != null) {
            EvenlyGriddedSurfaceAPI rupSurface = tempRup.getRuptureSurface();
            Location loc1 = rupSurface.getLocation(0, 0);
            Location loc2 = rupSurface.getLocation(0, rupSurface.getNumCols() - 1);
            if (region.contains(loc1) && region.contains(loc2)) {
                totPoints = numLocsInside = 1;
            } else {
                ListIterator locIt = rupSurface.getColumnIterator(0);
                while (locIt.hasNext()) {
                    if (region.contains((Location)locIt.next())) {
                        ++numLocsInside;
                    }
                    ++totPoints;
                }
            }
        } else {
            totPoints = numLocsInside = 1;
        }
        if (this.isPoissonian) {
            return Math.log(1.0 - tempRup.getProbability() * (double)numLocsInside / (double)totPoints);
        }
        return tempRup.getProbability() * (double)numLocsInside / (double)totPoints;
    }

    public ArrayList<ProbEqkRupture> drawRandomEqkRuptures() {
        ArrayList<ProbEqkRupture> rupList = new ArrayList<ProbEqkRupture>();
        if (this.isPoissonian) {
            for (int r = 0; r < this.getNumRuptures(); ++r) {
                int num;
                ProbEqkRupture rup = this.getRupture(r);
                double expected = -Math.log(1.0 - rup.getProbability());
                double rand = Math.random();
                double sum = 0.0;
                double factoral = 1.0;
                int maxNum = (int)Math.round(10.0 * expected) + 2;
                for (num = 0; num < maxNum; ++num) {
                    double prob;
                    if (num != 0) {
                        factoral *= (double)num;
                    }
                    if (rand <= (sum += (prob = Math.pow(expected, num) * Math.exp(-expected) / factoral))) break;
                }
                for (int i = 0; i < num; ++i) {
                    rupList.add((ProbEqkRupture)rup.clone());
                }
            }
        } else {
            throw new RuntimeException("drawRandomEqkRuptures(): Non poissonsources are not yet supported");
        }
        return rupList;
    }

    @Override
    public TectonicRegionType getTectonicRegionType() {
        return this.tectonicRegionType;
    }

    public void setTectonicRegionType(TectonicRegionType tectonicRegionType) {
        this.tectonicRegionType = tectonicRegionType;
    }
}

