/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.griddedForecast;

import java.util.ArrayList;
import java.util.Arrays;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.griddedForecast.STEP_AftershockForecast;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.step.calc.CompletenessMagCalc;
import org.opensha.step.calc.MaxLikeGR_Calc;
import org.opensha.step.calc.MaxLikeOmori_Calc;
import org.opensha.step.calc.OmoriRate_Calc;
import org.opensha.step.calc.RegionDefaults;

public class SequenceAfterHypoMagFreqDistForecast
extends STEP_AftershockForecast {
    private double seqNodeCompletenessMag;
    private double aVal_Sequence;
    private double bVal_Sequence;
    private double pVal_Sequence;
    private double cVal_Sequence;
    private double kVal_Sequence;
    private int numGridLocs;
    private double[] grid_Seq_kVal;
    private double[] grid_Seq_aVal;
    private double[] grid_Seq_bVal;
    private double[] grid_Seq_cVal;
    private double[] grid_Seq_pVal;
    public MaxLikeOmori_Calc omoriCalc;
    private double[] kScaler;
    private double dayStart;
    private double dayEnd;
    private ArrayList gridMagForecast;
    private HypoMagFreqDistAtLoc magDistLoc;
    private GriddedRegion aftershockZone;

    public SequenceAfterHypoMagFreqDistForecast(ObsEqkRupture mainshock, GriddedRegion aftershockZone, ObsEqkRupList aftershocks) {
        this.setMainShock(mainshock);
        this.setRegion(aftershockZone);
        this.afterShocks = aftershocks;
        this.aftershockZone = aftershockZone;
        this.numGridLocs = aftershockZone.getNodeCount();
        this.grid_Seq_aVal = new double[this.numGridLocs];
        this.grid_Seq_bVal = new double[this.numGridLocs];
        this.grid_Seq_cVal = new double[this.numGridLocs];
        this.grid_Seq_pVal = new double[this.numGridLocs];
        this.grid_Seq_kVal = new double[this.numGridLocs];
        this.omoriCalc = new MaxLikeOmori_Calc();
    }

    public void set_SequenceRJParms() {
        ObsEqkRupList aftershockListComplete = this.afterShocks.getObsEqkRupsAboveMag(this.seqNodeCompletenessMag);
        MaxLikeGR_Calc maxLikeGR_Calc = new MaxLikeGR_Calc();
        maxLikeGR_Calc.setMags(aftershockListComplete);
        this.aVal_Sequence = maxLikeGR_Calc.get_aValueMaxLike();
        this.bVal_Sequence = maxLikeGR_Calc.get_bValueMaxLike();
    }

    public void set_SequenceOmoriParms() {
        ObsEqkRupList aftershockListComplete = this.afterShocks.getObsEqkRupsAboveMag(this.seqNodeCompletenessMag);
        if (this.useFixed_cValue) {
            this.omoriCalc.set_AfterShockListFixed_c(aftershockListComplete);
        } else {
            this.omoriCalc.set_AfterShockList(aftershockListComplete);
        }
        this.pVal_Sequence = this.omoriCalc.get_p_value();
        this.cVal_Sequence = this.omoriCalc.get_c_value();
        this.kVal_Sequence = this.omoriCalc.get_k_value();
    }

    public void fillGridWithSeqParms() {
        this.numGridLocs = this.getRegion().getNodeCount();
        this.grid_Seq_aVal = new double[this.numGridLocs];
        this.grid_Seq_bVal = new double[this.numGridLocs];
        this.grid_Seq_cVal = new double[this.numGridLocs];
        this.grid_Seq_pVal = new double[this.numGridLocs];
        this.grid_Seq_kVal = new double[this.numGridLocs];
        this.set_Gridded_Seq_aValue();
        this.set_Gridded_Seq_bValue();
        this.set_Gridded_Seq_cValue();
        this.set_Gridded_Seq_kValue();
        this.set_Gridded_Seq_pValue();
    }

    public void set_kScaler(double[] kScaler) {
        this.kScaler = kScaler;
    }

    public void set_Gridded_Seq_kValue() {
        int numInd = this.kScaler.length;
        for (int indLoop = 0; indLoop < numInd - 1; ++indLoop) {
            this.grid_Seq_kVal[indLoop] = this.kVal_Sequence * this.kScaler[indLoop];
        }
    }

    private ArrayList getSeqMagForecast() {
        double[] rjParms = new double[4];
        double[] forecastDays = new double[2];
        OmoriRate_Calc omoriCalc = new OmoriRate_Calc();
        forecastDays[0] = this.dayStart;
        forecastDays[1] = this.dayEnd;
        rjParms[1] = this.cVal_Sequence;
        rjParms[2] = this.pVal_Sequence;
        omoriCalc.setTimeParms(forecastDays);
        int numForecastMags = 1 + (int)((this.maxForecastMag - this.minForecastMag) / this.deltaForecastMag);
        double[] magForecast = new double[numForecastMags];
        int nodeLoop = 0;
        for (int numNodes = this.grid_Seq_kVal.length; nodeLoop < numNodes; ++numNodes) {
            rjParms[0] = this.grid_Seq_kVal[nodeLoop];
            omoriCalc.set_OmoriParms(rjParms);
            double totalForecast = omoriCalc.get_OmoriRate();
            GutenbergRichterMagFreqDist GR_Dist = new GutenbergRichterMagFreqDist(this.aVal_Sequence, totalForecast, this.minForecastMag, this.maxForecastMag, numForecastMags);
            for (int magLoop = 0; magLoop < numForecastMags; ++magLoop) {
                magForecast[magLoop] = GR_Dist.getIncrRate(magLoop);
            }
            this.gridMagForecast.add(magForecast);
        }
        return this.gridMagForecast;
    }

    public HypoMagFreqDistAtLoc calcHypoMagFreqDistAtLoc(int gridIndex) {
        double[] rjParms = new double[4];
        double[] forecastDays = new double[2];
        int numNodes = this.grid_Seq_kVal.length;
        OmoriRate_Calc omoriCalc = new OmoriRate_Calc();
        forecastDays[0] = this.dayStart;
        forecastDays[1] = this.dayEnd;
        rjParms[1] = this.cVal_Sequence;
        rjParms[2] = this.pVal_Sequence;
        omoriCalc.setTimeParms(forecastDays);
        int numForecastMags = 1 + (int)((this.maxForecastMag - this.minForecastMag) / this.deltaForecastMag);
        rjParms[0] = this.grid_Seq_kVal[gridIndex];
        omoriCalc.set_OmoriParms(rjParms);
        double totalForecast = omoriCalc.get_OmoriRate();
        GutenbergRichterMagFreqDist GR_Dist = new GutenbergRichterMagFreqDist(this.aVal_Sequence, totalForecast, this.minForecastMag, this.maxForecastMag, numForecastMags);
        IncrementalMagFreqDist[] dist = new IncrementalMagFreqDist[]{GR_Dist};
        Location gridLoc = this.getRegion().locationForIndex(gridIndex);
        this.magDistLoc = new HypoMagFreqDistAtLoc(dist, gridLoc);
        return this.magDistLoc;
    }

    public void set_Gridded_Seq_aValue() {
        Arrays.fill(this.grid_Seq_aVal, this.aVal_Sequence);
    }

    public void set_Gridded_Seq_bValue() {
        Arrays.fill(this.grid_Seq_bVal, this.bVal_Sequence);
    }

    public void set_Gridded_Seq_pValue() {
        Arrays.fill(this.grid_Seq_pVal, this.pVal_Sequence);
    }

    public void set_Gridded_Seq_cValue() {
        Arrays.fill(this.grid_Seq_cVal, this.cVal_Sequence);
    }

    public void calc_SeqNodeCompletenessMag() {
        CompletenessMagCalc compMagCalc = new CompletenessMagCalc(this.getAfterShocks());
        double magComplete = compMagCalc.getMcBest() + RegionDefaults.addToMc;
        if (this.mainShock.getMag() >= 7.0) {
            magComplete = 4.0;
        }
        System.out.println("Seq Mc Best = " + compMagCalc.getMcBest());
        System.out.println("Seq Mc Synth = " + compMagCalc.getMcSynth());
        System.out.println("Seq Mc Curv = " + compMagCalc.getMcMaxCurv());
        if (magComplete > this.seqNodeCompletenessMag) {
            this.seqNodeCompletenessMag = magComplete;
        }
        System.out.println("SET Mc  = " + this.seqNodeCompletenessMag);
    }

    public double get_aValSequence() {
        return this.aVal_Sequence;
    }

    public double get_bValSequence() {
        return this.bVal_Sequence;
    }

    public double get_pValSequence() {
        return this.pVal_Sequence;
    }

    public double get_cVal_Sequence() {
        return this.cVal_Sequence;
    }

    public double get_kVal_SequenceAtLoc(int ithLocation) {
        return this.grid_Seq_kVal[ithLocation];
    }

    public double getSeqNodeCompletenessMag() {
        return this.seqNodeCompletenessMag;
    }

    public GriddedRegion getAftershockZone() {
        return this.aftershockZone;
    }

    public void setAftershockZone(GriddedRegion aftershockZone) {
        this.aftershockZone = aftershockZone;
        super.setAfterShockZone(aftershockZone);
    }
}

