/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.griddedForecast;

import java.util.ArrayList;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.griddedForecast.STEP_AftershockForecast;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.step.calc.MaxLikeOmori_Calc;
import org.opensha.step.calc.OmoriRate_Calc;
import org.opensha.step.calc.ReasenbergJonesGriddedParms_Calc;
import org.opensha.step.calc.RegionDefaults;

public class SpatialAfterHypoMagFreqDistForecast
extends STEP_AftershockForecast {
    private double[] spaNodeCompletenessMag;
    private double[] grid_Spa_kValue;
    private double[] grid_Spa_aValue;
    private double[] grid_Spa_bValue;
    private double[] grid_Spa_cValue;
    private double[] grid_Spa_pValue;
    public MaxLikeOmori_Calc omoriCalc;
    private ArrayList rjParms;
    private ReasenbergJonesGriddedParms_Calc rjcalc;
    private GriddedRegion aftershockZone;
    private ObsEqkRupList aftershocks;
    private double dayStart;
    private double dayEnd;
    private ArrayList gridMagForecast;
    private HypoMagFreqDistAtLoc magDistLoc;
    private double searchRadius;

    public SpatialAfterHypoMagFreqDistForecast(ObsEqkRupture mainshock, GriddedRegion aftershockZone, ObsEqkRupList aftershocks) {
        this.setMainShock(mainshock);
        this.setRegion(aftershockZone);
        this.aftershocks = aftershocks;
        this.aftershockZone = aftershockZone;
    }

    public void calc_GriddedRJParms() {
        if (this.useFixed_cValue) {
            this.rjcalc = new ReasenbergJonesGriddedParms_Calc(this.aftershockZone, this.aftershocks);
            this.searchRadius = this.rjcalc.getGridSearchRadius();
        } else {
            this.rjcalc = new ReasenbergJonesGriddedParms_Calc(this.aftershockZone, this.aftershocks, this.useFixed_cValue);
            this.searchRadius = this.rjcalc.getGridSearchRadius();
        }
        this.rjcalc.set_constantAddToCompleteness(RegionDefaults.addToMc);
        this.rjParms = this.rjcalc.getAllGriddedVals();
    }

    public void setAllGridedRJ_Parms() {
        this.grid_Spa_aValue = (double[])this.rjParms.get(0);
        this.grid_Spa_bValue = (double[])this.rjParms.get(1);
        this.grid_Spa_pValue = (double[])this.rjParms.get(2);
        this.grid_Spa_cValue = (double[])this.rjParms.get(4);
        this.grid_Spa_kValue = (double[])this.rjParms.get(3);
        this.spaNodeCompletenessMag = (double[])this.rjParms.get(5);
    }

    public void set_Gridded_Spa_aValue() {
        this.grid_Spa_aValue = (double[])this.rjParms.get(0);
    }

    public void set_Gridded_Spa_bValue() {
        this.grid_Spa_bValue = (double[])this.rjParms.get(1);
    }

    public void set_Gridded_Spa_pValue() {
        this.grid_Spa_pValue = (double[])this.rjParms.get(2);
    }

    public void set_Gridded_Spa_cValue() {
        this.grid_Spa_cValue = (double[])this.rjParms.get(4);
    }

    public void set_Gridded_Spa_kValue() {
        this.grid_Spa_kValue = (double[])this.rjParms.get(3);
    }

    public void calc_spaNodeCompletenessMag() {
        this.spaNodeCompletenessMag = (double[])this.rjParms.get(5);
    }

    private ArrayList getSpaMagForecast() {
        double[] rjParms = new double[4];
        double[] forecastDays = new double[2];
        OmoriRate_Calc omoriCalc = new OmoriRate_Calc();
        forecastDays[0] = this.dayStart;
        forecastDays[1] = this.dayEnd;
        omoriCalc.setTimeParms(forecastDays);
        int numForecastMags = 1 + (int)((this.maxForecastMag - this.minForecastMag) / this.deltaForecastMag);
        double[] magForecast = new double[numForecastMags];
        int nodeLoop = 0;
        for (int numNodes = this.grid_Spa_kValue.length; nodeLoop < numNodes; ++numNodes) {
            rjParms[0] = this.grid_Spa_kValue[nodeLoop];
            rjParms[1] = this.grid_Spa_cValue[nodeLoop];
            rjParms[2] = this.grid_Spa_pValue[nodeLoop];
            omoriCalc.set_OmoriParms(rjParms);
            double totalForecast = omoriCalc.get_OmoriRate();
            GutenbergRichterMagFreqDist GR_Dist = new GutenbergRichterMagFreqDist(this.grid_Spa_aValue[nodeLoop], totalForecast, this.minForecastMag, this.maxForecastMag, numForecastMags);
            for (int magLoop = 0; magLoop < numForecastMags; ++magLoop) {
                magForecast[magLoop] = GR_Dist.getIncrRate(magLoop);
            }
            this.gridMagForecast.add(magForecast);
        }
        return this.gridMagForecast;
    }

    public HypoMagFreqDistAtLoc calcHypoMagFreqDistAtLoc(int gridIndex) {
        double[] rjParms = new double[4];
        double[] forecastDays = new double[2];
        int numNodes = this.grid_Spa_kValue.length;
        OmoriRate_Calc omoriCalc = new OmoriRate_Calc();
        forecastDays[0] = this.dayStart;
        forecastDays[1] = this.dayEnd;
        omoriCalc.setTimeParms(forecastDays);
        int numForecastMags = 1 + (int)((this.maxForecastMag - this.minForecastMag) / this.deltaForecastMag);
        rjParms[0] = this.grid_Spa_kValue[gridIndex];
        rjParms[1] = this.grid_Spa_cValue[gridIndex];
        rjParms[2] = this.grid_Spa_pValue[gridIndex];
        omoriCalc.set_OmoriParms(rjParms);
        double totalForecast = omoriCalc.get_OmoriRate();
        GutenbergRichterMagFreqDist GR_Dist = new GutenbergRichterMagFreqDist(this.grid_Spa_aValue[gridIndex], totalForecast, this.minForecastMag, this.maxForecastMag, numForecastMags);
        IncrementalMagFreqDist[] dist = new IncrementalMagFreqDist[]{GR_Dist};
        Location gridLoc = this.getRegion().locationForIndex(gridIndex);
        this.magDistLoc = new HypoMagFreqDistAtLoc(dist, gridLoc);
        return this.magDistLoc;
    }

    public double[] get_gridded_Spa_aValue() {
        return this.grid_Spa_aValue;
    }

    public double[] get_gridded_Spa_bValue() {
        return this.grid_Spa_bValue;
    }

    public double[] get_gridded_Spa_pValue() {
        return this.grid_Spa_pValue;
    }

    public double[] get_gridded_Spa_kValue() {
        return this.grid_Spa_kValue;
    }

    public double[] get_gridded_Spa_cValue() {
        return this.grid_Spa_cValue;
    }

    public double[] getGriddedCompletenessMag() {
        return this.spaNodeCompletenessMag;
    }

    public double get_Spa_aValueAtLoc(int ithLocation) {
        return this.grid_Spa_aValue[ithLocation];
    }

    public double get_Spa_bValueAtLoc(int ithLocation) {
        return this.grid_Spa_bValue[ithLocation];
    }

    public double get_Spa_pValueAtLoc(int ithLocation) {
        return this.grid_Spa_pValue[ithLocation];
    }

    public double get_Spa_kValueAtLoc(int ithLocation) {
        return this.grid_Spa_kValue[ithLocation];
    }

    public double get_Spa_cValueAtLoc(int ithLocation) {
        return this.grid_Spa_cValue[ithLocation];
    }

    public double getCompletenessMagAtLoc(int ithLocation) {
        return this.spaNodeCompletenessMag[ithLocation];
    }

    public double getGridSearchRadius() {
        return this.searchRadius;
    }

    public void setAftershockZone(GriddedRegion aftershockZone) {
        this.aftershockZone = aftershockZone;
        super.setAfterShockZone(aftershockZone);
    }
}

